/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcTimeUtil;
import ext.lib.fx.control.FxDateField;
import ext.lib.fx.control.FxTimeField;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxUtil;
import java.util.Calendar;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;

public class FxDateTimePane
extends FxFlowPane {
    private int mode;
    public FxDateField dateField = new FxDateField();
    public FxTimeField timeField = new FxTimeField();

    public FxDateTimePane(int mode) throws Exception {
        super(21);
        this.setMode(mode);
    }

    public void setMode(int mode) throws Exception {
        this.mode = mode;
        this.removeAll();
        this.topMargin = 0.0;
        this.leftMargin = 0.0;
        this.leftRightSpace = 0.0;
        FxNodeUnit nodeUnit = null;
        int textSize = 0;
        switch (mode) {
            case 1: {
                nodeUnit = new FxNodeUnit(null, new Node[]{this.dateField});
                textSize = 10;
                break;
            }
            case 2: {
                nodeUnit = new FxNodeUnit(null, new Node[]{this.dateField, this.timeField});
                textSize = 19;
                break;
            }
            case 3: {
                nodeUnit = new FxNodeUnit(null, new Node[]{this.timeField});
                textSize = 8;
                break;
            }
            case 11: {
                nodeUnit = new FxNodeUnit(null, new Node[]{this.dateField});
                textSize = 7;
            }
        }
        this.addNodeUnit(nodeUnit);
        Dimension2D dim = FxUtil.getTextFieldSize(FxFontUtil.getDefaultFont(), textSize);
        this.setPrefWidth(dim.getWidth());
    }

    public Calendar getCalendar() throws Exception {
        Calendar calendar = this.dateField.getCalendar();
        if (calendar != null) {
            BcTimeUtil.setTimeField(calendar, this.timeField.getHHmmss());
        }
        return calendar;
    }

    public void setCalendar(Calendar calendar) throws Exception {
        this.dateField.setCalendar(calendar);
        this.timeField.setCalendar(calendar);
    }

    public void setCalendar(Integer yyyyMMdd, Short HHmm) throws Exception {
        if (yyyyMMdd == null) {
            this.dateField.setCalendar(null);
        } else {
            this.dateField.setCalendar(BcTimeUtil.toCalendar(yyyyMMdd));
        }
        if (HHmm == null) {
            this.timeField.setCalendar(null);
        } else {
            Calendar calendar = BcTimeUtil.createCalendar();
            BcTimeUtil.setTimeField(calendar, HHmm);
            this.timeField.setCalendar(calendar);
        }
    }

    public void setCalendar(Integer yyyyMMdd) throws Exception {
        this.setCalendar(yyyyMMdd, (short)0);
    }

    public void setEditable(boolean editable) throws Exception {
        this.dateField.setEditable(editable);
        this.timeField.setEditable(editable);
    }
}

