/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class PropertiesFileUtil {
    private static final String CLASS_NAME = PropertiesFileUtil.class.getName();
    private static final String DEFAULT_FILE_NAME = "ojdbc.properties";
    private static final String ALIAS_FILE_PREFIX = "ojdbc_";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String DEFAULT_PATH_LIST_ENTRY = "default";
    private static final String[] DEFAULT_PATH_LIST = new String[]{"default"};
    private static final String FILE_SCHEME = "file://";
    private static final String PREFIXED_CONNECTION_PROPERTY_DATABASE = "oracle.jdbc.database";
    private static final int MAX_PATH_LENGTH = 40000;
    private static final String MAX_PATH_LENGTH_MSG = "File path is too long";
    private static final int MAX_FILES = 20;
    private static final String MAX_FILES_MSG = "Too many files";
    private static final int MAX_FILE_SIZE = 1000000;
    private static final String MAX_FILE_SIZE_MSG = "File is too large";
    private static final String NULL_CHARACTER_PATH_MSG = "Path contains the null character";
    private static final String DOES_NOT_EXIST_MSG = "File does not exist";
    private static final String NOT_REGULAR_MSG = "Not a regular file";
    private static final Pattern VALID_TNS_ALIAS = Pattern.compile("\\w+");

    private PropertiesFileUtil() {
    }

    @Blind(value=PropertiesBlinder.class)
    static Properties loadPropertiesFromFile(String configFileProperty, String tnsAdmin, boolean fileOverridesTnsAdmin, String connectIdentifier, boolean fileOverridesConnectIdentifier) throws SQLException {
        String[] filePaths;
        Properties result = null;
        try {
            filePaths = PropertiesFileUtil.getFileList(configFileProperty);
        }
        catch (IOException ioEx) {
            SQLException sqlEx = DatabaseError.createSqlException(1700);
            sqlEx.initCause(ioEx).fillInStackTrace();
            throw sqlEx;
        }
        int i = filePaths.length;
        while (i > 0) {
            String filePath;
            if ((filePath = filePaths[--i].trim()).isEmpty()) continue;
            try {
                result = filePath.equals(DEFAULT_PATH_LIST_ENTRY) ? PropertiesFileUtil.loadDefaultFiles(tnsAdmin, connectIdentifier, fileOverridesConnectIdentifier, result) : PropertiesFileUtil.loadUserFile(filePath, tnsAdmin, result);
            }
            catch (IOException ioEx) {
                SQLException sqlEx = DatabaseError.createSqlException(1700, filePath);
                sqlEx.initCause(ioEx).fillInStackTrace();
                throw sqlEx;
            }
            if (!fileOverridesTnsAdmin && tnsAdmin != null || result == null) continue;
            tnsAdmin = result.getProperty("oracle.net.tns_admin", tnsAdmin);
        }
        return result;
    }

    private static final String[] getFileList(String configFileProperty) throws IOException {
        String[] filePaths;
        if (configFileProperty == null) {
            filePaths = DEFAULT_PATH_LIST;
        } else {
            if (configFileProperty.length() > 40000) {
                throw new IOException(MAX_PATH_LENGTH_MSG);
            }
            filePaths = configFileProperty.split(",");
            if (filePaths.length > 20) {
                throw new IOException(MAX_FILES_MSG);
            }
        }
        return filePaths;
    }

    @Blind(value=PropertiesBlinder.class)
    private static Properties loadDefaultFiles(String tnsAdmin, String connectIdentifier, boolean fileOverridesConnectIdentifier, @Blind(value=PropertiesBlinder.class) Properties result) throws SQLException, IOException {
        Properties defaultProperties = null;
        if (tnsAdmin != null && !(tnsAdmin = tnsAdmin.trim()).isEmpty()) {
            Path defaultPath = PropertiesFileUtil.validatePath(false, tnsAdmin, DEFAULT_FILE_NAME);
            if (defaultPath == null) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "loadDefaultFiles", "The driver will not attempt to read from ojdbc.properties due to a failed validation check.", null, null);
            } else {
                defaultProperties = PropertiesFileUtil.loadProperties(false, defaultPath);
                if (defaultProperties != null) {
                    PropertiesFileUtil.filterTnsAdmin(defaultProperties, DEFAULT_FILE_NAME);
                    PropertiesFileUtil.processExpressions(defaultProperties, tnsAdmin);
                }
            }
            if (fileOverridesConnectIdentifier || connectIdentifier == null) {
                connectIdentifier = PropertiesFileUtil.resolveConnectIdentifier(result, defaultProperties, connectIdentifier);
            }
            result = PropertiesFileUtil.loadAliasedFile(tnsAdmin, connectIdentifier, result);
        }
        return PropertiesFileUtil.mergeProperties(result, defaultProperties);
    }

    @Blind(value=PropertiesBlinder.class)
    private static Properties loadAliasedFile(String tnsAdmin, String connectIdentifier, @Blind(value=PropertiesBlinder.class) Properties result) throws IOException, SQLException {
        Properties aliasedProperties = null;
        if (connectIdentifier != null && !(connectIdentifier = connectIdentifier.trim()).isEmpty()) {
            if (connectIdentifier.length() > 40000) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "loadAliasedFile", "The driver will not attempt to read from an aliased properties file. The connect identifier is too long.", null, null);
            } else if (!VALID_TNS_ALIAS.matcher(connectIdentifier).matches()) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "loadAliasedFile", "The driver will not attempt to read from an aliased properties file. The connect identifier does not match a TNS alias syntax, where all characters belong to the set [a-z, A-Z, 0-9, _]", null, null);
            } else {
                String alias = connectIdentifier;
                Path aliasedPath = PropertiesFileUtil.validatePath(false, tnsAdmin, ALIAS_FILE_PREFIX + alias + PROPERTIES_EXTENSION);
                if (aliasedPath == null) {
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "loadAliasedFile", "The driver will not attempt to read from ojdbc_<alias>.properties due to a failed validation check.", null, null);
                } else {
                    aliasedProperties = PropertiesFileUtil.loadProperties(false, aliasedPath);
                    if (aliasedProperties != null) {
                        String fileName = aliasedPath.getFileName().toString();
                        PropertiesFileUtil.filterTnsAdmin(aliasedProperties, fileName);
                        PropertiesFileUtil.filterConnectIdentifier(aliasedProperties, fileName);
                        PropertiesFileUtil.processExpressions(aliasedProperties, tnsAdmin);
                    }
                }
            }
        }
        return PropertiesFileUtil.mergeProperties(result, aliasedProperties);
    }

    @Blind(value=PropertiesBlinder.class)
    private static Properties loadUserFile(String filePath, String tnsAdmin, @Blind(value=PropertiesBlinder.class) Properties result) throws IOException, SQLException {
        Path userPath = filePath.regionMatches(true, 0, FILE_SCHEME, 0, FILE_SCHEME.length()) ? PropertiesFileUtil.validateURI(filePath) : PropertiesFileUtil.validatePath(true, filePath, new String[0]);
        Properties userProperties = PropertiesFileUtil.loadProperties(true, userPath);
        PropertiesFileUtil.processExpressions(userProperties, tnsAdmin);
        return PropertiesFileUtil.mergeProperties(result, userProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties loadProperties(boolean errorIfInvalid, Path path) throws IOException {
        try {
            if (!PropertiesFileUtil.validateFile(errorIfInvalid, path)) {
                return null;
            }
            try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                Properties properties = new Properties();
                properties.load(inStream);
                Properties properties2 = properties;
                return properties2;
            }
        }
        catch (IllegalArgumentException badFormat) {
            throw new IOException(badFormat);
        }
    }

    private static boolean validateFile(boolean throwError, Path path) throws IOException {
        IOException err = null;
        if (!Files.exists(path, new LinkOption[0])) {
            err = new IOException("File does not exist: " + path.toAbsolutePath());
        } else if (!Files.isRegularFile(path, new LinkOption[0])) {
            err = new IOException("Not a regular file: " + path.toAbsolutePath());
        } else if (Files.size(path) > 1000000L) {
            err = new IOException("File is too large: " + path.toAbsolutePath());
        }
        if (err == null) {
            return true;
        }
        if (throwError) {
            throw err;
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "validateFile", "The driver will not load properties from {0} due to a failed validation check: {1}", (String)null, null, (Object)path.toAbsolutePath(), (Object)err.getMessage());
        return false;
    }

    private static Path validatePath(boolean throwError, String first, String ... more) throws IOException {
        IOException err = null;
        String current = first;
        int next = 0;
        int totalLength = 0;
        while (err == null && current != null) {
            if (current.indexOf(0) >= 0) {
                err = new IOException(NULL_CHARACTER_PATH_MSG);
                break;
            }
            if ((totalLength += current.length()) > 40000) {
                err = new IOException(MAX_PATH_LENGTH_MSG);
                break;
            }
            current = more != null && next < more.length ? more[next++] : null;
        }
        if (err == null) {
            return Paths.get(first, more);
        }
        if (throwError) {
            throw err;
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "validatePath", "The driver will not load properties from a file due to a failed validation check: {0}", (String)null, (Throwable)null, (Object)err.getMessage());
        return null;
    }

    private static Path validateURI(String uriString) throws IOException {
        if (uriString.indexOf(0) >= 0) {
            throw new IOException(NULL_CHARACTER_PATH_MSG);
        }
        if (uriString.length() > 40000) {
            throw new IOException(MAX_PATH_LENGTH_MSG);
        }
        return Paths.get(URI.create(uriString));
    }

    @Blind(value=PropertiesBlinder.class)
    private static Properties mergeProperties(@Blind(value=PropertiesBlinder.class) Properties from, @Blind(value=PropertiesBlinder.class) Properties into) {
        if (into == null) {
            return from;
        }
        if (from == null) {
            return into;
        }
        into.putAll((Map<?, ?>)from);
        return into;
    }

    private static void filterTnsAdmin(@Blind(value=PropertiesBlinder.class) Properties input, String fileName) {
        if (null != input.remove("oracle.net.tns_admin")) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "filterTnsAdmin", "Ignoring the value of oracle.net.tns_admin defined in {0}; A TNS Admin directory was already recognized in order to read the file.", (String)null, (Throwable)null, (Object)fileName);
        }
    }

    private static void filterConnectIdentifier(@Blind(value=PropertiesBlinder.class) Properties input, String fileName) {
        if (null != input.remove("database")) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "filterConnectIdentifier", "Ignoring the value of database defined in {0}. A connect identifier was already recognized in order to read the file.", (String)null, (Throwable)null, (Object)fileName);
        }
        if (null != input.remove(PREFIXED_CONNECTION_PROPERTY_DATABASE)) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "filterConnectIdentifier", "Ignoring the value of oracle.jdbc.database defined in {0}. A connect identifier was already recognized in order to read the file.", (String)null, (Throwable)null, (Object)fileName);
        }
    }

    private static String resolveConnectIdentifier(@Blind(value=PropertiesBlinder.class) Properties result, @Blind(value=PropertiesBlinder.class) Properties ojdbcProperties, String defaultValue) {
        String connectIdentifier = null;
        if (result != null && (connectIdentifier = result.getProperty("database")) == null) {
            connectIdentifier = result.getProperty(PREFIXED_CONNECTION_PROPERTY_DATABASE);
        }
        if (connectIdentifier == null && ojdbcProperties != null && (connectIdentifier = ojdbcProperties.getProperty("database")) == null) {
            connectIdentifier = ojdbcProperties.getProperty(PREFIXED_CONNECTION_PROPERTY_DATABASE);
        }
        return connectIdentifier == null ? defaultValue : connectIdentifier;
    }

    private static void processExpressions(@Blind(value=PropertiesBlinder.class) Properties loadedFromFile, String tnsAdmin) throws SQLException {
        if (loadedFromFile == null || loadedFromFile.isEmpty()) {
            return;
        }
        Set<String> stringKeys = loadedFromFile.stringPropertyNames();
        String[] sortedKeys = new String[stringKeys.size()];
        Arrays.sort(stringKeys.toArray(sortedKeys));
        for (String key : sortedKeys) {
            String value = loadedFromFile.getProperty(key);
            try {
                loadedFromFile.setProperty(key, Interpreter.interpret(value, tnsAdmin));
            }
            catch (Exception ex) {
                SQLException sqlEx = DatabaseError.createSqlException(1701, key);
                sqlEx.initCause(ex).fillInStackTrace();
                throw sqlEx;
            }
        }
    }

    private static class Interpreter {
        private static final char DOLLAR = '$';
        private static final char QUESTION_MARK = '?';
        private static final char OPEN_BRACE = '{';
        private static final char CLOSE_BRACE = '}';
        private static final String FILE_SEPERATOR_PROPERTY = "/";
        private static final String ORACLE_HOME = "ORACLE_HOME";
        private static final Object TNS_ADMIN = "TNS_ADMIN";

        private Interpreter() {
        }

        private static String interpret(String input, String tnsAdmin) throws IOException {
            StringBuilder output = new StringBuilder(input.length());
            int pos = 0;
            block4: while (pos < input.length()) {
                char next = input.charAt(pos);
                switch (next) {
                    case '$': {
                        pos = Interpreter.readDollar(input, pos + 1, output, tnsAdmin);
                        continue block4;
                    }
                    case '?': {
                        pos = Interpreter.readQuestionMark(input, pos + 1, output);
                        continue block4;
                    }
                }
                output.append(next);
                ++pos;
            }
            return output.toString();
        }

        private static int readQuestionMark(String input, int pos, StringBuilder output) throws IOException {
            if (pos < input.length() && '?' == input.charAt(pos)) {
                output.append('?');
                return pos + 1;
            }
            String value = System.getenv(ORACLE_HOME);
            if (value == null) {
                throw new IOException("Environment variable is not set: ORACLE_HOME. ('?' is interpreted as $ORACLE_HOME)");
            }
            output.append(value);
            return pos;
        }

        private static int readDollar(String input, int pos, StringBuilder output, String tnsAdmin) throws IOException {
            if (pos == input.length()) {
                output.append('$');
                return pos;
            }
            char next = input.charAt(pos);
            switch (next) {
                case '{': {
                    return Interpreter.readDollarExpression(input, pos + 1, output, tnsAdmin);
                }
                case '$': {
                    output.append('$');
                    return pos + 1;
                }
            }
            output.append('$');
            output.append(next);
            return pos + 1;
        }

        private static int readDollarExpression(String input, int pos, StringBuilder output, String tnsAdmin) throws IOException {
            String value;
            int end = input.indexOf(125, pos);
            if (end == pos) {
                throw new IOException("${identifier} expression has a zero length identifier");
            }
            if (end == -1) {
                throw new IOException("${identifier} expression is missing a closing brace");
            }
            String name = input.substring(pos, end);
            if (name.equals(FILE_SEPERATOR_PROPERTY)) {
                value = File.separator;
            } else if (name.equals(TNS_ADMIN)) {
                value = tnsAdmin;
            } else {
                value = System.getProperty(name);
                if (value == null) {
                    value = System.getenv(name);
                }
            }
            if (value == null) {
                throw new IOException(name + " is not defined as a system property or environment variable");
            }
            output.append(value);
            return end + 1;
        }
    }
}

