/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.base.core.BcStringUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcCloneUtil;
import ext.base.util.BcISO;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxNumberField;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.layout.FxTitledPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.libx.fx.international.FxxFlagImageHelper;
import ext.module.xsod.common.XsodConstants;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.fx.XsodMerchandiseNamePane;
import ext.module.xsod.model.XsodMerchandise;
import ext.module.xsod.model.XsodMerchandisePack;
import ext.module.xsod.stub.XsodImagsStub;
import ext.module.xsod.stub.XsodMerchandiseStub;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileUploader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XsodMerchandiseEditPane
extends FxDecoratePane {
    FxFlowPane flowPane1 = new FxFlowPane(11);
    FxFlowPane flowPane2 = new FxFlowPane(11);
    FxFlowPane flowPane3 = new FxFlowPane(11);
    FxTextField codeField = new FxTextField();
    FxNumberField unitAmountField = new FxNumberField();
    List<XsodMerchandiseNamePane> namePaneList = new ArrayList<XsodMerchandiseNamePane>();
    FxTextField category1Field = new FxTextField();
    FxTextField category2Field = new FxTextField();
    FxTextField imageFilePathField = new FxTextField();
    FxButton iamgeFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxBorderPane imageBasePane = new FxBorderPane();
    ScfFileUploader fileUploader;
    FxNumberField modeField = new FxNumberField();
    Button completionButton;
    Button closeButton;
    XsodMerchandisePack merchandisePack1;
    XsodMerchandisePack merchandisePack2;
    public Stage stage;

    public XsodMerchandiseEditPane() throws Exception {
        this.setComponent1();
        this.setComponent2();
        this.setComponent3();
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.fileUploader = new ScfFileUploader(ScfClientContainer.getInstance().getAgent());
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponent1() throws Exception {
        this.setTop((Node)this.flowPane1);
        this.codeField.setPrefColumnCount(16);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u5546\u54c1\u30b3\u30fc\u30c9.toString()), new Node[]{this.codeField});
        this.flowPane1.addNodeUnit(nodeUnit);
        this.unitAmountField.setPrefColumnCount(16);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u5358\u4fa1.toString()), new Node[]{this.unitAmountField});
        this.flowPane1.addNodeUnit(nodeUnit);
        this.flowPane1.setPrefHeight(60.0);
    }

    protected void setComponent2() throws Exception {
        this.flowPane2.setPrefWidth(600.0);
        this.setLeft((Node)this.flowPane2);
        int i = 0;
        while (i < XsodConstants.langArray.length) {
            BcISO.ISO_639 iso639_1 = XsodConstants.langArray[i];
            XsodMerchandiseNamePane namePane = new XsodMerchandiseNamePane(iso639_1.code);
            this.namePaneList.add(namePane);
            Image image = FxxFlagImageHelper.getImageByLangCode(iso639_1.code);
            ImageView imageView = new ImageView(image);
            imageView.setImage(image);
            imageView.setFitWidth(32.0);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            FxTitledPane titledPane = new FxTitledPane();
            titledPane.setTitle(iso639_1.nameJp);
            titledPane.setIconNode((Node)imageView);
            titledPane.setPrefSize(540.0, 160.0);
            titledPane.setContentNode((Node)namePane);
            FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(iso639_1.nameJp, (Node)imageView), new Node[]{titledPane});
            this.flowPane2.addNodeUnit(nodeUnit);
            ++i;
        }
    }

    protected void setComponent3() throws Exception {
        this.flowPane3.setPrefWidth(600.0);
        this.setRight((Node)this.flowPane3);
        this.category1Field.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u30ab\u30c6\u30b4\u30ea\uff11.toString()), new Node[]{this.category1Field});
        this.flowPane3.addNodeUnit(nodeUnit);
        this.category2Field.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u30ab\u30c6\u30b4\u30ea\uff12.toString()), new Node[]{this.category2Field});
        this.flowPane3.addNodeUnit(nodeUnit);
        this.imageFilePathField.setPrefColumnCount(60);
        this.iamgeFileChooseButton.setOnAction(this.actionEventHandler);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u753b\u50cf\u9078\u629e"), new Node[]{this.imageFilePathField, this.iamgeFileChooseButton});
        this.flowPane3.addNodeUnit(nodeUnit);
        this.imageBasePane.setPrefSize(400.0, 400.0);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u753b\u50cf"), new Node[]{this.imageBasePane});
        this.flowPane3.addNodeUnit(nodeUnit);
        ArrayList<String> extentionList = new ArrayList<String>();
        extentionList.addAll(AwtImageUtil.getImageExtentionList());
        FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("\u753b\u50cf\u30d5\u30a1\u30a4\u30eb", extentionList);
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extensionFilter});
        this.modeField.setPrefColumnCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u8868\u793a\u30e2\u30fc\u30c9"), new Node[]{this.modeField});
        this.flowPane3.addNodeUnit(nodeUnit);
    }

    protected void setDataId(String merchandiseCode) throws Exception {
        XsodMerchandisePack merchandisePack1;
        if (BcStringUtil.isEmpty(merchandiseCode)) {
            merchandisePack1 = new XsodMerchandisePack();
            merchandisePack1.merchandise = new XsodMerchandise();
        } else {
            merchandisePack1 = XsodMerchandiseStub.getInstance().getMerchandisePack(merchandiseCode);
        }
        this.setData(merchandisePack1);
    }

    protected void setData(XsodMerchandisePack merchandisePack) throws Exception {
        this.merchandisePack1 = merchandisePack;
        this.merchandisePack2 = BcCloneUtil.createClone(this.merchandisePack1);
        this.codeField.setText(this.merchandisePack2.merchandise.code);
        this.unitAmountField.setValue(this.merchandisePack2.merchandise.unitAmount);
        int i = 0;
        while (i < this.namePaneList.size()) {
            XsodMerchandiseNamePane namePane = this.namePaneList.get(i);
            namePane.clearField();
            String name = XsodUtil.getName(merchandisePack.merchandise, namePane.langCode, false);
            String description = XsodUtil.getDescription(merchandisePack.merchandise, namePane.langCode, false);
            namePane.merchandiseNameField.setText(name);
            namePane.descriptionTextArea.setText(description);
            ++i;
        }
        this.imageFilePathField.setText(this.merchandisePack2.merchandise.imageFileName);
        this.modeField.setValue(this.merchandisePack2.merchandise.mode);
    }

    protected void storeData() throws Exception {
        this.merchandisePack2.merchandise.code = this.codeField.getText();
        this.merchandisePack2.merchandise.unitAmount = this.unitAmountField.getBigDecimal();
        int i = 0;
        while (i < this.namePaneList.size()) {
            XsodMerchandiseNamePane namePane = this.namePaneList.get(i);
            XsodUtil.setName(this.merchandisePack2.merchandise, namePane.langCode, namePane.merchandiseNameField.getText());
            XsodUtil.setDescription(this.merchandisePack2.merchandise, namePane.langCode, namePane.descriptionTextArea.getText());
            ++i;
        }
        if (BcStringUtil.isEmpty(this.imageFilePathField.getText())) {
            this.merchandisePack2.merchandise.imageFileName = null;
        } else {
            File imageFile = new File(this.imageFilePathField.getText());
            this.merchandisePack2.merchandise.imageFileName = imageFile.getName();
        }
        this.merchandisePack2.merchandise.mode = this.modeField.getBigDecimal().shortValue();
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == ((Object)((Object)this.iamgeFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.imageFilePathField.getText());
            File file = this.fileChooser.showOpenDialog((Window)this.stage);
            if (file != null) {
                this.imageFilePathField.setText(file.getPath());
                URL url = file.toURL();
                Image image = new Image(url.toString());
                ImageView imageView = new ImageView(image);
                imageView.setPreserveRatio(true);
                imageView.setFitWidth(this.imageBasePane.getPrefWidth());
                this.imageBasePane.setCenter((Node)imageView);
            }
        } else if (ev.getSource() == this.completionButton) {
            this.storeData();
            File imageFile = null;
            if (!BcStringUtil.isEmpty(this.imageFilePathField.getText())) {
                imageFile = new File(this.imageFilePathField.getText());
            }
            if (imageFile != null && imageFile.exists()) {
                File svDir = XsodImagsStub.getInstance().getImageDir();
                BcMonitor monitor = new BcMonitor();
                this.fileUploader.upload(imageFile, svDir.getPath(), monitor, null);
                monitor.sync();
            }
            XsodMerchandiseStub.getInstance().putMerchandisePack(this.merchandisePack2);
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public XsodMerchandisePack show(String merchandiseCode) throws Exception {
        this.setDataId(merchandiseCode);
        this.stage = new Stage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(1200.0);
        this.stage.setHeight(860.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XsodWords.getInstance().\u5546\u54c1\u7de8\u96c6.toString());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
        return this.merchandisePack2;
    }

    static /* synthetic */ void access$0(XsodMerchandiseEditPane xsodMerchandiseEditPane, Throwable throwable) {
        xsodMerchandiseEditPane.handleException(throwable);
    }
}

