/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcConstants;
import ext.base.core.BcInteger;
import ext.base.core.BcLangUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.core.BcUnicode;
import ext.base.io.BcStreamTransmitter;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcObjectConvertor;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlTableMetadata;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlSetClause;
import ext.lib.sql.model.SqlUpdateQuery;
import ext.lib.sql.model.SqlWhereElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public abstract class SqlContext
extends BcLoggableObject {
    public static final int TERM_MODE_1 = 1;
    public static final int TERM_MODE_2 = 2;
    public static final int TERM_MODE_3 = 3;
    private SqlConstants.DatabaseProduct databaseProduct;
    protected Map<String, String> tableNameMap;
    private BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
    public String indent = " ";
    private String validationQuery = "SELECT 1";
    private int validationTimeout = 3;
    public static final long SIZE_10e9 = (long)Math.pow(10.0, 9.0);
    char[] escapeChars;
    public static final String yyyyMMdd = "yyyy-MM-dd";
    public static final String HHmmss = "HH:mm:ss";
    public static final String yyyYMMdd_HHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String NANO = "fffffffff";

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public int getValidationTimeout() {
        return this.validationTimeout;
    }

    public void setValidationTimeout(int validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public SqlContext(SqlConstants.DatabaseProduct databaseProduct) {
        this.escapeChars = new char[]{BcUnicode.Unicode.apostrophe.char_};
        this.databaseProduct = databaseProduct;
    }

    public boolean isSupported(Function function) {
        return true;
    }

    public SqlConstants.DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public abstract String[] getDriverClassNames();

    public int getDefaultPort() {
        return -1;
    }

    public void setTransactionIsolation(Connection sqlConn) throws Exception {
        sqlConn.setTransactionIsolation(2);
    }

    public SqlStatement createStatement(SqlConnection sqlConnection, Statement stmt1) throws SQLException {
        SqlStatement stmt2 = new SqlStatement(sqlConnection, stmt1, this);
        stmt2.setQueryTimeout(sqlConnection.getConnectionManager().getQueryTimeout());
        stmt2.setLogger(this.getLogger());
        stmt2.setLongQueryTime(sqlConnection.getLongQueryTime());
        sqlConnection.statementList.add(stmt2);
        return stmt2;
    }

    public SqlStatement createStatementForScroll(SqlConnection sqlConnection) throws SQLException {
        SqlStatement stmt = null;
        if (this.isSupported(Function.resultSetScroll)) {
            stmt = sqlConnection.createStatement(1005, 1007, 1);
        } else {
            this.getLogger().warning("Scroll is not supported.");
            stmt = sqlConnection.createStatement(1003, 1007);
        }
        stmt.setQueryTimeout(sqlConnection.getConnectionManager().getQueryTimeoutForScroll());
        sqlConnection.setLendingTimeout(sqlConnection.getConnectionManager().getLendingTimeoutForScroll());
        return stmt;
    }

    public String getEncoding() throws Exception {
        return "UTF-8";
    }

    public List<SqlTableMetadata> getTableMetadataList(SqlConnection sqlConn, String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws Exception {
        ArrayList<SqlTableMetadata> tableMetadataList = new ArrayList<SqlTableMetadata>();
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlConn.getMetaData().getTables(catalogName, schemaNamePattern, tableNamePattern, tableTypes);){
            while (rs.next()) {
                SqlTableMetadata tableMetadata = new SqlTableMetadata();
                this.getTableMetadata(rs, tableMetadata);
                tableMetadataList.add(tableMetadata);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tableMetadataList;
    }

    public List<SqlTableMetadata> getTableMetadataList(SqlConnection sqlConn, String tableNamePattern, String[] tableTypes) throws Exception {
        return this.getTableMetadataList(sqlConn, sqlConn.getCatalog(), sqlConn.getSchema(), tableNamePattern, tableTypes);
    }

    public SqlTableMetadata getTableMetadata(SqlConnection sqlConn, String tableNamePattern) throws Exception {
        List<SqlTableMetadata> tableMetadataList = this.getTableMetadataList(sqlConn, tableNamePattern, null);
        return BcCollectionUtil.getFirst(tableMetadataList);
    }

    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int colmunIndex = i + 1;
            String columnName = rsmd.getColumnName(colmunIndex);
            if ("TABLE_CAT".equals(columnName)) {
                tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
            } else if ("TABLE_SCHEM".equals(columnName)) {
                tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
            } else if ("TABLE_NAME".equals(columnName)) {
                tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
            } else if ("TABLE_TYPE".equals(columnName)) {
                tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
            } else if ("REMARKS".equals(columnName)) {
                tableMetadata.REMARKS = rs.getString("REMARKS");
            } else if ("TYPE_CAT".equals(columnName)) {
                tableMetadata.TYPE_CAT = rs.getString("TYPE_CAT");
            } else if ("TYPE_SCHEM".equals(columnName)) {
                tableMetadata.TYPE_SCHEM = rs.getString("TYPE_SCHEM");
            } else if ("TYPE_NAME".equals(columnName)) {
                tableMetadata.TYPE_NAME = rs.getString("TYPE_NAME");
            } else if ("SELF_REFERENCING_COL_NAME".equals(columnName)) {
                tableMetadata.SELF_REFERENCING_COL_NAME = rs.getString("SELF_REFERENCING_COL_NAME");
            } else if ("REF_GENERATION".equals(columnName)) {
                tableMetadata.REF_GENERATION = rs.getString("REF_GENERATION");
            }
            ++i;
        }
    }

    public List<String> getTableNameList(SqlConnection sqlConn, String tableNamePattern, String ... tableTypes) throws Exception {
        Pattern pattern = null;
        if (!BcStringUtil.isEmpty(tableNamePattern)) {
            pattern = Pattern.compile(tableNamePattern);
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        Throwable throwable = null;
        Object var7_9 = null;
        try (ResultSet rs = sqlConn.getMetaData().getTables(sqlConn.getCatalog(), sqlConn.getSchema(), null, tableTypes);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                boolean hit = true;
                if (pattern != null) {
                    Matcher matcher = pattern.matcher(tableName);
                    hit = matcher.matches();
                }
                if (!hit) continue;
                tableNameList.add(tableName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tableNameList;
    }

    public List<String> getTableNameList(SqlConnection sqlConn, String namePattern) throws Exception {
        return this.getTableNameList(sqlConn, namePattern, SqlConstants.TableType.TABLE.name());
    }

    public List<String> getTableNameList(SqlConnection sqlConn) throws Exception {
        return this.getTableNameList(sqlConn, null);
    }

    public List<String> getViewNameList(SqlConnection sqlConn, String namePattern) throws Exception {
        return this.getTableNameList(sqlConn, namePattern, SqlConstants.TableType.VIEW.name());
    }

    public List<String> getViewNameList(SqlConnection sqlConn) throws Exception {
        return this.getViewNameList(sqlConn, null);
    }

    public String tableNameToDB(SqlConnection sqlConn, String tableName) throws Exception {
        String resValue;
        if (this.tableNameMap == null) {
            this.tableNameMap = new HashMap<String, String>();
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = sqlConn.getMetaData().getTables(null, null, null, null);){
                while (rs.next()) {
                    String tmpStr = rs.getString("TABLE_NAME");
                    this.tableNameMap.put(tmpStr.toLowerCase(), tmpStr);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (BcStringUtil.isEmpty(resValue = this.tableNameMap.get(tableName.toLowerCase()))) {
            resValue = tableName;
        }
        return resValue;
    }

    public MmdModel createModelMetaData(SqlConnection sqlConn, String tableName, boolean doGetKey) throws Exception {
        if (BcStringUtil.isEmpty(tableName)) {
            throw new Exception("Table name is null.");
        }
        MmdModel mmdModel = new MmdModel();
        String tableName2 = this.tableNameToDB(sqlConn, tableName);
        SqlTableMetadata tableMetadata = this.getTableMetadata(sqlConn, tableName2);
        if (SqlConstants.TableType.VIEW.value.equals(tableMetadata.TABLE_TYPE)) {
            doGetKey = false;
        }
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlConn.getMetaData().getColumns(null, null, tableName2, null);){
            mmdModel.modelName = tableName;
            mmdModel.tableName = tableName;
            mmdModel.note = tableMetadata.REMARKS;
            while (rs.next()) {
                MmdField mmdField = new MmdField();
                String tableNameTmp = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(tableNameTmp)) {
                    break;
                }
                mmdField.columnName = rs.getString("COLUMN_NAME");
                mmdField.ordinalPosition = rs.getInt("ORDINAL_POSITION");
                String isNullable = rs.getString("IS_NULLABLE");
                mmdField.nullable = BcBooleanUtil.toShort(BcBooleanUtil.parseBoolean(isNullable));
                mmdField.sqlTypeId = rs.getInt("DATA_TYPE");
                mmdField.dataSize = rs.getInt("COLUMN_SIZE");
                mmdField.dataClass = SqlUtil.toJavaType(mmdField.sqlTypeId);
                if (Number.class.isAssignableFrom(mmdField.dataClass) && !BcNumberUtil.isFloatingaPointClass(mmdField.dataClass)) {
                    MmdUtil.setDecimalPosition(mmdField, rs.getInt("DECIMAL_DIGITS"));
                }
                mmdField.note = rs.getString("REMARKS");
                mmdModel.setField(mmdField);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (doGetKey) {
            List<MmdIndex> mmdIndexList = this.getKeyList(sqlConn, tableName, mmdModel);
            int i = 0;
            while (i < mmdIndexList.size()) {
                MmdIndex mmdIndex = mmdIndexList.get(i);
                mmdModel.addIndex(mmdIndex);
                ++i;
            }
            mmdModel.primaryIndexName = this.getPrimaryKeyName(sqlConn, tableName);
        }
        return mmdModel;
    }

    public MmdModel createModelMetaData(SqlConnection sqlConn, String tableName) throws Exception {
        return this.createModelMetaData(sqlConn, tableName, true);
    }

    public MmdIndex getPrimaryKey(SqlConnection sqlConn, String tableName) throws Exception {
        String tableName2 = this.tableNameToDB(sqlConn, tableName);
        MmdIndex mmdIndex = null;
        Throwable throwable = null;
        Object var6_8 = null;
        try (ResultSet rs = sqlConn.getMetaData().getPrimaryKeys(null, null, tableName2);){
            while (rs.next()) {
                if (mmdIndex == null) {
                    mmdIndex = new MmdIndex();
                    mmdIndex.name = rs.getString("PK_NAME");
                }
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = rs.getString("COLUMN_NAME");
                short keySeq = rs.getShort("KEY_SEQ");
                BcCollectionUtil.setElement(mmdIndex.indexElementList, keySeq - 1, indexElement);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return mmdIndex;
    }

    public String getPrimaryKeyName(SqlConnection sqlConn, String tableName) throws Exception {
        String tableName2 = this.tableNameToDB(sqlConn, tableName);
        String primaryKeyName = null;
        Throwable throwable = null;
        Object var6_8 = null;
        try (ResultSet rs = sqlConn.getMetaData().getPrimaryKeys(null, null, tableName2);){
            while (rs.next()) {
                primaryKeyName = rs.getString("PK_NAME");
                this.getLogger().debug("getPrimaryKeyName:primaryKeyName=" + primaryKeyName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return primaryKeyName;
    }

    public List<MmdIndex> getKeyList(SqlConnection sqlConn, String tableName, MmdModel mmdModel) throws Exception {
        ArrayList<MmdIndex> mmdIndexList = new ArrayList<MmdIndex>();
        String tableName2 = this.tableNameToDB(sqlConn, tableName);
        MmdIndex mmdIndex = null;
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlConn.getMetaData().getIndexInfo(sqlConn.getCatalog(), sqlConn.getSchema(), tableName2, false, false);){
            String indexNamePre = null;
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (BcStringUtil.isEmpty(indexName)) continue;
                if (!indexName.equals(indexNamePre)) {
                    if (mmdIndex != null) {
                        mmdIndexList.add(mmdIndex);
                    }
                    mmdIndex = new MmdIndex();
                    mmdIndex.name = indexName;
                }
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = rs.getString("COLUMN_NAME");
                indexElement.ordinalPosition = rs.getShort("ORDINAL_POSITION");
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                mmdIndex.isUnique = !nonUnique;
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                indexElement.isAscending = BcStringUtil.equals(ascOrDesc, "A");
                this.getLogger().debug(" indexName=" + indexName + " columnName=" + indexElement.columnName + " ordinalPosition=" + indexElement.ordinalPosition + " nonUnique=" + nonUnique + " isAsc=" + indexElement.isAscending);
                BcCollectionUtil.setElement(mmdIndex.indexElementList, indexElement.ordinalPosition - 1, indexElement);
                indexNamePre = indexName;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (mmdIndex != null) {
            mmdIndexList.add(mmdIndex);
        }
        return mmdIndexList;
    }

    public String reformForMetadata(String objectName) throws Exception {
        if (objectName == null) {
            return null;
        }
        return objectName.toLowerCase();
    }

    public int getSqlType(SqlConnection sqlConn, String tableName, String columnName) throws Exception {
        String tableName2 = this.reformForMetadata(tableName);
        String columnName2 = this.reformForMetadata(columnName);
        Throwable throwable = null;
        Object var7_9 = null;
        try (ResultSet rs = sqlConn.getMetaData().getColumns(sqlConn.getCatalog(), sqlConn.getSchema(), tableName2, columnName2);){
            if (rs.next()) {
                return rs.getInt("DATA_TYPE");
            }
            throw new Exception("not found tableName=" + tableName2 + " columnName=" + columnName2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<Integer> getSqlTypeList(SqlConnection sqlConn, String tableName, List<String> columnNameList) throws Exception {
        ArrayList<Integer> sqlTypeList = new ArrayList<Integer>();
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            int sqlType = this.getSqlType(sqlConn, tableName, columnName);
            sqlTypeList.add(sqlType);
            ++i;
        }
        return sqlTypeList;
    }

    public String escapeEncode(String srcStr) throws Exception {
        if (srcStr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < srcStr.length()) {
            sb.append(this.escapeEncode_char(srcStr.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public String escapeEncode_char(char aChar) throws Exception {
        char[] escapechars = this.getEscapeChars();
        int i = 0;
        while (i < escapechars.length) {
            if (escapechars[i] == aChar) {
                StringBuilder sb = new StringBuilder();
                sb.append(BcUnicode.Unicode.reverseSolidus.char_);
                sb.append(aChar);
                return sb.toString();
            }
            ++i;
        }
        return String.valueOf(aChar);
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, Reader reader, int dataSize) throws Exception {
        if (reader != null) {
            if (dataSize > 0) {
                ppst.setCharacterStream(colmunIndex, reader, dataSize);
            } else {
                ppst.setNull(colmunIndex, -1);
            }
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, Reader reader) throws Exception {
        if (reader != null) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            BcStreamUtil.transmit(reader, charArrayWriter, 1024);
            CharArrayReader charArrayReader = new CharArrayReader(charArrayWriter.toCharArray());
            this.set_LONGVARCHAR(ppst, colmunIndex, charArrayReader, charArrayWriter.size());
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, String charSequence) throws Exception {
        if (!BcStringUtil.isEmpty(charSequence)) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            charArrayWriter.append(charSequence);
            CharArrayReader charArrayReader = new CharArrayReader(charArrayWriter.toCharArray());
            this.set_LONGVARCHAR(ppst, colmunIndex, charArrayReader, charArrayWriter.size());
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARBINARY(PreparedStatement ppst, int colmunIndex, InputStream is) throws Exception {
        if (is != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.streamTransmitter.transmit(is, baos);
            is.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            if (baos.size() > 0) {
                ppst.setBinaryStream(colmunIndex, (InputStream)bais, baos.size());
            } else {
                this.setNull_LONGVARBINARY(ppst, colmunIndex);
            }
        } else {
            this.setNull_LONGVARBINARY(ppst, colmunIndex);
        }
    }

    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, -4);
    }

    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, 2004);
    }

    public void setPreStmtValue(PreparedStatement ppst, int columnIndex, int sqlTypeId, Object value) throws Exception {
        if (value == null) {
            ppst.setNull(columnIndex, sqlTypeId);
        } else {
            Object value2 = this.toJdbcValue(value, sqlTypeId);
            try {
                ppst.setObject(columnIndex, value2);
            }
            catch (Exception ex) {
                this.getLogger().error("value2.getClass()=" + value2.getClass().getName());
                throw ex;
            }
        }
    }

    public void setPreStmtValue(PreparedStatement ppst, BcInteger columnIndex, int sqlTypeId, Object value) throws Exception {
        ++columnIndex.value;
        this.setPreStmtValue(ppst, columnIndex.value, sqlTypeId, value);
    }

    public void setPreStmtValues(PreparedStatement ppst, List<Integer> sqlTypeIdList, List<Object> valueList) throws Exception {
        int i = 0;
        while (i < sqlTypeIdList.size()) {
            this.setPreStmtValue(ppst, i + 1, (int)sqlTypeIdList.get(i), valueList.get(i));
            ++i;
        }
    }

    public MmdModel convertModelMetaData(MmdModel srcMmdModel, SqlContext sqlContext) throws Exception {
        MmdModel dstMmdModel = (MmdModel)srcMmdModel.clone();
        return dstMmdModel;
    }

    public Object toJdbcValue(Object srcValue, int targetSqlTypeId) throws Exception {
        if (srcValue == null) {
            return null;
        }
        Class<?> srcClass = srcValue.getClass();
        Object dstValue = srcValue;
        if (Character.class.isAssignableFrom(srcClass) || Character.TYPE.isAssignableFrom(srcClass)) {
            dstValue = srcValue.toString();
        } else if (Timestamp.class.isAssignableFrom(srcClass) || Date.class.isAssignableFrom(srcClass) || Time.class.isAssignableFrom(srcClass)) {
            dstValue = srcValue;
        } else if (Calendar.class.isAssignableFrom(srcClass)) {
            Calendar calendar = (Calendar)srcValue;
            dstValue = new Timestamp(calendar.getTimeInMillis());
        } else if (java.util.Date.class.isAssignableFrom(srcClass)) {
            java.util.Date date = (java.util.Date)srcValue;
            dstValue = new Date(date.getTime());
        }
        return dstValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object toFieldValue(Object jdbcValue, Class dstClass) throws Exception {
        if (jdbcValue == null) {
            return null;
        }
        Class<?> srcClass = jdbcValue.getClass();
        if (srcClass.equals(dstClass)) {
            return jdbcValue;
        }
        Calendar fieldValue = null;
        if (Timestamp.class.isAssignableFrom(srcClass)) {
            Timestamp timestamp = (Timestamp)jdbcValue;
            return BcTimeUtil.toCalendar(timestamp.getTime());
        }
        if (Time.class.isAssignableFrom(srcClass)) {
            Time time = (Time)jdbcValue;
            return BcTimeUtil.toCalendar(time.getTime());
        }
        if (Date.class.isAssignableFrom(srcClass)) {
            Date date = (Date)jdbcValue;
            return new java.util.Date(date.getTime());
        }
        if (Clob.class.isAssignableFrom(srcClass)) {
            Clob clob = (Clob)jdbcValue;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (!Blob.class.isAssignableFrom(srcClass)) return BcObjectConvertor.getInstance().convert(jdbcValue, dstClass);
        Blob blob = (Blob)jdbcValue;
        if (!BcLangUtil.isByteArray(dstClass)) throw new Exception(String.valueOf(srcClass.getName()) + " -> " + dstClass.getName());
        byte[] bytes = BcStreamUtil.readWithClose(blob.getBinaryStream());
        return (Calendar)bytes;
    }

    public String toSet(Object value) throws Exception {
        if (value == null) {
            return "NULL";
        }
        Class<?> valueClass = value.getClass();
        String str = null;
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            CharSequence charSequence = (CharSequence)value;
            str = BcStringUtil.singleQuotation(this.escapeEncode(charSequence.toString()));
        } else if (Calendar.class.isAssignableFrom(valueClass)) {
            Calendar calendar = (Calendar)value;
            str = BcStringUtil.singleQuotation(BcTimeUtil.toString(calendar, this.getDateTimeFormatForrUpdate()));
        } else if (java.util.Date.class.isAssignableFrom(valueClass)) {
            java.util.Date date = (java.util.Date)value;
            Calendar calendar = BcTimeUtil.createCalendar();
            calendar.setTimeInMillis(date.getTime());
            str = BcStringUtil.singleQuotation(BcTimeUtil.toString(calendar, this.getDateTimeFormatForrUpdate()));
        } else {
            str = value.toString();
        }
        return str;
    }

    public String func_trim(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TRIM(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_length(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("LENGTH(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_toChar(String columnName, String format) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TOCHAR(");
        sb.append(columnName);
        if (!BcStringUtil.isEmpty(format)) {
            sb.append("," + format);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_toChar(String columnName) throws Exception {
        return this.func_toChar(columnName, null);
    }

    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTR(");
        sb.append(columnName);
        if (startIndex > 0) {
            sb.append("," + startIndex);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    public String func_sum(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUM(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_clockTimestamp() throws Exception {
        return "clock_timestamp()";
    }

    public String func_statementTimestamp() throws Exception {
        return "statement_timestamp()";
    }

    public String func_transactionTimestamp() throws Exception {
        return "transaction_timestamp()";
    }

    public String func_coalesce(String ... values) throws Exception {
        return "COALESCE(" + BcStringUtil.toCsv(true, values) + ")";
    }

    public String func_replace2(String src, String search, String replacement) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("REPLACE(");
        sb.append(src);
        sb.append(", ");
        sb.append(search);
        sb.append(", ");
        sb.append(replacement);
        sb.append(")");
        return sb.toString();
    }

    public String func_replace(String src, String search, String replacement) throws Exception {
        return this.func_replace(src, BcStringUtil.singleQuotation(search), BcStringUtil.singleQuotation(replacement));
    }

    public String func_replace_regexp(String src, String regexp, String replacement, String flags) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("REGEXP_REPLACE(");
        sb.append(src);
        sb.append(", ");
        sb.append(regexp);
        sb.append(", ");
        sb.append(replacement);
        if (!BcStringUtil.isEmpty(flags)) {
            sb.append(", ");
            sb.append(flags);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_replace_regexp(String src, String regexp, String replacement) throws Exception {
        return this.func_replace_regexp(src, BcStringUtil.singleQuotation(regexp), BcStringUtil.singleQuotation(replacement), null);
    }

    public String funk_deleteSpace(String src, boolean isFullWidth) throws Exception {
        String formula1 = this.func_replace2(src, BcStringUtil.singleQuotation(BcStringUtil.SPACE_STR), "''");
        if (isFullWidth) {
            return this.func_replace2(formula1, BcUnicode.FULLWIDTH_SPACE_STR, "''");
        }
        return formula1;
    }

    public String createCreateTableQuery_primaryKey(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            sb.append("CONSTRAINT");
            sb.append(" " + primaryKey.name);
            sb.append(" PRIMARY KEY");
            sb.append(" (");
            int i = 0;
            while (i < primaryKey.indexElementList.size()) {
                MmdIndexElement indexElement = primaryKey.indexElementList.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(indexElement.columnName);
                ++i;
            }
            sb.append(")");
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public String createCreateTableQuery(MmdModel mmdModel, boolean includePrimaryKey, SqlDefinitionCondition definitionCondition, String lineSep) throws Exception {
        String primaryKeyQuery;
        String phrase;
        ArrayList<String> phraseList = new ArrayList<String>();
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            phrase = this.createColumnPhrase(mmdField, definitionCondition);
            if (!BcStringUtil.isEmpty(phrase)) {
                phraseList.add(phrase);
            }
            ++i;
        }
        if (BcCollectionUtil.isEmpty(phraseList)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(mmdModel.tableName);
        sb.append(lineSep);
        sb.append(" (");
        int i2 = 0;
        while (i2 < phraseList.size()) {
            phrase = (String)phraseList.get(i2);
            if (i2 == 0) {
                sb.append(" ");
            } else {
                sb.append("  ,");
            }
            sb.append(phrase);
            sb.append(lineSep);
            ++i2;
        }
        if (includePrimaryKey && mmdModel.getFieldCount() == phraseList.size() && !BcStringUtil.isEmpty(primaryKeyQuery = this.createCreateTableQuery_primaryKey(mmdModel, lineSep))) {
            sb.append("  ,");
            sb.append(primaryKeyQuery);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String createCreateTableQuery(MmdModel mmdModel, boolean includePrimaryKey, SqlDefinitionCondition definitionCondition) throws Exception {
        return this.createCreateTableQuery(mmdModel, includePrimaryKey, definitionCondition, BcStringUtil.lineSeparator);
    }

    public String createColumnPhrase(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = this.createColumnTypeDefinition(mmdField, definitionCondition);
        if (BcStringUtil.isEmpty(definition)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(mmdField.columnName);
        sb.append(" ");
        sb.append(definition);
        return sb.toString();
    }

    public String createColumnTypeDefinition(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                definition = this.type_NUMBER(mmdField, definitionCondition);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                definition = this.type_CHAR(mmdField, definitionCondition);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                definition = this.type_TIME(mmdField, definitionCondition);
                break;
            }
            case -7: 
            case 16: {
                definition = this.type_BIT_BOOLEAN(mmdField, definitionCondition);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                definition = this.type_BINARY(mmdField, definitionCondition);
            }
        }
        if (!BcStringUtil.isEmpty(definition) && mmdField.nullable != BcConstants.Existence.TRUE.value) {
            definition = String.valueOf(definition) + " NOT NULL";
        }
        return definition;
    }

    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "TINYINT";
                break;
            }
            case 5: {
                definition = "SMALLINT";
                break;
            }
            case 4: {
                definition = "INTEGER";
                break;
            }
            case -5: {
                definition = "BIGINT";
                break;
            }
            case 6: 
            case 7: {
                definition = "REAL";
                break;
            }
            case 8: {
                definition = "DOUBLE PRECISION";
                break;
            }
            case 2: 
            case 3: {
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
            }
        }
        return definition;
    }

    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                if ((long)mmdField.dataSize <= SIZE_10e9) {
                    definition = "CHARACTER(" + mmdField.dataSize + ")";
                    break;
                }
                definition = "CHARACTER VARYING" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                definition = "CHARACTER VARYING" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case 2005: 
            case 2011: {
                StringBuilder sb = new StringBuilder();
                sb.append("CLOB");
                if (mmdField.dataSize > 0) {
                    sb.append("(" + mmdField.dataSize + ")");
                }
                definition = sb.toString();
            }
        }
        return definition;
    }

    public String type_TIME(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 91: {
                definition = "DATE";
                break;
            }
            case 92: {
                definition = "TIME";
                break;
            }
            case 93: {
                definition = "TIMESTAMP";
            }
        }
        return definition;
    }

    public String type_BIT_BOOLEAN(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -7: 
            case 16: {
                definition = "BOOLEAN";
            }
        }
        return definition;
    }

    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -2: {
                if ((long)mmdField.dataSize > SIZE_10e9) break;
                definition = "BINARY" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -4: 
            case -3: {
                if ((long)mmdField.dataSize > SIZE_10e9) break;
                definition = "BINARY VARYING" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case 2004: {
                definition = "BLOB" + SqlUtil.toSizeStr(mmdField.dataSize);
            }
        }
        return definition;
    }

    public int createTable(SqlConnection sqlConn, MmdModel mmdModel, boolean includePrimaryKey, SqlDefinitionCondition definitionCondition, BcLogger logger) throws Exception {
        String query = this.createCreateTableQuery(mmdModel, includePrimaryKey, definitionCondition);
        logger.info("query=" + query);
        int cnt = SqlUtil.executeUpdate(sqlConn, query);
        return cnt;
    }

    public int createIndex(SqlConnection sqlConn, MmdModel mmdModel, BcLogger logger) throws Exception {
        int cnt = 0;
        Throwable throwable = null;
        Object var6_8 = null;
        try (SqlStatement stmt = sqlConn.createStatement();){
            for (Map.Entry<String, MmdIndex> mapEntry : mmdModel.indexMap.entrySet()) {
                MmdIndex mmdIndex = mapEntry.getValue();
                if (mmdModel.getPrimaryIndex() != null && mmdIndex.name.equalsIgnoreCase(mmdModel.getPrimaryIndex().name)) continue;
                cnt += this.createIndex(sqlConn, mmdModel, mmdIndex, logger);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return cnt;
    }

    public int dropTable(SqlConnection sqlConn, String tableName) throws Exception {
        String query = "DROP TABLE " + tableName;
        this.getLogger().info("query=" + query);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public String createCreateIndexQuery(MmdModel mmdModel, MmdIndex mmdIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (mmdIndex.isUnique) {
            sb.append("CREATE UNIQUE INDEX ");
        } else {
            sb.append("CREATE INDEX ");
        }
        sb.append(mmdIndex.name);
        sb.append(" ON ");
        sb.append(mmdModel.tableName);
        sb.append("(");
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            sb.append(indexElement.columnName);
            ++i;
        }
        sb.append(" )");
        return sb.toString();
    }

    public int createIndex(SqlConnection sqlConn, MmdModel mmdModel, MmdIndex mmdIndex, BcLogger logger) throws Exception {
        String query = this.createCreateIndexQuery(mmdModel, mmdIndex);
        logger.info("query=" + query);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int dropIndex(SqlConnection sqlConn, String tableName, String indexName) throws Exception {
        String query = "DROP INDEX " + indexName + " ON " + tableName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int addColumn(SqlConnection sqlConn, String tableName, String columnName, String dataType) throws Exception {
        String query = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + dataType;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int dropColumn(SqlConnection sqlConn, String tableName, String columnName) throws Exception {
        String query = "ALTER TABLE " + tableName + " DROP COLUMN " + columnName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public String createCreateViewSql(String viewName, String selectQuery) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE VIEW ");
        sb.append(viewName);
        sb.append(" AS ");
        sb.append(selectQuery);
        return sb.toString();
    }

    public int createView(SqlConnection sqlConn, String viewName, String selectQuery) throws Exception {
        String query = this.createCreateViewSql(viewName, selectQuery);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int dropView(SqlConnection sqlConn, String viewName) throws Exception {
        String query = "DROP VIEW " + viewName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int dropFunction(SqlConnection sqlConn, String functionName) throws Exception {
        String query = "DROP FUNCTION " + functionName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int truncateTable(SqlConnection sqlConn, String tableName) throws Exception {
        String query = "TRUNCATE TABLE " + tableName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public void truncateTables(SqlConnection sqlConn, String ... tableNames) throws Exception {
        int i = 0;
        while (i < tableNames.length) {
            this.truncateTable(sqlConn, tableNames[i]);
            ++i;
        }
    }

    public int deleteAllRow(SqlConnection sqlConn, String tableName) throws Exception {
        String query = "DELETE FROM " + tableName;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public boolean existIndex(SqlConnection sqlConn, String tableName, String indexName) throws Exception {
        boolean bool = false;
        try (ResultSet rs = sqlConn.getMetaData().getIndexInfo(sqlConn.getCatalog(), sqlConn.getSchema(), tableName, false, false);){
            while (rs.next()) {
                String vTABLE_CAT = rs.getString("TABLE_CAT");
                String vTABLE_SCHEM = rs.getString("TABLE_SCHEM");
                String tableName2 = rs.getString("TABLE_NAME");
                boolean vNON_UNIQUE = rs.getBoolean("NON_UNIQUE");
                String vINDEX_QUALIFIER = rs.getString("INDEX_QUALIFIER");
                String indexName2 = rs.getString("INDEX_NAME");
                short vTYPE = rs.getShort("TYPE");
                short vORDINAL_POSITION = rs.getShort("ORDINAL_POSITION");
                String vCOLUMN_NAME = rs.getString("COLUMN_NAME");
                String vASC_OR_DESC = rs.getString("ASC_OR_DESC");
                int vCARDINALITY = rs.getInt("CARDINALITY");
                int vPAGES = rs.getInt("PAGES");
                String vFILTER_CONDITION = rs.getString("FILTER_CONDITION");
                if (BcStringUtil.isEmpty(indexName2) || !indexName2.equalsIgnoreCase(indexName)) continue;
                bool = true;
                break;
            }
        }
        return bool;
    }

    public boolean existIndex(SqlConnection sqlConn, String indexName) throws Exception {
        boolean bool = false;
        List<String> tableNameList = this.getTableNameList(sqlConn);
        int i = 0;
        while (i < tableNameList.size()) {
            String tableName = tableNameList.get(i);
            bool = this.existIndex(sqlConn, tableName, indexName);
            if (bool) break;
            ++i;
        }
        return bool;
    }

    public String buildWhereClause(Collection<SqlWhereElement> whereElementCollection, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (SqlWhereElement whereElement : whereElementCollection) {
            if (BcStringUtil.isEmpty(whereElement.getFormula())) {
                String msg = String.format("Formula is empty.", new Object[0]);
                throw new Exception(msg);
            }
            if (sb.length() > 0) {
                sb.append(lineSep);
                sb.append(" ");
                sb.append(whereElement.getLogical());
                sb.append(" ");
            }
            sb.append(whereElement.getFormula());
        }
        return sb.toString();
    }

    public String buildWhereClause(Collection<SqlWhereElement> whereElementCollection) throws Exception {
        return this.buildWhereClause(whereElementCollection, BcStringUtil.lineSeparator);
    }

    public abstract String setLimit(String var1, int var2, int var3) throws Exception;

    public String setLimit(String srcSql, int limit) throws Exception {
        return this.setLimit(srcSql, limit, 0);
    }

    public StringBuilder toNumber(String columnName, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CONVERT(");
        sb.append(columnName);
        sb.append(", INT)");
        return sb;
    }

    public void margeCondition(StringBuilder condition1, String logical, String condition2) throws Exception {
        if (condition2 == null) {
            return;
        }
        if (BcStringUtil.isEmpty(condition2.toString())) {
            return;
        }
        if (!BcStringUtil.isEmpty(condition1)) {
            condition1.append(" ");
            condition1.append(logical);
            condition1.append(" ");
        }
        condition1.append(condition2);
    }

    public boolean isOperatorEquals(String operator) {
        return operator.trim().equals("=");
    }

    public String isNull() {
        return "Is NULL";
    }

    public String isNotNull() {
        return "Is Not NULL";
    }

    public String toCondition(String operator, Object value) throws Exception {
        if (value == null) {
            if (this.isOperatorEquals(operator)) {
                return " " + this.isNull();
            }
            return " " + this.isNotNull();
        }
        Class<?> valueClass = value.getClass();
        if (Number.class.isAssignableFrom(valueClass)) {
            return this.toCondition_number(operator, (Number)value);
        }
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            return this.toCondition_string(operator, value.toString());
        }
        return String.valueOf(operator) + this.toSet(value);
    }

    public String toCondition_string(String operator, String value) throws Exception {
        if (value != null) {
            return String.valueOf(operator) + this.toSet(value);
        }
        if (this.isOperatorEquals(operator)) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public String toCondition_string(SqlConstants.PatternMatch patternMatch, boolean isEquals, String value) throws Exception {
        if (value != null) {
            if (SqlConstants.PatternMatch.exactMatch == patternMatch) {
                if (isEquals) {
                    return "=" + this.toSet(value);
                }
                return "<>" + this.toSet(value);
            }
            return this.toPatternMatch(patternMatch, value);
        }
        if (isEquals) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public String toCondition_number(String operator, Number number) throws Exception {
        if (number != null) {
            return String.valueOf(operator) + number.toString();
        }
        if (this.isOperatorEquals(operator)) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public String toCondition_between1(String columnName1, String columnName2, Object value, boolean isNumber) throws Exception {
        StringBuilder sb = new StringBuilder();
        String tmpStr = null;
        tmpStr = isNumber ? value.toString() : BcStringUtil.singleQuotation(BcStringUtil.toString(value));
        sb.append("(" + columnName1 + " <= " + tmpStr + " AND " + columnName2 + " >= " + tmpStr + ")");
        return sb.toString();
    }

    public String toCondition_between_number(String columnName, Object number1, Object number2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (number1 != null) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + " >= " + number1);
        }
        if (number2 != null) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + " <= " + number2);
        }
        return sb.toString();
    }

    public String toCondition_between_string(String columnName, String str1, String str2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(str1)) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + this.toCondition_string(" >= ", str1));
        }
        if (!BcStringUtil.isEmpty(str2)) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + this.toCondition_string(" <= ", str2));
        }
        return sb.toString();
    }

    public String toCondition_timestamp(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getTimestampFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr);
    }

    public String toCondition_datetime(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getDateTimeFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr);
    }

    public String toCondition_date(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getDateFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr);
    }

    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss.fffffffff";
    }

    public String getTimestampFormatForCondition() {
        return this.getTimestampFormatForUpdate();
    }

    public String getDateTimeFormatForrUpdate() {
        return yyyYMMdd_HHmmss;
    }

    public String getDateTimeFormatForCondition() {
        return yyyYMMdd_HHmmss;
    }

    public String getDateFormatForCondition() {
        return yyyyMMdd;
    }

    public String toCondition_timestamp(String columnName, Calendar calendar) throws Exception {
        if (calendar != null) {
            return String.valueOf(columnName) + "=" + this.toCondition_timestamp(calendar);
        }
        return String.valueOf(columnName) + " " + this.isNull();
    }

    public String toCondition_date(String columnName, Calendar calendar) throws Exception {
        if (calendar != null) {
            return String.valueOf(columnName) + "=" + this.toCondition_date(calendar);
        }
        return String.valueOf(columnName) + " " + this.isNull();
    }

    public String toCondition_period_datetime(String columnName, Calendar datetime1, Calendar datetime2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (datetime1 == null && datetime2 == null) {
            return sb.toString();
        }
        if (datetime1 != null) {
            sb.append(String.valueOf(columnName) + " >= " + this.toCondition_datetime(datetime1));
        }
        if (datetime2 != null) {
            if (datetime1 != null) {
                sb.append(" AND ");
                sb.append(String.valueOf(columnName) + " <= " + this.toCondition_datetime(datetime2));
            } else {
                sb.append(String.valueOf(columnName) + " <= " + this.toCondition_datetime(datetime2));
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_period_date(String columnName, Calendar date1, Calendar date2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (date1 == null && date2 == null) {
            return sb.toString();
        }
        if (date1 != null) {
            Calendar tmpCalendar1 = (Calendar)date1.clone();
            BcTimeUtil.initTimeField(tmpCalendar1);
            sb.append(String.valueOf(columnName) + " >= " + this.toCondition_datetime(tmpCalendar1));
        }
        if (date2 != null) {
            Calendar tmpCalendar2 = (Calendar)date2.clone();
            tmpCalendar2.add(5, 1);
            BcTimeUtil.initTimeField(tmpCalendar2);
            if (date1 != null) {
                sb.append(" AND ");
            }
            sb.append(String.valueOf(columnName) + " < " + this.toCondition_datetime(tmpCalendar2));
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_period_date(String columnName, int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        Calendar calendar1 = BcTimeUtil.toCalendar(yyyyMMdd1);
        Calendar calendar2 = BcTimeUtil.toCalendar(yyyyMMdd2);
        return this.toCondition_period_date(columnName, calendar1, calendar2);
    }

    public String toCondition_period_date(String columnName1, String columnName2, Calendar calendar1, Calendar calendar2, int termMode, boolean nullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (calendar1 == null && calendar2 == null) {
            return sb.toString();
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append(this.toCondition_period_date(columnName1, calendar1, calendar2));
                sb.append(" AND ");
                sb.append(this.toCondition_period_date(columnName2, calendar1, calendar2));
                sb.append(")");
                break;
            }
            case 3: {
                Calendar calendar1Tmp = (Calendar)calendar1.clone();
                BcTimeUtil.initTimeField(calendar1Tmp);
                Calendar calendar2Tmp = (Calendar)calendar2.clone();
                calendar2Tmp.add(5, 1);
                BcTimeUtil.initTimeField(calendar2Tmp);
                sb.append(String.valueOf(columnName1) + " >= " + this.toCondition_datetime(calendar1Tmp));
                sb.append(" AND ");
                sb.append(String.valueOf(columnName2) + " < " + this.toCondition_datetime(calendar2Tmp));
                break;
            }
            default: {
                sb.append(this.toCondition_period_date(columnName1, calendar1, calendar2));
                sb.append(" OR ");
                sb.append(this.toCondition_period_date(columnName2, calendar1, calendar2));
                sb.append(" OR ");
                sb.append(this.toCondition_between_date(columnName1, columnName2, calendar1, nullable));
                sb.append(" OR ");
                sb.append(this.toCondition_between_date(columnName1, columnName2, calendar2, nullable));
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_period_yyyyMMddHHmm(String columnName1, long yyyyMMddHHmm1, long yyyyMMddHHmm2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (yyyyMMddHHmm1 > 0L) {
            sb.append(String.valueOf(columnName1) + ">=" + yyyyMMddHHmm1);
        }
        if (yyyyMMddHHmm2 > 0L) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(String.valueOf(columnName1) + "<=" + yyyyMMddHHmm2);
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    public String toCondition_period_yyyyMMddHHmm(String columnName1, String columnName2, Long yyyyMMddHHmm1, Long yyyyMMddHHmm2, int termMode) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (yyyyMMddHHmm1 == null && yyyyMMddHHmm2 == null) {
            return sb.toString();
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append(String.valueOf(columnName1) + ">=" + yyyyMMddHHmm1 + " AND " + columnName1 + "<=" + yyyyMMddHHmm2);
                sb.append(" AND ");
                sb.append(String.valueOf(columnName2) + ">=" + yyyyMMddHHmm1 + " AND " + columnName2 + "<=" + yyyyMMddHHmm2);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(");
                sb.append(String.valueOf(columnName1) + "<=" + yyyyMMddHHmm1 + " AND " + columnName2 + ">=" + yyyyMMddHHmm2);
                sb.append(")");
                break;
            }
            default: {
                if (yyyyMMddHHmm1 > 0L) {
                    sb.append("(" + columnName1 + "<=" + yyyyMMddHHmm1 + " AND (" + columnName2 + ">=" + yyyyMMddHHmm1 + " OR " + columnName2 + "=" + 0 + "))");
                    if (yyyyMMddHHmm2 > 0L) {
                        sb.append(" OR ");
                        sb.append("(" + columnName1 + ">=" + yyyyMMddHHmm1 + " AND " + columnName1 + "<=" + yyyyMMddHHmm2 + ")");
                        sb.append(" OR ");
                        sb.append("(" + columnName2 + ">=" + yyyyMMddHHmm1 + " AND " + columnName2 + "<=" + yyyyMMddHHmm2 + ")");
                        break;
                    }
                    sb.append(" OR ");
                    sb.append("(" + columnName1 + ">=" + yyyyMMddHHmm1 + " AND " + columnName2 + "=" + 0 + ")");
                    break;
                }
                if (yyyyMMddHHmm2 <= 0L) break;
                sb.append("(" + columnName1 + "<=" + yyyyMMddHHmm2 + ")");
                sb.append(" AND ");
                sb.append("(" + columnName2 + "<=" + yyyyMMddHHmm2 + " OR " + columnName2 + "=" + 0 + ")");
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_period_yyyyMMdd(String columnName1, String columnName2, int yyyyMMdd1, int yyyyMMdd2, int termMode) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (yyyyMMdd1 < 0 && yyyyMMdd2 <= 0) {
            return sb.toString();
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append(String.valueOf(columnName1) + ">=" + yyyyMMdd1 + " AND " + columnName1 + "<=" + yyyyMMdd2);
                sb.append(" AND ");
                sb.append(String.valueOf(columnName2) + ">=" + yyyyMMdd1 + " AND " + columnName2 + "<=" + yyyyMMdd2);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(");
                sb.append(String.valueOf(columnName1) + "<=" + yyyyMMdd1 + " AND " + columnName2 + ">=" + yyyyMMdd2);
                sb.append(")");
                break;
            }
            default: {
                if (yyyyMMdd1 > 0) {
                    sb.append("(" + columnName1 + "<=" + yyyyMMdd1 + " AND (" + columnName2 + ">=" + yyyyMMdd1 + " OR " + columnName2 + "=" + 0 + "))");
                    if (yyyyMMdd2 > 0) {
                        sb.append(" OR ");
                        sb.append("(" + columnName1 + ">=" + yyyyMMdd1 + " AND " + columnName1 + "<=" + yyyyMMdd2 + ")");
                        sb.append(" OR ");
                        sb.append("(" + columnName2 + ">=" + yyyyMMdd1 + " AND " + columnName2 + "<=" + yyyyMMdd2 + ")");
                        break;
                    }
                    sb.append(" OR ");
                    sb.append("(" + columnName1 + ">=" + yyyyMMdd1 + " AND " + columnName2 + "=" + 0 + ")");
                    break;
                }
                if (yyyyMMdd2 <= 0) break;
                sb.append("(" + columnName1 + "<=" + yyyyMMdd2 + ")");
                sb.append(" AND ");
                sb.append("(" + columnName2 + "<=" + yyyyMMdd2 + " OR " + columnName2 + "=" + 0 + ")");
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_period_yyyyMMdd(String columnName, int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (yyyyMMdd1 <= 0 && yyyyMMdd2 <= 0) {
            return sb.toString();
        }
        if (yyyyMMdd1 == yyyyMMdd2) {
            sb.append(String.valueOf(columnName) + " = " + yyyyMMdd1);
        } else {
            sb.insert(0, "(");
            if (yyyyMMdd1 > 0) {
                sb.append(String.valueOf(columnName) + " >= " + yyyyMMdd1);
            }
            if (yyyyMMdd2 > 0) {
                if (yyyyMMdd1 > 0) {
                    sb.append(" AND ");
                }
                sb.append(String.valueOf(columnName) + " <= " + yyyyMMdd2);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String periodOverlap_yyyyMMdd(String columnName1, String columnName2, int yyyyMMdd1, int yyyyMMdd2, boolean isText) throws Exception {
        StringBuilder sb = new StringBuilder();
        String date1wk = null;
        String date2wk = null;
        if (isText) {
            int length = 8;
            date1wk = BcStringUtil.fillPrefix(yyyyMMdd1, length, '0');
            date1wk = BcStringUtil.singleQuotation(date1wk).toString();
            date2wk = BcStringUtil.fillPrefix(yyyyMMdd2, length, '0');
            date2wk = BcStringUtil.singleQuotation(date2wk).toString();
        } else {
            date1wk = Integer.toString(yyyyMMdd1);
            date2wk = Integer.toString(yyyyMMdd2);
        }
        if (yyyyMMdd1 > 0 && yyyyMMdd2 > 0) {
            sb.append("(" + columnName1 + " <= " + date2wk + " AND " + columnName2 + " >= " + date1wk + ")");
        } else if (yyyyMMdd1 > 0 && yyyyMMdd2 <= 0) {
            sb.append(String.valueOf(columnName1) + " >= " + date1wk);
        } else if (yyyyMMdd1 <= 0 && yyyyMMdd2 > 0) {
            sb.append(String.valueOf(columnName2) + " <= " + date2wk);
        }
        return sb.toString();
    }

    public String periodOverlap_yyyyMMdd(String columnName1, String columnName2, int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        return this.periodOverlap_yyyyMMdd(columnName1, columnName2, yyyyMMdd1, yyyyMMdd2, false);
    }

    public String periodOverlap_yyyyMMdd_text(String columnName1, String columnName2, int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        return this.periodOverlap_yyyyMMdd(columnName1, columnName2, yyyyMMdd1, yyyyMMdd2, true);
    }

    public String toCondition_between_datetime(String columnName1, String columnName2, Calendar calendar, boolean isNullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (isNullable) {
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " " + this.isNull());
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
            sb.append(")");
            sb.append(" OR ");
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " " + this.isNull());
            sb.append(")");
            sb.append(" OR ");
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
            sb.append(")");
        } else {
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_between_date(String columnName1, String columnName2, Calendar calendar, boolean nullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (calendar == null) {
            return sb.toString();
        }
        Calendar dateCalendar = (Calendar)calendar.clone();
        BcTimeUtil.initTimeField(dateCalendar);
        return this.toCondition_between_datetime(columnName1, columnName2, dateCalendar, nullable);
    }

    public String toCondition_period_year_month(String yearColumnName, String monthColumnName, int yyyyMMdd1, short HHmm1, int yyyyMMdd2, short HHmm2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("(" + yearColumnName + "*10^4+" + monthColumnName + ") >= " + yyyyMMdd1 * (int)Math.pow(10.0, 4.0) + HHmm1);
        sb.append(" AND ");
        sb.append("(" + yearColumnName + "*10^4+" + monthColumnName + ") <= " + yyyyMMdd2 * (int)Math.pow(10.0, 4.0) + HHmm2);
        sb.append("))");
        return sb.toString();
    }

    public String toCondition_period_year_month(String yearColumnName, String monthColumnName, int year1, int month1, int year2, int month2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("((");
        sb.append(String.valueOf(yearColumnName) + "=" + year1 + " AND " + monthColumnName + ">=" + month1 + " OR " + yearColumnName + ">" + year1);
        sb.append(") AND (");
        sb.append(String.valueOf(yearColumnName) + "=" + year2 + " AND " + monthColumnName + "<=" + month2 + " OR " + yearColumnName + "<" + year2);
        sb.append("))");
        return sb.toString();
    }

    public String toCondition_boolean(String columnName, boolean bool, boolean isEquals) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(columnName);
        if (isEquals) {
            sb.append(" = ");
        } else {
            sb.append(" IS NOT ");
        }
        sb.append(Boolean.toString(bool));
        return sb.toString();
    }

    public String toPatternMatch(boolean isEquals, String pattern) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!isEquals) {
            sb.append(" NOT");
        }
        sb.append(" LIKE ");
        sb.append(BcStringUtil.singleQuotation(pattern));
        return sb.toString();
    }

    public String toPatternMatch(String pattern) throws Exception {
        return this.toPatternMatch(true, pattern);
    }

    public String toPatternMatch(SqlConstants.PatternMatch patternMatch, String pattern) throws Exception {
        if (SqlConstants.PatternMatch.partialMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + pattern + BcStringUtil.PERCENT_STR);
        }
        if (SqlConstants.PatternMatch.forwardMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + pattern);
        }
        if (SqlConstants.PatternMatch.backwardMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(pattern) + BcStringUtil.PERCENT_STR);
        }
        throw new IllegalArgumentException("patternMatch=" + (Object)((Object)patternMatch));
    }

    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder(pattern);
        return sb.toString();
    }

    public String toKeyword(String keyword) throws Exception {
        return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + keyword + BcStringUtil.PERCENT_STR);
    }

    public String toKeywordTop(String columnName, List<Object> keywordList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < keywordList.size()) {
            if (i > 0) {
                sb.append(" OR ");
            }
            Object keyStr = keywordList.get(i);
            sb.append(String.valueOf(columnName) + this.toPatternMatch(String.valueOf(keyStr.toString()) + BcStringUtil.PERCENT_STR));
            ++i;
        }
        return sb.toString();
    }

    public String toKeywordTop(String columnName, Object keyword) throws Exception {
        ArrayList<Object> keywordList = new ArrayList<Object>();
        keywordList.add(keyword);
        return this.toKeywordTop(columnName, keywordList);
    }

    public String toCondition_differentValue(String columnName1, String columnName2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("(" + columnName1 + " <> " + columnName2 + ")");
        sb.append(" OR ");
        sb.append("(" + columnName1 + " Is Not Null AND " + columnName2 + " Is Null)");
        sb.append(" OR ");
        sb.append("(" + columnName1 + " Is Null AND " + columnName2 + " Is Not Null)");
        sb.append(")");
        return sb.toString();
    }

    public int putBinary(SqlConnection sqlConn, String tableName, String columnName, String whereClause, InputStream is, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + tableName + " SET " + columnName + "=" + '?');
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(" WHERE " + whereClause);
        }
        try (SqlPreparedStatement ppst = sqlConn.prepareStatement(sb.toString());){
            ppst.setBinaryStream(1, is, length);
            int n = ppst.executeUpdate();
            return n;
        }
    }

    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return BcStringUtil.singleQuotation("0x" + hex);
    }

    public List<String> toSetList(Collection valueCollection) throws Exception {
        ArrayList<String> setList = new ArrayList<String>();
        for (Object value : valueCollection) {
            setList.add(this.toSet(value));
        }
        return setList;
    }

    public String createColumnNameCsv(MmdModel mmdModel) throws Exception {
        List<String> columnNameList = MmdUtil.toColumnNameList(mmdModel);
        return BcStringUtil.toCsv(columnNameList, true);
    }

    public String toEnumeration(Collection stringCollection) throws Exception {
        return BcStringUtil.marge(stringCollection, BcStringUtil.COMMA_STR);
    }

    public String createInsertQuery(String tableName, List columnNameList, List<? extends CharSequence> textValueList, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineSep2 = BcStringUtil.toStringNotNull(lineSep);
        sb.append("INSERT INTO " + tableName);
        sb.append(lineSep2);
        sb.append(" (");
        sb.append(BcStringUtil.marge(columnNameList, ", "));
        sb.append(")");
        sb.append(lineSep2);
        sb.append(" VALUES");
        sb.append(lineSep2);
        sb.append(" (");
        sb.append(BcStringUtil.marge(textValueList, ", "));
        sb.append(")");
        return sb.toString();
    }

    public List<String> createValueListForPrepareStatement(Collection<SqlSetClause> setClauseCollection, boolean withNumber) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        int index = 0;
        for (SqlSetClause setClause : setClauseCollection) {
            ++index;
            if (BcStringUtil.isEmpty(setClause.function)) {
                StringBuilder sb = new StringBuilder();
                sb.append('?');
                if (withNumber) {
                    sb.append(Integer.toString(index));
                }
                valueList.add(sb.toString());
                continue;
            }
            valueList.add(setClause.function.toString());
        }
        return valueList;
    }

    public List<String> createValueListForPrepareStatement(Collection<SqlSetClause> setClauseCollection) throws Exception {
        return this.createValueListForPrepareStatement(setClauseCollection, false);
    }

    public String createInsertQueryForPrepareStatement(MmdModel mmdModel, String lineSep, boolean withNumber) throws Exception {
        List<String> columnNameList = MmdUtil.toColumnNameList(mmdModel);
        ArrayList<SqlSetClause> setClauseList = new ArrayList<SqlSetClause>();
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            SqlSetClause setClause = new SqlSetClause(columnName, null);
            setClauseList.add(setClause);
            ++i;
        }
        List<String> textValueList = this.createValueListForPrepareStatement(setClauseList, withNumber);
        return this.createInsertQuery(mmdModel.tableName, columnNameList, textValueList, lineSep);
    }

    public String createInsertQueryForPrepareStatement(MmdModel mmdModel) throws Exception {
        return this.createInsertQueryForPrepareStatement(mmdModel, null, false);
    }

    public String createUpdateQuery(String tableName, List columnNameList, List valueList, String whereClause) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + tableName + " SET ");
        int i = 0;
        while (i < columnNameList.size()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columnNameList.get(i) + "=" + this.toSet(valueList.get(i)));
            ++i;
        }
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(whereClause);
        }
        return sb.toString();
    }

    public List<String> toColumnNameList(Collection<SqlSetClause> setClauseCollection) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (SqlSetClause setClause : setClauseCollection) {
            columnNameList.add(setClause.columnName);
        }
        return columnNameList;
    }

    public List<String> toTextValueList(Collection<SqlSetClause> setClauseCollection) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        for (SqlSetClause setClause : setClauseCollection) {
            if (BcStringUtil.isEmpty(setClause.function)) {
                valueList.add(this.toSet(setClause.value));
                continue;
            }
            valueList.add(setClause.function.toString());
        }
        return valueList;
    }

    public String buildInsertQuery(SqlUpdateQuery updateQuery, String lineSep) throws Exception {
        List<String> columnNameList = this.toColumnNameList(updateQuery.getSetClauseList());
        List<String> textValueList = this.toTextValueList(updateQuery.getSetClauseList());
        return this.createInsertQuery(updateQuery.tableName, columnNameList, textValueList, lineSep);
    }

    public String buildInsertQuery(SqlUpdateQuery updateQuery) throws Exception {
        return this.buildInsertQuery(updateQuery, BcStringUtil.lineSeparator);
    }

    public String buildInsertQueryForPrepareStatement(SqlUpdateQuery updateQuery) throws Exception {
        List<String> columnNameList = this.toColumnNameList(updateQuery.getSetClauseList());
        List<String> textValueList = this.createValueListForPrepareStatement(updateQuery.getSetClauseList());
        return this.createInsertQuery(updateQuery.tableName, columnNameList, textValueList, BcStringUtil.lineSeparator);
    }

    public String buildUpdateQuery(SqlUpdateQuery updateQuery, String lineSep, boolean isPreparedStatement) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(updateQuery.tableName);
        sb.append(lineSep);
        sb.append("  SET");
        sb.append(lineSep);
        int i = 0;
        while (i < updateQuery.getSetClauseList().size()) {
            SqlSetClause setClause = updateQuery.getSetClauseList().get(i);
            sb.append("    ");
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append(",");
            }
            sb.append(setClause.columnName);
            sb.append(" = ");
            if (BcStringUtil.isEmpty(setClause.function)) {
                if (isPreparedStatement) {
                    sb.append("?");
                } else {
                    sb.append(this.toSet(setClause.value));
                }
            } else {
                sb.append(setClause.function);
            }
            sb.append(lineSep);
            ++i;
        }
        String whereClause = this.buildWhereClause(updateQuery.getWhereElementList(), lineSep);
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(" WHERE " + whereClause);
        }
        sb.append(lineSep);
        return sb.toString();
    }

    public String buildUpdateQuery(SqlUpdateQuery updateQuery, boolean isPreparedStatement) throws Exception {
        return this.buildUpdateQuery(updateQuery, BcStringUtil.lineSeparator, isPreparedStatement);
    }

    public String buildUpdateQuery(SqlUpdateQuery updateQuery) throws Exception {
        return this.buildUpdateQuery(updateQuery, BcStringUtil.lineSeparator, false);
    }

    public String buildUpdateQueryForPrepareStatement(SqlUpdateQuery updateQuery) throws Exception {
        return this.buildUpdateQuery(updateQuery, BcStringUtil.lineSeparator, true);
    }

    public String buildDeleteQuery(SqlUpdateQuery updateQuery, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(updateQuery.tableName);
        String whereClause = this.buildWhereClause(updateQuery.getWhereElementList(), lineSep);
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(lineSep);
            sb.append(" WHERE " + whereClause);
        }
        sb.append(lineSep);
        return sb.toString();
    }

    public String buildDeleteQuery(SqlUpdateQuery updateQuery) throws Exception {
        return this.buildDeleteQuery(updateQuery, BcStringUtil.lineSeparator);
    }

    public String buildSelectQuery(SqlSelectQuery selectQuery, String lineSep) throws Exception {
        String whereClause;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(lineSep);
        sb.append(this.indent);
        sb.append(BcStringUtil.marge(selectQuery.getSelectColumnList(), String.valueOf(lineSep) + this.indent + ", "));
        sb.append(lineSep);
        sb.append("FROM ");
        sb.append(selectQuery.getFromClause());
        if (!BcCollectionUtil.isEmpty(selectQuery.getWhereElementList()) && !BcStringUtil.isEmpty(whereClause = this.buildWhereClause(selectQuery.getWhereElementList(), lineSep))) {
            sb.append(lineSep);
            sb.append("WHERE ");
            sb.append(whereClause);
        }
        if (!BcCollectionUtil.isEmpty(selectQuery.getGroupByColumnList())) {
            sb.append(lineSep);
            sb.append("GROUP BY ");
            sb.append(BcStringUtil.marge(selectQuery.getGroupByColumnList(), ", "));
        }
        if (!BcCollectionUtil.isEmpty(selectQuery.getGroupByColumnList())) {
            sb.append(lineSep);
            String havingClause = this.buildWhereClause(selectQuery.havingElementList, lineSep);
            if (!BcStringUtil.isEmpty(havingClause)) {
                sb.append("HAVING ");
                sb.append(havingClause);
            }
        }
        if (!BcCollectionUtil.isEmpty(selectQuery.getOrderByList())) {
            sb.append(lineSep);
            sb.append(this.buildOrderBy(selectQuery.getOrderByList(), lineSep));
        }
        if (selectQuery.rowLimit > 0) {
            sb.append(lineSep);
            String newSql = this.setLimit(sb.toString(), selectQuery.rowLimit, selectQuery.rowOffset);
            BcStringUtil.clear(sb);
            sb.append(newSql);
        }
        if (selectQuery.isForUpdate) {
            sb.append(lineSep);
            sb.append("FOR UPDATE");
        }
        return sb.toString();
    }

    public String buildSelectQuery(SqlSelectQuery selectQuery) throws Exception {
        return this.buildSelectQuery(selectQuery, BcStringUtil.lineSeparator);
    }

    public String createSelectQuery(MmdModel mmdModel) throws Exception {
        String columnNameCsv = this.createColumnNameCsv(mmdModel);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT " + columnNameCsv + " FROM " + mmdModel.tableName);
        return sb.toString();
    }

    public String buildOrderBy(List<String> orderByList, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcCollectionUtil.isEmpty(orderByList)) {
            return sb.toString();
        }
        sb.append(lineSep);
        sb.append(" ORDER BY ");
        sb.append(BcStringUtil.marge(orderByList, String.valueOf(lineSep) + this.indent + ", "));
        return sb.toString();
    }

    public long getRowCount(SqlConnection sqlConn, String tableName) throws Exception {
        String query = "SELECT COUNT(*) FROM " + tableName;
        long cnt = 0L;
        try (SqlStatement stmt = sqlConn.createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                cnt = rs.getLong(1);
            }
            rs.close();
        }
        return cnt;
    }

    public Object beginTransaction(SqlConnection sqlConnection) throws Exception {
        Object res = SqlUtil.execute(sqlConnection, "BEGIN");
        return res;
    }

    public Object prepareTransaction(SqlConnection sqlConn, String transactionId) throws Exception {
        String query = "PREPARE TRANSACTION '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlConn, query);
        return res;
    }

    public Object commitPrepared(SqlConnection sqlConn, String transactionId) throws Exception {
        String query = "COMMIT PREPARED '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlConn, query);
        return res;
    }

    public Object rollbackPrepared(SqlConnection sqlConn, String transactionId) throws Exception {
        String query = "ROLLBACK PREPARED '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlConn, query);
        return res;
    }

    public String createTableColumnName(String tableName, String columnName) throws Exception {
        return MmdUtil.createTableColumnName(tableName, columnName, false);
    }

    public String createTableColumnName(String tableName, String columnName, String alias) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createTableColumnName(tableName, columnName));
        sb.append(" AS ");
        sb.append(alias);
        return sb.toString();
    }

    public List<String> createTableColumnNameList(SqlConnection sqlConn, String tableName, String alias) throws Exception {
        ArrayList<String> tableColumnNameList = new ArrayList<String>();
        try (ResultSet rs = sqlConn.getMetaData().getColumns(null, null, tableName, null);){
            while (rs.next()) {
                if (BcStringUtil.isEmpty(alias)) {
                    tableColumnNameList.add(this.createTableColumnName(tableName, rs.getString("COLUMN_NAME")));
                    continue;
                }
                tableColumnNameList.add(this.createTableColumnName(alias, rs.getString("COLUMN_NAME")));
            }
        }
        return tableColumnNameList;
    }

    public List<String> createSelectColumnList(SqlConnection sqlConn, String query) throws Exception {
        int pos2;
        int pos1;
        String query2 = query.toString().toLowerCase();
        String columns = query2.substring((pos1 = query2.indexOf("select")) + 6, pos2 = query2.indexOf("from")).trim();
        List<String> columnNameList = BcStringUtil.stringTokenize(columns, ",", false, true);
        if (columnNameList.size() == 1 && columnNameList.get(0).equals("*")) {
            int sql5;
            String query3 = query2.toString().substring(pos2 + 4).trim();
            int pos3 = query3.indexOf(32);
            String tableName = query3.substring(0, pos3);
            String asName = null;
            String query4 = query2.toString().substring(pos3);
            int pos4 = query4.indexOf(" as ");
            if (pos4 >= 0 && (sql5 = (asName = query4.substring(pos4 + 4).trim()).indexOf(32)) >= 0) {
                asName = asName.substring(0, sql5);
            }
            columnNameList = this.createTableColumnNameList(sqlConn, tableName, asName);
        }
        return columnNameList;
    }

    public String toCommaEnumeration(boolean isNumber, Object array) throws Exception {
        int length = Array.getLength(array);
        ArrayList<String> strList = new ArrayList<String>();
        int i = 0;
        while (i < length) {
            Object value = Array.get(array, i);
            String str = null;
            if (value != null) {
                String encoded = this.escapeEncode(value.toString());
                str = isNumber ? encoded : BcStringUtil.singleQuotation(encoded);
            } else {
                str = "NULL";
            }
            strList.add(str);
            ++i;
        }
        return BcStringUtil.toCsv(strList, true);
    }

    public String numberToCommaEnumeration(Object array) throws Exception {
        return this.toCommaEnumeration(true, array);
    }

    public String stringToCommaEnumeration(String ... array) throws Exception {
        return this.toCommaEnumeration(false, array);
    }

    public StringBuilder coalesce(String ... values) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("coalesce(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(values[i]);
            ++i;
        }
        sb.append(")");
        return sb;
    }

    public StringBuilder margeColumn(String sep, String ... columnNames) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columnNames.length) {
            if (i > 0) {
                sb.append(" || ");
                if (!BcStringUtil.isEmpty(sep)) {
                    sb.append(" || ");
                    sb.append(sep);
                }
            }
            sb.append((CharSequence)this.coalesce(columnNames[i], "''"));
            ++i;
        }
        return sb;
    }

    public String yyyyMMddToTimestamp(String columnName) throws Exception {
        String tmp = "TO_CHAR(" + columnName + ", '99999999')";
        return "TO_TIMESTAMP(" + tmp + ", 'YYYYMMDD')";
    }

    public String yyyyMMddToCahrYYYYMM(String columnName) throws Exception {
        String tmp = this.yyyyMMddToTimestamp(columnName);
        return "TO_CHAR(" + tmp + ", 'YYYYMM')";
    }

    public String yyyyMMddToDate(String columnName) throws Exception {
        String tmp = "TO_CHAR(" + columnName + ", '99999999')";
        return "TO_DATE(" + tmp + ", 'YYYYMMDD')";
    }

    public String yyyyMMddAddMonth(String columnName, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.yyyyMMddToTimestamp(columnName));
        sb.append(" + '" + month + " months'");
        return sb.toString();
    }

    public String timestampToEndOfMonth(String columnName) throws Exception {
        return "DATE_TRUNC('month', " + columnName + " + '1 months') + '-1 days'";
    }

    public String getWildCard() throws Exception {
        return BcStringUtil.PERCENT_STR;
    }

    public String toLineComment(CharSequence comment) {
        return "-- " + BcStringUtil.toStringNotNull(comment);
    }

    public String toInlineComment(String comment) {
        return "/* " + BcStringUtil.toStringNotNull(comment) + " */";
    }

    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        return mmdModel2;
    }

    public String convertSql(String query, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        return query;
    }

    public String getString(SqlConnection sqlConn, String tableName, String columnName, String wherePhrase, String defaultVal) throws Exception {
        String resStr = defaultVal;
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + wherePhrase;
        try (SqlStatement stmt = sqlConn.createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resStr = rs.getString(1);
            }
            rs.close();
        }
        return resStr;
    }

    public int getIndex(List<String> columnNameList, String columnName1) {
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName2 = columnNameList.get(i);
            if (BcStringUtil.equalsIgnoreCase(columnName1, columnName2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void copyRow(ResultSet rs1, int colmunIndex1, SqlContext sqlContext2, PreparedStatement ppst2, int colmunIndex2, int sqlTypeId2, MmdField mmdField2, BcLogger logger) throws Exception {
        ResultSetMetaData rsmd1 = rs1.getMetaData();
        int sqlTypeId1 = rsmd1.getColumnType(colmunIndex1);
        switch (sqlTypeId1) {
            case -1: {
                InputStream io1 = rs1.getBinaryStream(colmunIndex1);
                InputStreamReader inputStreamReader = new InputStreamReader(io1, this.getEncoding());
                sqlContext2.set_LONGVARCHAR(ppst2, colmunIndex2, inputStreamReader);
                break;
            }
            case -4: {
                InputStream io1 = rs1.getBinaryStream(colmunIndex1);
                sqlContext2.set_LONGVARBINARY(ppst2, colmunIndex2, io1);
                break;
            }
            case 2005: {
                Clob clob = rs1.getClob(colmunIndex1);
                ppst2.setCharacterStream(colmunIndex2, clob.getCharacterStream());
                break;
            }
            case 2004: {
                Blob blob = rs1.getBlob(colmunIndex1);
                ppst2.setBinaryStream(colmunIndex2, blob.getBinaryStream());
                break;
            }
            default: {
                Object value = rs1.getObject(colmunIndex1);
                value = this.toJdbcValue(value, sqlTypeId2);
                sqlContext2.setPreStmtValue(ppst2, colmunIndex2, sqlTypeId2, value);
            }
        }
    }

    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet(rs, sqlStatement);
    }

    public boolean existTable(SqlConnection sqlConn, String objectName) throws Exception {
        boolean exist = false;
        try (ResultSet rs = sqlConn.getMetaData().getTables(sqlConn.getCatalog(), sqlConn.getSchema(), null, null);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(objectName)) continue;
                exist = true;
                break;
            }
        }
        return exist;
    }

    public boolean existColumn(SqlConnection sqlConn, CharSequence tableName, CharSequence columnName) throws Exception {
        boolean exist = false;
        try (ResultSet rs = sqlConn.getMetaData().getColumns(sqlConn.getCatalog(), sqlConn.getSchema(), tableName.toString(), columnName.toString());){
            if (rs.next()) {
                exist = true;
            }
        }
        return exist;
    }

    public int copyColumn(SqlConnection sqlConn, String tableName, String columnName1, String columnName2) throws Exception {
        String query = "UPDATE " + tableName + " SET " + columnName2 + " = " + columnName1;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int remakeColumn(SqlConnection sqlConn, String tableName, String columnName1, String columnName2, String dataType) throws Exception {
        String tmpColumnName = "temp_field";
        if (BcStringUtil.isEmpty(columnName2)) {
            columnName2 = columnName1;
        }
        this.addColumn(sqlConn, tableName, tmpColumnName, dataType);
        this.copyColumn(sqlConn, tableName, columnName1, tmpColumnName);
        this.dropColumn(sqlConn, tableName, columnName1);
        this.addColumn(sqlConn, tableName, columnName2, dataType);
        int cnt = this.copyColumn(sqlConn, tableName, tmpColumnName, columnName2);
        this.dropColumn(sqlConn, tableName, tmpColumnName);
        return cnt;
    }

    public int remakeColumn(SqlConnection sqlConn, String tableName, String columnName1, String dataType) throws Exception {
        return this.remakeColumn(sqlConn, tableName, columnName1, null, dataType);
    }

    public static enum Function {
        connectionIsValid,
        statementIsClosed,
        queryTimeout,
        selectForUpdate,
        resultSetScroll,
        inputStreamAvailable;

    }

    public static enum RegexFrag {
        i,
        c,
        n,
        m;

    }
}

