/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.barcode.renderer;

import ext.lib.barcode.renderer.DcfAbstractBarcodeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import nlc.lib.barcode.DcfItfContext;

public class DcfItfRenderer
extends DcfAbstractBarcodeRenderer {
    protected DcfItfContext itfContext;

    public DcfItfRenderer(DcfItfContext itfContext) {
        this.itfContext = itfContext;
    }

    public static String getPattern(int num) throws Exception {
        String pattern = null;
        switch (num) {
            case 0: {
                pattern = "00110";
                break;
            }
            case 1: {
                pattern = "10001";
                break;
            }
            case 2: {
                pattern = "01001";
                break;
            }
            case 3: {
                pattern = "11000";
                break;
            }
            case 4: {
                pattern = "00101";
                break;
            }
            case 5: {
                pattern = "10100";
                break;
            }
            case 6: {
                pattern = "01100";
                break;
            }
            case 7: {
                pattern = "00011";
                break;
            }
            case 8: {
                pattern = "10010";
                break;
            }
            case 9: {
                pattern = "01010";
                break;
            }
            default: {
                throw new Exception("num=" + num);
            }
        }
        return pattern;
    }

    @Override
    public double[] getSize(String value) throws Exception {
        double[] dim = this.drawBarcodeL2(null, 0.0, 0.0, value);
        return dim;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String value) throws Exception {
        double[] dim = this.drawBarcodeL2(null, bx, by, value);
        this.drawBarcodeL2(g2d, bx, by, value);
    }

    protected double[] drawBarcodeL2(Graphics2D g2d, double bx, double by, String value) throws Exception {
        Rectangle2D.Double rectangle;
        double bx2 = bx;
        double by2 = by;
        if (g2d != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(bx2, by2, 1000.0, 1000.0);
        }
        if (g2d != null) {
            rectangle = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthZero, this.itfContext.barHeight);
            g2d.setColor(Color.BLACK);
            g2d.fill(rectangle);
        }
        bx2 += this.itfContext.barWidthZero;
        bx2 += this.itfContext.spaceWidth;
        if (g2d != null) {
            rectangle = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthZero, this.itfContext.barHeight);
            g2d.fill(rectangle);
        }
        bx2 += this.itfContext.barWidthZero;
        bx2 += this.itfContext.spaceWidth;
        int unitCnt = value.length() / 2;
        int i = 0;
        while (i < unitCnt) {
            int num1 = Integer.parseInt(value.substring(i * 2, i * 2 + 1));
            String pattern1 = DcfItfRenderer.getPattern(num1);
            int num2 = Integer.parseInt(value.substring(i * 2 + 1, i * 2 + 2));
            String pattern2 = DcfItfRenderer.getPattern(num2);
            int j = 0;
            while (j < 5) {
                int flg1 = Integer.parseInt(pattern1.substring(j, j + 1));
                if (flg1 == 1) {
                    if (g2d != null) {
                        Rectangle2D.Double rectangle2 = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthOne, this.itfContext.barHeight);
                        g2d.fill(rectangle2);
                    }
                    bx2 += this.itfContext.barWidthOne;
                } else {
                    if (g2d != null) {
                        Rectangle2D.Double rectangle3 = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthZero, this.itfContext.barHeight);
                        g2d.fill(rectangle3);
                    }
                    bx2 += this.itfContext.barWidthZero;
                }
                int flg2 = Integer.parseInt(pattern2.substring(j, j + 1));
                bx2 = flg2 == 1 ? (bx2 += this.itfContext.barWidthOne) : (bx2 += this.itfContext.barWidthZero);
                ++j;
            }
            ++i;
        }
        if (g2d != null) {
            Rectangle2D.Double rectangle4 = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthOne, this.itfContext.barHeight);
            g2d.fill(rectangle4);
        }
        bx2 += this.itfContext.barWidthOne;
        bx2 += this.itfContext.spaceWidth;
        if (g2d != null) {
            Rectangle2D.Double rectangle5 = new Rectangle2D.Double(bx2, by2, this.itfContext.barWidthZero, this.itfContext.barHeight);
            g2d.fill(rectangle5);
        }
        double[] dim = new double[]{(bx2 += this.itfContext.barWidthZero) - bx, this.itfContext.barHeight};
        return dim;
    }
}

