/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.rmo;

import ext.appfw.common.AfbApplication;
import ext.base.log.BcLogger;
import ext.lib.datasource.DtsSession;
import ext.lib.doc.util.DcfBookFile;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.module.dcmn.server.DcmnDocumentHandle;
import ext.scf.server.ScfServerContainer;
import ext.scf.server.ScfServerLoggerManager;
import java.io.File;
import nlc.lib.doc.DcfPage;

public abstract class DcmnAbstractReportRMO
extends RmiAbstractRMO {
    protected RmiRmoArgument rmoArg;
    protected DcfBookFile bookFile1;
    protected DtsSession dtsSession;
    protected SqlContext sqlContext;
    protected BcLogger logger;

    public void createDocument(RmiRmoArgument rmoArg) throws Exception {
        this.rmoArg = rmoArg;
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        this.logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        this.dtsSession = rmoArg.getDtsSession(this);
        this.sqlContext = this.dtsSession.getSqlContext();
        this.bookFile1 = new DcfBookFile();
        this.process();
    }

    public File createTempFile() throws Exception {
        File docDir = new File(AfbApplication.getInstance().toReal("${APP}data/doc/"));
        if (!docDir.exists()) {
            docDir.mkdirs();
        }
        File file = File.createTempFile("doc", ".tmp", docDir);
        return file;
    }

    public void process() throws Exception {
        this.bookFile1.setWriteMode(AfbApplication.getInstance().getTempDir());
        this.createReport();
        this.logger.debug("===========================================================================");
        this.logger.debug("pageFiler1.getPageCount()=" + this.bookFile1.getPageCount());
        if (this.bookFile1.getPageCount() > 0) {
            File destZipFile = this.createTempFile();
            this.logger.debug("destZipFile=" + destZipFile.getPath());
            this.bookFile1.toZipFile(destZipFile);
            DcmnDocumentHandle docHandle = new DcmnDocumentHandle(this.rmoArg.getAgent());
            docHandle.setBook(this.bookFile1);
            ScfServerContainer.getInstance().getHandleManager().addHandle(docHandle);
            this.rmoArg.getRespons().addData(docHandle.getHandleId());
            this.rmoArg.getRespons().addData(destZipFile.getPath());
        } else {
            this.logger.debug("page=0");
        }
        this.bookFile1.close();
    }

    public abstract void createReport() throws Exception;

    public final void replace(DcfPage page, int pageNo, int pageCount) throws Exception {
    }
}

