/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;
import sun.security.rsa.RSAUtil;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public abstract class RSASignature
extends SignatureSpi {
    private static final int baseLength = 8;
    private final ObjectIdentifier digestOID;
    private final int encodedLength;
    private final MessageDigest md;
    private boolean digestReset;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private RSAPadding padding;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n) {
        this.digestOID = objectIdentifier;
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.digestReset = true;
        this.encodedLength = 8 + n + this.md.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.privateKey = null;
        this.publicKey = rSAPublicKey;
        this.initCommon(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.privateKey = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.publicKey = null;
        this.initCommon(rSAPrivateKey, secureRandom);
    }

    private void initCommon(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            RSAUtil.checkParamsAgainstType(RSAUtil.KeyType.RSA, rSAKey.getParams());
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException("Invalid key for RSA signatures", providerException);
        }
        this.resetDigest();
        int n = RSACore.getByteLength(rSAKey);
        try {
            this.padding = RSAPadding.getInstance(1, n, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n2 = this.padding.getMaxDataSize();
        if (this.encodedLength > n2) {
            throw new InvalidKeyException("Key is too short for this signature algorithm");
        }
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.md.update(by);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.md.update(byArray, n, n2);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Missing private key");
        }
        byte[] byArray = this.getDigestValue();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.digestOID, byArray);
            byte[] byArray3 = this.padding.pad(byArray2);
            if (byArray3 != null) {
                return RSACore.rsa(byArray3, this.privateKey, true);
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new SignatureException("Could not sign data", exception);
        }
        throw new SignatureException("Could not sign data");
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.publicKey == null) {
            throw new SignatureException("Missing public key");
        }
        if (byArray.length != RSACore.getByteLength(this.publicKey)) {
            throw new SignatureException("Bad signature length: got " + byArray.length + " but was expecting " + RSACore.getByteLength(this.publicKey));
        }
        try {
            byte[] byArray2 = RSACore.rsa(byArray, this.publicKey);
            byte[] byArray3 = this.getDigestValue();
            byte[] byArray4 = RSASignature.encodeSignature(this.digestOID, byArray3);
            byte[] byArray5 = this.padding.pad(byArray4);
            if (MessageDigest.isEqual(byArray5, byArray2)) {
                return true;
            }
            byArray4 = RSASignature.encodeSignatureWithoutNULL(this.digestOID, byArray3);
            byArray5 = this.padding.pad(byArray4);
            return MessageDigest.isEqual(byArray5, byArray2);
        }
        catch (IOException | BadPaddingException exception) {
            return false;
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    static byte[] encodeSignatureWithoutNULL(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameters accepted");
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static final class MD2withRSA
    extends RSASignature {
        public MD2withRSA() {
            super("MD2", AlgorithmId.MD2_oid, 10);
        }
    }

    public static final class MD5withRSA
    extends RSASignature {
        public MD5withRSA() {
            super("MD5", AlgorithmId.MD5_oid, 10);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super("SHA-1", AlgorithmId.SHA_oid, 7);
        }
    }

    public static final class SHA224withRSA
    extends RSASignature {
        public SHA224withRSA() {
            super("SHA-224", AlgorithmId.SHA224_oid, 11);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super("SHA-256", AlgorithmId.SHA256_oid, 11);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super("SHA-384", AlgorithmId.SHA384_oid, 11);
        }
    }

    public static final class SHA512_224withRSA
    extends RSASignature {
        public SHA512_224withRSA() {
            super("SHA-512/224", AlgorithmId.SHA512_224_oid, 11);
        }
    }

    public static final class SHA512_256withRSA
    extends RSASignature {
        public SHA512_256withRSA() {
            super("SHA-512/256", AlgorithmId.SHA512_256_oid, 11);
        }
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super("SHA-512", AlgorithmId.SHA512_oid, 11);
        }
    }
}

