/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.BasicShape;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Arc
extends BasicShape
implements DrawOperation {
    protected int width = 0;
    protected int height = 0;
    protected int start = 0;
    protected int stop = 0;
    protected int type = 0;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public void setType(String strType) {
        if (strType.equalsIgnoreCase("open")) {
            this.type = 0;
        } else if (strType.equalsIgnoreCase("pie")) {
            this.type = 2;
        } else if (strType.equalsIgnoreCase("chord")) {
            this.type = 1;
        }
    }

    @Override
    public PlanarImage executeDrawOperation() {
        BufferedImage bi = new BufferedImage(this.width + this.stroke_width * 2, this.height + this.stroke_width * 2, 7);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        if (!this.stroke.equals("transparent")) {
            BasicStroke bStroke = new BasicStroke(this.stroke_width);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            graphics.draw(new Arc2D.Double(this.stroke_width, this.stroke_width, this.width, this.height, this.start, this.stop, this.type));
        }
        if (!this.fill.equals("transparent")) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            graphics.fill(new Arc2D.Double(this.stroke_width, this.stroke_width, this.width, this.height, this.start, this.stop, this.type));
        }
        int size = this.instructions.size();
        int i = 0;
        while (i < size) {
            ImageOperation instr = (ImageOperation)this.instructions.elementAt(i);
            if (instr instanceof DrawOperation) {
                PlanarImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img.getAsBufferedImage(), null, 0, 0);
            } else if (instr instanceof TransformOperation) {
                graphics = (Graphics2D)bi.getGraphics();
                PlanarImage image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
                bi = image.getAsBufferedImage();
            }
            ++i;
        }
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

