/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.util.BcCollectionUtil;
import ext.lib.html.util.HtmlToPlain;
import ext.module.xdts.common.EtcSqlConditionUtil;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectColumn;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import ext.module.xdts.model.v0001.XdtsSelectElemet;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.Model;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class XdtsSqlParser
extends BcLoggableObject {
    HtmlToPlain htmlToPlain = new HtmlToPlain();

    public Select extractSelect(String sql) throws Exception {
        Statement statement2;
        this.getLogger().info("");
        this.getLogger().info("--------------------------------------------------");
        this.getLogger().info("#parseSelect");
        this.getLogger().info("sql=" + sql);
        this.getLogger().info("--------------------------------------------------");
        Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
        List statementLsitList = statements.getStatements();
        this.getLogger().info("Statement\u6570=" + statementLsitList.size());
        for (Statement statement2 : statementLsitList) {
            this.getLogger().debug("statement=" + statement2);
        }
        if (statementLsitList.size() > 1) {
            String msg = "Statement\u304c\u8907\u6570\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002Statement\u6570=" + statementLsitList.size();
            throw new Exception(msg);
        }
        statement2 = (Statement)BcCollectionUtil.getFirst(statementLsitList);
        Select select = null;
        if (!(statement2 instanceof Select)) {
            String msg = "SELECT\u6587\u3068\u3057\u3066\u89e3\u6790\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new Exception(msg);
        }
        select = (Select)statement2;
        return select;
    }

    public XdtsExtractionCondition createExtractionCondition(String sql) throws Exception {
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.selectContextList = new ArrayList<XdtsSelectContext>();
        extractionCondition.sqlOrign = sql;
        Select select = this.extractSelect(sql);
        this.parseSelect(select, extractionCondition);
        return extractionCondition;
    }

    public void parseSelect(Select select, XdtsExtractionCondition extractionCondition) throws Exception {
        this.getLogger().debug("[Select]=" + select);
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("select", (Model)select));
        SelectBody selectBody = select.getSelectBody();
        this.parse(selectBody, extractionCondition, null, null);
        List withItemList = select.getWithItemsList();
        if (withItemList != null) {
            for (WithItem withItem : withItemList) {
                this.getLogger().debug("#withItem=" + withItem);
            }
        }
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList((Statement)select);
        for (String tableName : tableNames) {
            this.getLogger().debug("#tableName=" + tableName);
        }
    }

    public void parse(SelectBody selectBody, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectBody", (Model)selectBody));
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            XdtsSelectContext xdtsSelectContext = this.createSelectContext(plainSelect, extractionCondition, parentSelectContext, parentElem);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            this.getLogger().debug("selectBodyList.size()=" + selectBodyList.size());
            this.parse(setOperationList, extractionCondition, parentSelectContext, parentElem);
        } else {
            throw new Exception("selectBody class=" + selectBody.getClass().getName());
        }
    }

    public void parse(SetOperationList setOperationList, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("setOperationList", (Model)setOperationList));
        List selectBodyList = setOperationList.getSelects();
        for (SelectBody selectBody : selectBodyList) {
            this.parse(selectBody, extractionCondition, parentSelectContext, parentElem);
        }
        List bracketList = setOperationList.getBrackets();
        this.getLogger().debug("bracketList=" + bracketList);
        this.getLogger().debug("setOperationList.getFetch()=" + setOperationList.getFetch());
        this.getLogger().debug("setOperationList.getLimit()=" + setOperationList.getLimit());
        this.getLogger().debug("setOperationList.getOffset()=" + setOperationList.getOffset());
        List operationList = setOperationList.getOperations();
        this.getLogger().debug("operationList=" + operationList);
        List orderByElement = setOperationList.getOrderByElements();
        this.getLogger().debug("orderByElement=" + orderByElement);
    }

    public void parseFrom(FromItem fromItem, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("fromItem", (Model)fromItem));
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.getLogger().debug("[subSelect]=" + subSelect);
            this.parse(subSelect, extractionCondition, parentSelectContext, parentElem);
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            this.getLogger().debug("[Table]=" + table + " class=" + table.getClass().getSimpleName());
        } else if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            this.getLogger().debug("[SubJoin]=" + subJoin + " class=" + subJoin.getClass().getSimpleName());
            FromItem fromItem2 = subJoin.getLeft();
            this.getLogger().debug("subJoin.getLeft()=" + subJoin.getLeft());
            this.getLogger().debug("subJoin.getPivot()=" + subJoin.getPivot() + " getUnPivot=" + subJoin.getUnPivot());
            this.getLogger().debug("subJoin.getAlias()=" + subJoin.getAlias());
            this.getLogger().debug("subJoin.getJoinList()=" + subJoin.getJoinList());
            this.parseFrom(fromItem2, extractionCondition, parentSelectContext, parentElem);
        } else {
            throw new Exception(fromItem.getClass().getName());
        }
    }

    public void parse(SubSelect subSelect, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("subSelect", (Model)subSelect));
        this.getLogger().debug("subSelect.getAlias()=" + subSelect.getAlias());
        this.getLogger().debug("subSelect.getPivot()=" + subSelect.getPivot());
        this.getLogger().debug("subSelect.getUnPivot()=" + subSelect.getUnPivot());
        SelectBody selectBody = subSelect.getSelectBody();
        this.parse(selectBody, extractionCondition, parentSelectContext, parentElem);
        List withItemsList = subSelect.getWithItemsList();
        this.getLogger().debug("withItemsList=" + withItemsList);
    }

    public void parseWhere(Expression where, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        this.getLogger().debug(XdtsSqlParserUtil.expressionLog("where", (Model)where));
        if (where == null) {
            return;
        }
        if (where instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)where;
            Expression leftExpression = binaryExpression.getLeftExpression();
            this.parseWhere(leftExpression, extractionCondition, parentSelectContext, parentElem);
            Expression rightExpression = binaryExpression.getRightExpression();
            this.parseWhere(rightExpression, extractionCondition, parentSelectContext, parentElem);
        } else if (where instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)where;
            this.parseWhere(parenthesis.getExpression(), extractionCondition, parentSelectContext, parentElem);
        } else if (where instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)where;
            this.parse(subSelect, extractionCondition, parentSelectContext, parentElem);
        }
    }

    public XdtsSelectContext createSelectContext(PlainSelect plainSelect, XdtsExtractionCondition extractionCondition, XdtsSelectContext parentSelectContext, XdtsSelectElemet parentElem) throws Exception {
        Expression expression;
        XdtsSelectContext selectContext = new XdtsSelectContext();
        selectContext.controlContextList = new ArrayList<XdtsControlContext>();
        selectContext.id = extractionCondition.selectContextList.size();
        selectContext.queryOrign = plainSelect.toString();
        extractionCondition.selectContextList.add(selectContext);
        String placeholder = XdtsSqlParserUtil.toPlaceholderSubSelect(selectContext.id);
        this.getLogger().debug("placeholder=" + placeholder);
        if (parentElem != null) {
            StringBuilder sb = XdtsSqlParser.replaceFirst(parentElem.template, plainSelect.toString(), placeholder);
            this.getLogger().debug("sb=" + sb);
            parentElem.template = sb.toString();
        }
        selectContext.selectColumnList = new ArrayList<XdtsSelectColumn>();
        int i = 0;
        while (i < plainSelect.getSelectItems().size()) {
            SelectItem selectItem = (SelectItem)plainSelect.getSelectItems().get(i);
            this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectItem", selectItem));
            if (selectItem instanceof SelectExpressionItem) {
                Alias alias;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                Expression expression2 = selectExpressionItem.getExpression();
                this.getLogger().debug(XdtsSqlParserUtil.expressionLog("selectExpressionItem", (Model)expression2));
                XdtsSelectColumn selectColumn = new XdtsSelectColumn();
                selectColumn.tableColumnName = new XdtsSelectElemet();
                selectColumn.tableColumnName.template = selectColumn.tableColumnName.orign = expression2.toString();
                if (expression2 instanceof SubSelect) {
                    SubSelect subSelect = (SubSelect)expression2;
                    this.parse(subSelect, extractionCondition, parentSelectContext, selectColumn.tableColumnName);
                }
                if ((alias = selectExpressionItem.getAlias()) != null) {
                    selectColumn.alias = alias.getName();
                }
                selectColumn.order = i + 1;
                selectContext.selectColumnList.add(selectColumn);
            } else if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                XdtsSelectColumn selectColumn = new XdtsSelectColumn();
                selectColumn.tableColumnName = new XdtsSelectElemet();
                selectColumn.tableColumnName.template = selectColumn.tableColumnName.orign = selectItem.toString();
                selectColumn.order = i + 1;
                selectContext.selectColumnList.add(selectColumn);
            } else {
                throw new Exception(selectItem.toString());
            }
            ++i;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createFromContext();
        FromItem fromItem = plainSelect.getFromItem();
        StringBuilder sb = new StringBuilder();
        sb.append(fromItem.toString());
        List joinList = plainSelect.getJoins();
        if (!BcCollectionUtil.isEmpty(joinList)) {
            int i2 = 0;
            while (i2 < joinList.size()) {
                Join join = (Join)joinList.get(i2);
                this.getLogger().debug("join=" + join);
                sb.append("\n " + join.toString());
                ++i2;
            }
        }
        selectContext.from = new XdtsSelectElemet();
        selectContext.from.template = selectContext.from.orign = sb.toString();
        selectContext.controlContextList.add(controlContext);
        this.parseFrom(fromItem, extractionCondition, selectContext, selectContext.from);
        Expression where = plainSelect.getWhere();
        selectContext.whereBase = new XdtsSelectElemet();
        selectContext.whereBase.template = selectContext.whereBase.orign = BcStringUtil.toString(where);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        selectContext.controlContextList.add(controlContext);
        this.parseWhere(where, extractionCondition, parentSelectContext, selectContext.whereBase);
        GroupByElement groupByElement = plainSelect.getGroupBy();
        if (groupByElement == null) {
            selectContext.groupBy = null;
        } else {
            ExpressionList expressionList = groupByElement.getGroupByExpressionList();
            List expressionList2 = expressionList.getExpressions();
            this.getLogger().debug("expressionList2.size()=" + expressionList2.size());
            sb = new StringBuilder();
            int i3 = 0;
            while (i3 < expressionList2.size()) {
                expression = (Expression)expressionList2.get(i3);
                this.getLogger().debug(XdtsSqlParserUtil.expressionLog("groupByElement", (Model)expression));
                if (i3 > 0) {
                    sb.append(", ");
                }
                sb.append(expression.toString());
                ++i3;
            }
            selectContext.groupBy = sb.toString();
        }
        Expression havingExpression = plainSelect.getHaving();
        selectContext.having = new XdtsSelectElemet();
        selectContext.having.template = selectContext.having.orign = BcStringUtil.toString(havingExpression);
        this.parseWhere(havingExpression, extractionCondition, parentSelectContext, selectContext.having);
        controlContext = XdtsSqlParserUtil.orderByContext();
        selectContext.controlContextList.add(controlContext);
        List orderByElementList = plainSelect.getOrderByElements();
        selectContext.orderByList = new ArrayList<MmdIndex>();
        if (orderByElementList != null) {
            MmdIndex mmdIndex = new MmdIndex();
            int i4 = 0;
            while (i4 < orderByElementList.size()) {
                OrderByElement orderByElement = (OrderByElement)orderByElementList.get(i4);
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = orderByElement.getExpression().toString();
                indexElement.isAscending = orderByElement.isAsc();
                mmdIndex.indexElementList.add(indexElement);
                ++i4;
            }
            selectContext.orderByList.add(mmdIndex);
        }
        if (selectContext.orderByList.size() > 0) {
            MmdIndex mmdIndex = selectContext.orderByList.get(0);
            controlContext.defaultValue = EtcSqlConditionUtil.createIndex(mmdIndex);
        }
        controlContext = XdtsSqlParserUtil.rowLimitContext();
        Limit limit = plainSelect.getLimit();
        BcLogUtil.debug("limit=" + limit);
        if (limit == null) {
            controlContext.defaultValue = null;
        } else {
            expression = limit.getRowCount();
            controlContext.defaultValue = expression.toString();
        }
        selectContext.controlContextList.add(controlContext);
        return selectContext;
    }

    public static StringBuilder replaceFirst(String src, String target, String replacement) {
        int idx1;
        BcLogUtil.debug("src=" + src + " target=" + target + " replacement=" + replacement);
        StringBuilder sb = new StringBuilder();
        if (BcStringUtil.isEmpty(src)) {
            return sb;
        }
        if (BcStringUtil.isEmpty(target)) {
            sb.append(src);
            return sb;
        }
        if (BcStringUtil.isEmpty(replacement)) {
            replacement = "";
        }
        if ((idx1 = src.indexOf(target)) < 0) {
            return sb;
        }
        sb.append(src.substring(0, idx1));
        sb.append(replacement);
        sb.append(src.substring(idx1 + target.length()));
        return sb;
    }
}

