/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.fx.control.FxTextField;
import java.math.BigDecimal;
import javafx.geometry.Pos;

public class FxNumberField
extends FxTextField {
    protected int integerPartDigit;
    private int decimalDigit;
    protected int roundingMode = 4;
    public boolean nullable;
    private Number defauleValue = 0;

    public int getDecimalDigit() {
        return this.decimalDigit;
    }

    public void setDecimalDigit(int decimalDigit) {
        this.decimalDigit = decimalDigit;
    }

    public FxNumberField(int integerPartDigit, int decimalDigit, boolean nullable) {
        this.integerPartDigit = integerPartDigit;
        this.decimalDigit = decimalDigit;
        this.nullable = nullable;
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    public FxNumberField() {
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    public void textEdited() {
        if (BcStringUtil.isEmpty(this.getText())) {
            if (!this.nullable) {
                BigDecimal bigDecimal = new BigDecimal(this.defauleValue.toString());
                this.setValue(bigDecimal);
            }
            return;
        }
        try {
            BigDecimal bigDecimal = BcNumberUtil.toBigDecimal2(this.getText(), this.integerPartDigit, this.decimalDigit, this.roundingMode);
            this.setValue(bigDecimal);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            super.setText(null);
        }
    }

    public BigDecimal getBigDecimal() {
        BigDecimal bigDecimal = null;
        if (!BcStringUtil.isEmpty(this.getText())) {
            bigDecimal = new BigDecimal(this.getText());
        }
        return bigDecimal;
    }

    public void setValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setText(null);
        } else {
            this.setText(bigDecimal.toString());
        }
    }

    public void setValue(Number number) {
        BigDecimal bigDecimal2 = null;
        if (number != null) {
            bigDecimal2 = new BigDecimal(number.toString());
        }
        this.setValue(bigDecimal2);
    }
}

