/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

public class GroupImpl
implements Group {
    private Vector<Principal> groupMembers = new Vector(50, 100);
    private String group;

    public GroupImpl(String string) {
        this.group = string;
    }

    public boolean addMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return false;
        }
        if (this.group.equals(principal.toString())) {
            throw new IllegalArgumentException();
        }
        this.groupMembers.addElement(principal);
        return true;
    }

    public boolean removeMember(Principal principal) {
        return this.groupMembers.removeElement(principal);
    }

    public Enumeration<? extends Principal> members() {
        return this.groupMembers.elements();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        return this.group.equals(group.toString());
    }

    public boolean equals(Group group) {
        return this.equals((Object)group);
    }

    public String toString() {
        return this.group;
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public boolean isMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return true;
        }
        Vector<Group> vector = new Vector<Group>(10);
        return this.isMemberRecurse(principal, vector);
    }

    public String getName() {
        return this.group;
    }

    boolean isMemberRecurse(Principal principal, Vector<Group> vector) {
        Enumeration<? extends Principal> enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            GroupImpl groupImpl;
            boolean bl = false;
            Principal principal2 = enumeration.nextElement();
            if (principal2.equals(principal)) {
                return true;
            }
            if (principal2 instanceof GroupImpl) {
                groupImpl = (GroupImpl)((Object)principal2);
                vector.addElement(this);
                if (!vector.contains(groupImpl)) {
                    bl = groupImpl.isMemberRecurse(principal, vector);
                }
            } else if (principal2 instanceof Group && !vector.contains(groupImpl = (Group)principal2)) {
                bl = groupImpl.isMember(principal);
            }
            if (!bl) continue;
            return bl;
        }
        return false;
    }
}

