/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCsvUtil;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.SqlConditionSpliter;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.lib.sql.model.SqlWherecQuery;
import ext.libx.etc.model.EtcColumnCondition;
import ext.libx.etc.model.EtcGeneralCondition;
import java.util.Calendar;
import java.util.List;

public class EtcSqlConditionUtil {
    private EtcSqlConditionUtil() throws Exception {
    }

    public static String createIndex(MmdIndex mmdIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexElement.columnName);
            if (!indexElement.isAscending) {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }

    public static SqlSelectQuery createSelectSql(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        BcLogUtil.debug("tableColumnNameList=" + tableColumnNameList);
        selectQuery.getSelectColumnList().addAll(tableColumnNameList);
        selectQuery.setFromClause(mmdModel.tableName);
        selectQuery.rowLimit = 100;
        return selectQuery;
    }

    public static EtcGeneralCondition createCondition(MmdModel mmdModel) throws Exception {
        EtcGeneralCondition condition = new EtcGeneralCondition();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            condition.orderByColumnNames = EtcSqlConditionUtil.createIndex(primaryKey);
        }
        return condition;
    }

    public static SqlSelectQuery createSelectSql(SqlContext sqlContext, EtcGeneralCondition generalCondition) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(generalCondition.tableColumnNameList);
        selectQuery.setFromClause(generalCondition.fromClause);
        EtcSqlConditionUtil.createWhereClause(sqlContext, selectQuery, generalCondition);
        if (!BcStringUtil.isEmpty(generalCondition.orderByColumnNames)) {
            List<String> tokenList = BcStringUtil.stringTokenize(generalCondition.orderByColumnNames, BcStringUtil.COMMA_STR, true, true);
            selectQuery.getOrderByList().addAll(tokenList);
        }
        if (generalCondition.rowLimit >= 0) {
            selectQuery.rowOffset = 0;
            selectQuery.rowLimit = generalCondition.rowLimit;
        }
        return selectQuery;
    }

    public static void createWhereClause(SqlContext sqlContext, SqlSelectQuery selectQuery, EtcGeneralCondition generalCondition) throws Exception {
        for (EtcColumnCondition columnCondition : generalCondition.columnConditionList) {
            if (BcStringUtil.isEmpty(columnCondition.value)) continue;
            EtcSqlConditionUtil.createWhereClause_L2(sqlContext, selectQuery, columnCondition);
        }
    }

    public static void createWhereClause_L2(SqlContext sqlContext, SqlWherecQuery wherecClauseSql, EtcColumnCondition columnCondition) throws Exception {
        if (BcStringUtil.isEmpty(columnCondition.value)) {
            return;
        }
        if (SqlUtil.isNumber(columnCondition.sqlTypeId)) {
            SqlConditionParser.getInstance().parseCondition4Number(wherecClauseSql, sqlContext, columnCondition.tableColumnName, columnCondition.value);
        } else if (SqlUtil.isText(columnCondition.sqlTypeId)) {
            List<String> conditionValueList = SqlConditionSpliter.getInstance().split(columnCondition.value);
            if (conditionValueList.size() > 0) {
                String tmpStr = SqlConditionUtil.createPatternMatchClause(sqlContext, columnCondition.tableColumnName, columnCondition.patternMatch, true, false, conditionValueList);
                SqlWhereElement whereElement = new SqlWhereElement();
                if (columnCondition.isAnd) {
                    whereElement.setLogical_AND();
                } else {
                    whereElement.setLogical_OR();
                }
                whereElement.setFormula(tmpStr);
                wherecClauseSql.addWhereElement(whereElement);
            }
        } else if (SqlUtil.isBoolean(columnCondition.sqlTypeId)) {
            Boolean bool = BcBooleanUtil.parseBoolean(columnCondition.value, true);
            if (bool != null) {
                SqlWhereElement whereElement = new SqlWhereElement();
                whereElement.setLogical_AND();
                if (columnCondition.sqlTypeId == -7) {
                    whereElement.setFormula(sqlContext.toCondition_number("=", BcBooleanUtil.toShort(bool)));
                } else {
                    whereElement.setFormula(sqlContext.toCondition_boolean(columnCondition.tableColumnName, bool, true));
                }
                wherecClauseSql.addWhereElement(whereElement);
            }
        } else if (columnCondition.sqlTypeId == 91 || columnCondition.sqlTypeId == 93) {
            List<String> valueList = BcCsvUtil.parseCsvRow(columnCondition.value, true);
            Calendar calendar1 = BcTimeUtil.toCalendar(valueList.get(0));
            Calendar calendar2 = BcTimeUtil.toCalendar(valueList.get(1));
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (columnCondition.sqlTypeId == 91) {
                whereElement.setFormula(sqlContext.toCondition_period_date(columnCondition.tableColumnName, calendar1, calendar2));
            } else {
                whereElement.setFormula(sqlContext.toCondition_period_datetime(columnCondition.tableColumnName, calendar1, calendar2));
            }
            wherecClauseSql.addWhereElement(whereElement);
        } else {
            BcLogUtil.debug("Not suppoted JDBC Type. " + columnCondition.sqlTypeId + ":" + SqlUtil.toJdbcType(columnCondition.sqlTypeId));
        }
    }
}

