/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.swg;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.lib.doc.util.DcfConstants;
import ext.lib.pdf.PdfConstants;
import ext.lib.tree.BcTreeNode;
import ext.libx.swg.docviewer.DcfDocumentViewer;
import ext.module.dcmn.swg.DcmnReportPropertyPanel;
import ext.scf.client.ScfAbstractClientModule;
import ext.scf4.model.ScfMenuContext;
import ext.scf5.stub.ZScfDomainPropertyStub;
import ext.scf5.swg.IswgSharePropertyPanel;
import java.io.File;
import java.util.Properties;

public class DcmnClientModule
extends ScfAbstractClientModule {
    protected File tempDir;
    public boolean docSaveEnabled;
    protected Properties replaceProps;

    public static DcmnClientModule getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void start() throws Exception {
        AfbApplication application = AfbApplication.getInstance();
        ScfMenuContext menuContext = new ScfMenuContext();
        menuContext.setMenuName("\u30ec\u30dd\u30fc\u30c8\u30fb\u5370\u5237(1)");
        menuContext.setJavaClassName(DcmnReportPropertyPanel.class.getName());
        IswgSharePropertyPanel.rootTreeNode.add(new BcTreeNode(menuContext));
        this.tempDir = new File(AfbApplication.getInstance().toReal("${APP}temp/"));
        this.docSaveEnabled = true;
    }

    public Properties getReplaceProperties() throws Exception {
        if (this.replaceProps == null) {
            this.replaceProps = new Properties();
            String value = ZScfDomainPropertyStub.getInstance().getDomainProperty(1400110);
            if (!BcStringUtil.isEmpty(value)) {
                this.replaceProps.setProperty(DcfConstants.DEGN_signatureSectionName, value);
            }
            if (!BcStringUtil.isEmpty(value = ZScfDomainPropertyStub.getInstance().getDomainProperty(1400120))) {
                this.replaceProps.setProperty(DcfConstants.DEGN_signaturePersonName, value);
            }
        }
        return this.replaceProps;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void documentManagerCommonSetup(DcfDocumentViewer documentViewer, String title) throws Exception {
        documentViewer.setTempolaryDirectry(DcmnClientModule.getInstance().getTempDir());
        documentViewer.setTitle(title);
        String filePath = String.valueOf(AfbApplication.getInstance().toReal("${APP}export/")) + title + "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + PdfConstants.EXTENTION_dot_pdf;
        documentViewer.setOutputPdfFile(new File(filePath));
    }

    private static final class SingletonHolder {
        private static final DcmnClientModule instance = new DcmnClientModule();

        private SingletonHolder() {
        }
    }
}

