/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.task;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLoggableObject;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskEvent;
import ext.lib.task.TskTaskMonitor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TskTaskManager
extends BcLoggableObject
implements BcEventHandler<TskTaskEvent> {
    private static Map<String, TskCallableUnit> observableMap = new ConcurrentHashMap<String, TskCallableUnit>();
    private TskTaskMonitor taskMonitor;

    private TskTaskManager() {
    }

    public static TskTaskManager getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, TskCallableUnit> getMap() {
        return observableMap;
    }

    public void addCallableUnit(TskCallableUnit callableUnit) throws Exception {
        observableMap.put(callableUnit.getId(), callableUnit);
        if (this.taskMonitor != null) {
            this.taskMonitor.addCallableUnit(callableUnit);
        }
        if (callableUnit.future == null) {
            callableUnit.future = callableUnit.executorService.submit(callableUnit.callable);
            callableUnit.executorService.shutdown();
        }
    }

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        this.getLogger().debug("handle:event=" + event);
        if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            TskAbstractCallable callable = (TskAbstractCallable)event.getSource();
            TskCallableUnit callableUnit = observableMap.remove(callable.hashCode());
            this.getLogger().debug("handle:event=" + event);
        }
    }

    public TskTaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public void setTaskMonitor(TskTaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    /* synthetic */ TskTaskManager(TskTaskManager tskTaskManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final TskTaskManager instance = new TskTaskManager(null);

        private SingletonHolder() {
        }
    }
}

