/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.log.BcLogUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Stack;

public final class BcGenericUtil {
    private BcGenericUtil() {
    }

    public static <T> Class<T> getGenericType(Class<?> clazz, Class<?> targetClass, String targetTypeName) {
        if (!targetClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("\u578b" + clazz.getName() + "\u306f\u3001\u578b" + targetClass.getName() + "\u3092\u7d99\u627f\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        Stack stack = new Stack();
        BcLogUtil.debug("clazz=" + clazz.getName());
        BcLogUtil.debug("targetClass=" + targetClass.getName());
        BcLogUtil.debug("bool1=" + targetClass.equals(clazz.getSuperclass()));
        BcLogUtil.debug("bool2=" + (targetClass == clazz.getSuperclass()));
        while (!targetClass.equals(clazz.getSuperclass())) {
            stack.push(clazz);
            clazz = clazz.getSuperclass();
            BcLogUtil.debug("#getGenericType: #2clazz=" + clazz);
        }
        return BcGenericUtil.getGenericTypeImpl(clazz, targetTypeName, stack);
    }

    private static <T> Class<T> getGenericTypeImpl(Class<?> clazz, String targetTypeName, Stack<Class<?>> stack) {
        TypeVariable<Class<?>>[] superGenTypeAray = clazz.getSuperclass().getTypeParameters();
        int index = 0;
        boolean existFlag = false;
        TypeVariable<Class<?>>[] typeVariableArray = superGenTypeAray;
        int n = superGenTypeAray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariable<Class<?>> type = typeVariableArray[n2];
            if (targetTypeName.equals(type.getName())) {
                existFlag = true;
                break;
            }
            ++index;
            ++n2;
        }
        if (!existFlag) {
            throw new IllegalArgumentException(String.valueOf(targetTypeName) + "\u306b\u5408\u81f4\u3059\u308b\u30b8\u30a7\u30cd\u30ea\u30af\u30b9\u578b\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u307f\u3064\u304b\u308a\u307e\u305b\u3093");
        }
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        Type type = parameterizedType.getActualTypeArguments()[index];
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Class<?> sub = stack.pop();
            return BcGenericUtil.getGenericTypeImpl(sub, tv.getName(), stack);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        throw new IllegalArgumentException("\u4e88\u671f\u305b\u306c\u578b : " + type.toString() + " (" + type.getClass() + ")");
    }
}

