/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class ExtendedKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.ExtendedKeyUsage";
    public static final String NAME = "ExtendedKeyUsage";
    public static final String USAGES = "usages";
    private Vector<ObjectIdentifier> keyUsages;

    private void encodeThis() throws IOException {
        if (this.keyUsages == null || this.keyUsages.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.keyUsages.size(); ++i) {
            derOutputStream2.putOID(this.keyUsages.elementAt(i));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public ExtendedKeyUsageExtension(Vector<ObjectIdentifier> vector) throws IOException {
        this(Boolean.FALSE, vector);
    }

    public ExtendedKeyUsageExtension(Boolean bl, Vector<ObjectIdentifier> vector) throws IOException {
        this.keyUsages = vector;
        this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
        this.critical = bl;
        this.encodeThis();
    }

    public ExtendedKeyUsageExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for ExtendedKeyUsageExtension.");
        }
        this.keyUsages = new Vector();
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            ObjectIdentifier objectIdentifier = derValue2.getOID();
            this.keyUsages.addElement(objectIdentifier);
        }
    }

    @Override
    public String toString() {
        if (this.keyUsages == null) {
            return "";
        }
        String string = "  ";
        boolean bl = true;
        for (ObjectIdentifier objectIdentifier : this.keyUsages) {
            String string2;
            KnownOIDs knownOIDs;
            if (!bl) {
                string = string + "\n  ";
            }
            string = (knownOIDs = KnownOIDs.findMatch(string2 = objectIdentifier.toString())) != null ? string + knownOIDs.stdName() : string + string2;
            bl = false;
        }
        return super.toString() + "ExtendedKeyUsages [\n" + string + "\n]\n";
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(USAGES)) {
            if (!(object instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:ExtendedKeyUsageExtension.");
        }
        this.keyUsages = (Vector)object;
        this.encodeThis();
    }

    @Override
    public Vector<ObjectIdentifier> get(String string) throws IOException {
        if (string.equalsIgnoreCase(USAGES)) {
            return this.keyUsages;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:ExtendedKeyUsageExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(USAGES)) {
            throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:ExtendedKeyUsageExtension.");
        }
        this.keyUsages = null;
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(USAGES);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<String> getExtendedKeyUsage() {
        ArrayList<String> arrayList = new ArrayList<String>(this.keyUsages.size());
        for (ObjectIdentifier objectIdentifier : this.keyUsages) {
            arrayList.add(objectIdentifier.toString());
        }
        return arrayList;
    }
}

