/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.dao;

import ext.base.core.BcNumberUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xsod.model.XsodSalesDetail;
import java.util.List;

public class XsodSalesDetailDAO
extends OrmAbstractDAO<XsodSalesDetail> {
    public static final int MODE_default = 1;

    private XsodSalesDetailDAO() {
        super(new XsodSalesDetail[0]);
        this.setTableName("xsod_sales_detail");
    }

    public static XsodSalesDetailDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, int mode, String alias, int sessionId, short[] statuses) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (sessionId > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "session_id = " + sessionId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcNumberUtil.isEmpty(statuses)) {
            String condition = sqlContext.numberToCommaEnumeration(statuses).toString();
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "status IN (" + condition + ")");
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "order_date_time");
        }
        return selectQuery;
    }

    public List<XsodSalesDetail> getList(DtsSession dtsSession, int sessionId, short ... statuses) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "od";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, 1, alias, sessionId, statuses);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    /* synthetic */ XsodSalesDetailDAO(XsodSalesDetailDAO xsodSalesDetailDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodSalesDetailDAO instance = new XsodSalesDetailDAO(null);

        private SingletonHolder() {
        }
    }
}

