/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.pdf.object;

import ext.lib.pdf.PdfUtil;
import ext.lib.pdf.object.PdfObject;
import ext.lib.pdf.object.PdfPage;

public class PdfOutlineEntry
extends PdfObject {
    private static final long serialVersionUID = -9192976820272544079L;
    protected PdfOutlineEntry parent;
    protected PdfOutlineEntry prev;
    protected PdfOutlineEntry next;
    protected PdfOutlineEntry first;
    protected PdfOutlineEntry last;
    protected PdfPage page;
    protected int xPos = 0;
    protected int yPos = 0;
    protected boolean isOpened;
    protected String title = "";

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXPos(int xPos) {
        this.xPos = xPos;
    }

    public void setYPos(int yPos) {
        this.yPos = yPos;
    }

    public void setIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    public void setPage(PdfPage page) {
        this.page = page;
    }

    public void setFirst(PdfOutlineEntry entry) {
        this.first = entry;
    }

    public void setLast(PdfOutlineEntry entry) {
        this.last = entry;
    }

    public void setNext(PdfOutlineEntry entry) {
        this.next = entry;
    }

    public void setPrev(PdfOutlineEntry entry) {
        this.prev = entry;
    }

    public void setParent(PdfOutlineEntry entry) {
        this.parent = entry;
    }

    public PdfOutlineEntry getFirst() {
        return this.first;
    }

    public PdfOutlineEntry getLast() {
        return this.last;
    }

    public PdfOutlineEntry getNext() {
        return this.next;
    }

    public PdfOutlineEntry getPrev() {
        return this.prev;
    }

    @Override
    protected byte[] getObjectDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("<<\r\n");
        if (this.parent == null) {
            sb.append("/Type /Outlines\r\n");
        } else {
            sb.append("/Parent " + this.parent.getObjectId() + " 0 R\r\n");
            sb.append("/Title <" + PdfUtil.toUnicodeName(this.title) + ">\r\n");
            if (this.prev != null) {
                sb.append("/Prev " + this.prev.getObjectId() + " 0 R\r\n");
            }
            if (this.next != null) {
                sb.append("/Next " + this.next.getObjectId() + " 0 R\r\n");
            }
            sb.append("/Dest [" + new Integer(this.page.getObjectId()).toString() + " 0 R /XYZ " + Integer.toString(this.xPos) + " " + Integer.toString(this.yPos) + " 0 ]\r\n");
        }
        int kidsCount = this.getVisibleKidsCount();
        if (kidsCount != 0) {
            sb.append("/Count " + Integer.toString(kidsCount) + "\r\n");
        }
        if (this.first != null) {
            sb.append("/First " + this.first.getObjectId() + " 0 R\r\n");
        }
        if (this.last != null) {
            sb.append("/Last " + this.last.getObjectId() + " 0 R\r\n");
        }
        sb.append(">>\r\n");
        return sb.toString().getBytes();
    }

    protected int getVisibleKidsCount() {
        int i = 0;
        if (this.first != null) {
            PdfOutlineEntry tmpEntry = this.first;
            while (true) {
                ++i;
                int tmpKidsCount = tmpEntry.getVisibleKidsCount();
                i = tmpKidsCount >= 0 ? (i += tmpKidsCount) : (i -= tmpKidsCount);
                if (tmpEntry == this.last) break;
                tmpEntry = tmpEntry.getNext();
            }
        }
        if (this.isOpened) {
            return i;
        }
        return -i;
    }
}

