/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource.util;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcTableColumn;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcRegexUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.sql.SqlUtil;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ScfMmdServerUtil {
    private ScfMmdServerUtil() {
    }

    public static void setMmdField(ResultSetMetaData rsmd, int columnIndex, MmdField mmdField) throws Exception {
        mmdField.tableName = rsmd.getTableName(columnIndex);
        mmdField.columnName = rsmd.getColumnName(columnIndex);
        mmdField.tableColumnName = MmdUtil.createTableColumnName(mmdField.tableName, mmdField.columnName);
        mmdField.sqlTypeId = rsmd.getColumnType(columnIndex);
        mmdField.dataSize = rsmd.getPrecision(columnIndex);
        mmdField.dataClass = SqlUtil.toJavaType(mmdField.sqlTypeId);
        if (Number.class.isAssignableFrom(mmdField.dataClass) && !BcNumberUtil.isFloatingaPointClass(mmdField.dataClass)) {
            MmdUtil.setDecimalPosition(mmdField, rsmd.getScale(columnIndex));
        }
        if (mmdField.horizonalAlignment <= 0) {
            mmdField.horizonalAlignment = MmdUtil.getHorizonalAlignment(mmdField.dataClass);
        }
        switch (mmdField.sqlTypeId) {
            case 91: {
                mmdField.formatPattern = "yyyy/MM/dd";
                mmdField.columnCount = mmdField.formatPattern.length();
                break;
            }
            case 92: {
                mmdField.formatPattern = "HH:mm:ss";
                mmdField.columnCount = mmdField.formatPattern.length();
                break;
            }
            case 93: {
                mmdField.formatPattern = "yyyy/MM/dd HH:mm:ss.SSS";
                mmdField.columnCount = mmdField.formatPattern.length();
            }
        }
    }

    public static void setMmdDisplayName(MmdField mmdField, DtsWordManager wordManager, Locale locale) throws Exception {
        mmdField.formatPatternWork = mmdField.formatPattern;
        if (!BcStringUtil.isEmpty(mmdField.wordCode)) {
            mmdField.displayName = ScfMmdServerUtil.getWord(wordManager, mmdField.wordCode, locale);
            if (!BcStringUtil.isEmpty(mmdField.displayName)) {
                return;
            }
        }
        if (!BcStringUtil.isEmpty(mmdField.tableColumnName)) {
            mmdField.displayName = ScfMmdServerUtil.getWord(wordManager, mmdField.tableColumnName, locale);
            if (!BcStringUtil.isEmpty(mmdField.displayName)) {
                return;
            }
        }
        mmdField.displayName = MmdUtil.getProvisionalHeaderValue(mmdField);
    }

    public static String getWord(DtsWordManager wordManager, String wordCode, Locale locale) throws Exception {
        if (BcStringUtil.isEmpty(wordCode)) {
            return null;
        }
        String wordValue = wordManager.getWord(wordCode = wordCode.toLowerCase(), locale.getLanguage());
        if (!BcStringUtil.isEmpty(wordValue)) {
            return wordValue;
        }
        ArrayList<String> wordList = new ArrayList<String>();
        String[] elemnts = BcStringUtil.split(wordCode, BcRegexUtil.escapEncode(BcStringUtil.DOT_STR));
        int i = 0;
        while (i < elemnts.length) {
            String elemnt = elemnts[i];
            if (i > 0) {
                wordList.add(BcStringUtil.DOT_STR);
            }
            if (BcStringUtil.isEmpty(wordValue = wordManager.getWord(elemnt, locale.getLanguage()))) {
                wordList.add(elemnt);
            } else {
                wordList.add(wordValue);
            }
            ++i;
        }
        return BcStringUtil.marge(wordList).toString();
    }

    public static List<MmdField> createMmdFieldList(ResultSetMetaData rsmd, List<String> columnNameList, Map<String, MmdField> mmdFieldMap, DtsWordManager wordManager, Locale locale) throws Exception {
        String asteriskTable = null;
        if (columnNameList != null && columnNameList.size() == 1) {
            String tmpStr = columnNameList.get(0);
            if ((tmpStr = tmpStr.trim()).endsWith(".*")) {
                asteriskTable = tmpStr.substring(0, tmpStr.length() - 2);
                asteriskTable = asteriskTable.toLowerCase();
            }
        }
        ArrayList<MmdField> mmdFieldList = new ArrayList<MmdField>();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            String tableColumnName2;
            int columnIndex = i + 1;
            MmdField mmdFieldWk = new MmdField();
            ScfMmdServerUtil.setMmdField(rsmd, columnIndex, mmdFieldWk);
            if (BcStringUtil.isEmpty(asteriskTable) && columnNameList != null && columnNameList.size() == rsmd.getColumnCount() && !BcStringUtil.isEmpty(tableColumnName2 = BcCollectionUtil.getElement(columnNameList, i))) {
                tableColumnName2 = SqlUtil.choiceAlias(tableColumnName2);
                mmdFieldWk.tableColumnName = tableColumnName2 = tableColumnName2.toLowerCase(locale);
            }
            MmdField mmdField2 = null;
            if (mmdFieldMap != null) {
                mmdField2 = mmdFieldMap.get(mmdFieldWk.tableColumnName.toLowerCase());
            }
            if (mmdField2 != null) {
                mmdFieldWk.displayClass = mmdField2.displayClass;
                mmdFieldWk.shift = mmdField2.shift;
                mmdFieldWk.decimalDigit = mmdField2.decimalDigit;
                mmdFieldWk.formatPattern = mmdField2.formatPatternWork;
                mmdFieldWk.formatPatternWork = mmdField2.formatPatternWork;
                if (mmdField2.columnCount > 0) {
                    mmdFieldWk.columnCount = mmdField2.columnCount;
                }
                mmdFieldWk.valueMap = mmdField2.valueMap;
                mmdFieldWk.horizonalAlignment = mmdField2.horizonalAlignment;
                mmdFieldWk.datasourceConverterClassName = mmdField2.datasourceConverterClassName;
                mmdFieldWk.renderingConverterClassName = mmdField2.renderingConverterClassName;
            }
            if (BcStringUtil.isEmpty(mmdFieldWk.displayName) && wordManager != null) {
                ScfMmdServerUtil.setMmdDisplayName(mmdFieldWk, wordManager, locale);
            }
            mmdFieldList.add(mmdFieldWk);
            ++i;
        }
        return mmdFieldList;
    }

    public static List<BcTableColumn> createTableColumnList(ResultSetMetaData rsmd, List<String> columnNameList, Map<String, MmdField> mmdFieldMap, DtsWordManager wordManager, Locale locale) throws Exception {
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rsmd, columnNameList, mmdFieldMap, wordManager, locale);
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            BcTableColumn tableColumn = new BcTableColumn();
            tableColumn.setMmdField(mmdField);
            tableColumnList.add(tableColumn);
            ++i;
        }
        return tableColumnList;
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, List<String> columnNameList, Locale locale) throws Exception {
        return ScfMmdServerUtil.createTableColumnList(rsmd, columnNameList, dtsSession.getSessionFactory().mmdFieldMap, dtsSession.getSessionFactory().wordManager, locale);
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, List<String> columnNameList) throws Exception {
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, columnNameList, dtsSession.getLocale());
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd) throws Exception {
        List<String> columnNameList = ScfMmdServerUtil.createTableColumnNameList(rsmd);
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, columnNameList, dtsSession.getLocale());
    }

    public static List<BcTableColumn> createTableColumnList(ResultSetMetaData rsmd) throws Exception {
        List<String> columnNameList = ScfMmdServerUtil.createTableColumnNameList(rsmd);
        return ScfMmdServerUtil.createTableColumnList(rsmd, columnNameList, null, null, null);
    }

    public static List<String> createTableColumnNameList(ResultSetMetaData rsmd) throws Exception {
        ArrayList<String> tableColumnNameList = new ArrayList<String>();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int idx = i + 1;
            String tableColumnName = MmdUtil.createTableColumnName(rsmd.getTableName(idx), rsmd.getColumnName(idx));
            tableColumnNameList.add(tableColumnName);
            ++i;
        }
        return tableColumnNameList;
    }

    public static MmdField addMmd(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int shift, int decimalPosition, int columnCount, String displayValue, Map cellValueMap, int horizonalAlignment, Map<String, MmdField> mmdFieldMap, DtsWordManager wordManager, Locale locale) throws Exception {
        MmdField mmdField = MmdUtil.createMmdField(tableColumnName, displayJavaClassType, formatPatternWork, shift, decimalPosition, columnCount, cellValueMap, horizonalAlignment);
        String tableColumnName2 = tableColumnName.toLowerCase();
        mmdFieldMap.put(tableColumnName2, mmdField);
        wordManager.putWord(tableColumnName2, locale.getLanguage(), displayValue);
        return mmdField;
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int shift, int decimalPosition, int columnCount, String displayValue, Map cellValueMap, int horizonalAlignment) throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
        Map<String, MmdField> mmdFieldMap = dtsSessionFactory.mmdFieldMap;
        DtsWordManager wordManager = dtsSessionFactory.wordManager;
        MmdField mmdField = ScfMmdServerUtil.addMmd(tableColumnName, displayJavaClassType, formatPatternWork, shift, decimalPosition, columnCount, displayValue, cellValueMap, horizonalAlignment, mmdFieldMap, wordManager, Locale.getDefault());
        return mmdField;
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int shift, int decimalPosition, int columnCount, String displayValue, Map cellValueMap) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, shift, decimalPosition, columnCount, displayValue, cellValueMap, -1);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        int decimalPosition = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, 0, decimalPosition, columnCount, displayValue, null, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int columnCount, String displayValue) throws Exception {
        int decimalPosition = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, 0, decimalPosition, columnCount, displayValue, null);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, String formatPatternWork, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, null, formatPatternWork, columnCount, displayValue, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, String formatPatternWork, String displayValue, int horizonalAlignment) throws Exception {
        Class displayJavaClassType = null;
        int columnCount = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, columnCount, displayValue, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, int shift, int decimalPosition, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, null, shift, decimalPosition, columnCount, displayValue, null);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, int columnCount, String displayValue, Map cellValueMap, int horizonalAlignment) throws Exception {
        int decimalPosition = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, null, 0, decimalPosition, columnCount, displayValue, cellValueMap, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue, Map cellValueMap, int horizonalAlignment) throws Exception {
        int decimalPosition = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, null, null, 0, decimalPosition, columnCount, displayValue, cellValueMap, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue, Map cellValueMap) throws Exception {
        int horizonalAlignment = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, columnCount, displayValue, cellValueMap, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        int decimalPosition = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, null, 0, decimalPosition, columnCount, displayValue, null, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, "", columnCount, displayValue, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, columnCount, displayValue, -1);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int shift, int decimalPosition, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, Number.class, shift, decimalPosition, columnCount, displayValue);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int decimalPosition, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, 0, decimalPosition, columnCount, displayValue);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, -1, displayValue);
    }

    public static List<String> createTableColumnNameList(ResultSetMetaData rsmd, String subTableName) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            String tableColumnName;
            int colIdx = i + 1;
            if (BcStringUtil.isEmpty(subTableName)) {
                tableColumnName = MmdUtil.createTableColumnName(rsmd.getTableName(colIdx), rsmd.getColumnName(colIdx));
                columnNameList.add(tableColumnName);
            } else {
                tableColumnName = MmdUtil.createTableColumnName(subTableName, rsmd.getColumnName(colIdx));
                columnNameList.add(tableColumnName);
            }
            ++i;
        }
        return columnNameList;
    }
}

