/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.Model;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionListDeParser;

public class InsertDeParser
extends AbstractDeParser<Insert>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public InsertDeParser() {
        super(new StringBuilder());
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Insert insert) {
        Expression expression;
        Column column;
        Iterator<Model> iter;
        if (insert.getWithItemsList() != null && !insert.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            iter = insert.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(this.selectVisitor);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.buffer.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append("INTO ");
        this.buffer.append(insert.getTable().toString());
        if (insert.getColumns() != null) {
            this.buffer.append(" (");
            iter = insert.getColumns().iterator();
            while (iter.hasNext()) {
                column = (Column)iter.next();
                this.buffer.append(column.getColumnName());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        if (insert.getOutputClause() != null) {
            this.buffer.append(insert.getOutputClause().toString());
        }
        if (insert.getSelect() != null) {
            this.buffer.append(" ");
            if (insert.getSelect().isUsingWithBrackets()) {
                this.buffer.append("(");
            }
            if (insert.getSelect().getWithItemsList() != null) {
                this.buffer.append("WITH ");
                for (WithItem with : insert.getSelect().getWithItemsList()) {
                    with.accept(this.selectVisitor);
                }
                this.buffer.append(" ");
            }
            SelectBody selectBody = insert.getSelect().getSelectBody();
            selectBody.accept(this.selectVisitor);
            if (insert.getSelect().isUsingWithBrackets()) {
                this.buffer.append(")");
            }
        }
        if (insert.isUseSet()) {
            this.buffer.append(" SET ");
            for (int i = 0; i < insert.getSetColumns().size(); ++i) {
                column = insert.getSetColumns().get(i);
                column.accept(this.expressionVisitor);
                this.buffer.append(" = ");
                expression = insert.getSetExpressionList().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= insert.getSetColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (insert.isUseDuplicate()) {
            this.buffer.append(" ON DUPLICATE KEY UPDATE ");
            for (int i = 0; i < insert.getDuplicateUpdateColumns().size(); ++i) {
                column = insert.getDuplicateUpdateColumns().get(i);
                this.buffer.append(column.getFullyQualifiedName()).append(" = ");
                expression = insert.getDuplicateUpdateExpressionList().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= insert.getDuplicateUpdateColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (insert.getConflictAction() != null) {
            this.buffer.append(" ON CONFLICT");
            if (insert.getConflictTarget() != null) {
                insert.getConflictTarget().appendTo(this.buffer);
            }
            insert.getConflictAction().appendTo(this.buffer);
        }
        if (insert.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ").append(PlainSelect.getStringList(insert.getReturningExpressionList(), true, false));
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
    }

    @Override
    public void visit(NamedExpressionList NamedExpressionList2) {
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        List<ExpressionList> expressionLists = multiExprList.getExpressionLists();
        int n = expressionLists.size() - 1;
        int i = 0;
        for (ExpressionList expressionList : expressionLists) {
            new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
            if (i < n) {
                this.buffer.append(", ");
            }
            ++i;
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }
}

