/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Digest;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509DigestResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509DigestResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            try {
                X509Data x509Data = new X509Data(element, string);
                return x509Data.containsDigest();
            }
            catch (XMLSecurityException xMLSecurityException) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver, bl);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        try {
            return this.resolveCertificate(element, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        return null;
    }

    private X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver) throws XMLSecurityException {
        XMLX509Digest[] xMLX509DigestArray = null;
        Element[] elementArray = XMLUtils.selectDs11Nodes(element.getFirstChild(), "X509Digest");
        if (elementArray == null || elementArray.length <= 0) {
            return null;
        }
        try {
            this.checkStorage(storageResolver);
            xMLX509DigestArray = new XMLX509Digest[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509DigestArray[i] = new XMLX509Digest(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                for (XMLX509Digest xMLX509Digest : xMLX509DigestArray) {
                    byte[] byArray = XMLX509Digest.getDigestBytesFromCert(x509Certificate, xMLX509Digest.getAlgorithm());
                    if (!Arrays.equals(xMLX509Digest.getDigestBytes(), byArray)) continue;
                    LOG.debug("Found certificate with: {}", x509Certificate.getSubjectX500Principal().getName());
                    return x509Certificate;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException(xMLSecurityException);
        }
        return null;
    }

    private void checkStorage(StorageResolver storageResolver) throws KeyResolverException {
        if (storageResolver == null) {
            Object[] objectArray = new Object[]{"X509Digest"};
            KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
            LOG.debug("", keyResolverException);
            throw keyResolverException;
        }
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }
}

