/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Loggers;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="loggers", category="Core")
public final class LoggersPlugin {
    private LoggersPlugin() {
    }

    @PluginFactory
    public static Loggers createLoggers(@PluginElement(value="Loggers") LoggerConfig[] loggers) {
        ConcurrentHashMap<String, LoggerConfig> loggerMap = new ConcurrentHashMap<String, LoggerConfig>();
        LoggerConfig root = null;
        LoggerConfig[] loggerConfigArray = loggers;
        int n = loggers.length;
        int n2 = 0;
        while (n2 < n) {
            LoggerConfig logger = loggerConfigArray[n2];
            if (logger != null) {
                if (logger.getName().isEmpty()) {
                    if (root != null) {
                        throw new IllegalStateException("Configuration has multiple root loggers. There can be only one.");
                    }
                    root = logger;
                }
                loggerMap.put(logger.getName(), logger);
            }
            ++n2;
        }
        return new Loggers(loggerMap, root);
    }
}

