/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.swg;

import ext.base.core.BcNumberUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.lib.awt.AwtImageHelper;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.lib.task.Z_TskTaskScheduler;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf5.swg.IswgTableControlPanel2;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;

public class IswgTableControlPanel3
extends IswgTableControlPanel2 {
    private static final long serialVersionUID = 658776206191835926L;
    private RmiRequest rmiReq;
    private ScfTableLoadTask tableLoadTask;
    protected SwgTextField rowCountField = new SwgTextField();
    protected SwgLabel elapsedTimeLabel = new SwgLabel();
    public SwgButton refreshButton;
    public SwgButton cancelButton;

    public IswgTableControlPanel3() throws Exception {
        this.rowCountField.setEditable(false);
        this.rowCountField.setHorizontalAlignment(4);
        this.rowCountField.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 14));
        this.addControl1(this.rowCountField);
        this.elapsedTimeLabel.setHorizontalAlignment(4);
        this.elapsedTimeLabel.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 8));
        this.addControl1(this.elapsedTimeLabel);
    }

    @Override
    public void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        super.tableLoadStarted(tableLoadTask);
        this.tableLoadTask = tableLoadTask;
        this.cancelButton.setEnabled(true);
    }

    @Override
    public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
        super.tableColumnReceived(tableLoadTask, tableColumnList, rowSize, tableContext);
        this.elapsedTimeLabel.setText(String.valueOf(BcNumberUtil.toString(tableContext.elapsedTime)) + "(ms)");
    }

    @Override
    public void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowSize, int loadedRowSize) throws Exception {
        super.loadedRowSizeChanged(tableLoadTask, rowSize, loadedRowSize);
        if (rowSize >= 0) {
            this.rowCountField.setText(String.valueOf(BcNumberUtil.toString(loadedRowSize)) + "/" + BcNumberUtil.toString(rowSize));
        } else {
            this.rowCountField.setText(String.valueOf(BcNumberUtil.toString(loadedRowSize)) + " \u4ef6");
        }
    }

    @Override
    public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
        this.setControlEnabled2(eod);
        if (eod) {
            this.cancelButton.setEnabled(false);
        }
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.refreshButton) {
            this.refreshButtonAction();
        } else if (ev.getSource() == this.cancelButton) {
            this.cancelButtonAction();
        }
    }

    @Override
    public void setControlEnabled2(boolean enabled) throws Exception {
        super.setControlEnabled2(enabled);
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(enabled);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enabled);
        }
    }

    public void setRefreshButton() throws Exception {
        this.refreshButton = new SwgButton();
        this.refreshButton.addActionListener(this.actionListener);
        this.refreshButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("refresh_64x64.png")));
        this.refreshButton.setPreferredSize(this.buttonSize);
        this.refreshButton.setToolTipText("\u6700\u65b0\u306e\u60c5\u5831\u306b\u66f4\u65b0\u3057\u307e\u3059\u3002");
        this.refreshButton.setEnabled(false);
        this.addControl2(this.refreshButton);
    }

    protected void refreshButtonAction() throws Exception {
        this.tableLoadTask.init();
        this.tableLoadTask.setRequest(this.rmiReq);
        Z_TskTaskScheduler.getInstance().startTask(this.tableLoadTask);
    }

    public void setCancelButton() throws Exception {
        this.cancelButton = new SwgButton();
        this.cancelButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("sign_forbidden_64x64.png")));
        this.cancelButton.addActionListener(this.actionListener);
        this.cancelButton.setPreferredSize(this.buttonSize);
        this.cancelButton.setEnabled(false);
        this.addControl2(this.cancelButton);
    }

    protected void cancelButtonAction() throws Exception {
        this.tableLoadTask.cancel(this);
    }

    public void setOriginalRequest(RmiRequest rmiReq) {
        this.rmiReq = rmiReq;
    }

    public RmiRequest getOriginalRequest() throws Exception {
        return this.rmiReq;
    }
}

