/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcStringUtil;
import ext.base.event.BcEvent;
import ext.base.event.BcEventManager;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcObjectNotFoundException;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.stub.XdtsCustomSqlStub;
import ext.module.xsys.validation.XwebValidator;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsCustomSqlPane
extends FxDecoratePane {
    FxFlowPane topPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    FxTextArea sqlTextArea = new FxTextArea();
    XdtsCustomSql customSql1;
    public XdtsCustomSql customSql2;
    Button saveButton;
    Button cancelButton;
    Stage stage;

    public XdtsCustomSqlPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.saveButton = FxUtil.createSaveButton(BcWords.getInstance().save, null);
        this.saveButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.saveButton);
        this.cancelButton = FxUtil.createCancelButton(BcWords.getInstance().cancel, null);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.cancelButton);
        this.nameTextField.setPrefColumnCount(160);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().sqlName), new Node[]{this.nameTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.groupTextField.setPrefColumnCount(160);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(160);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefHeight(84.0);
        this.setTop((Node)this.topPane);
        this.setCenter((Node)this.sqlTextArea);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setCustomQuery(XdtsCustomSql customSql1) throws Exception {
        this.customSql1 = customSql1;
        this.nameTextField.setText(customSql1.name);
        this.groupTextField.setText(customSql1.group);
        this.noteTextField.setText(customSql1.note);
        this.sqlTextArea.setText(customSql1.sql);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.saveButton) {
            if (this.customSql1 == null) {
                this.customSql1 = new XdtsCustomSql();
            }
            this.customSql1.name = this.nameTextField.getText();
            this.customSql1.group = this.groupTextField.getText();
            this.customSql1.note = this.noteTextField.getText();
            this.customSql1.sql = this.sqlTextArea.getText();
            XwebValidator validator = XwebValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.customSql1);
            if (result1.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                return;
            }
            this.customSql2 = XdtsCustomSqlStub.getInstance().putCustomSql(this.customSql1);
            BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).fireEvent(new BcEvent(this.customSql2));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.customSql1.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsCustomSqlPane.this.nameTextField.requestFocus();
                }
                catch (Exception ex) {
                    XdtsCustomSqlPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsCustomSqlPane.this.close();
                }
                catch (Exception ex) {
                    XdtsCustomSqlPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(1240.0);
        this.stage.setHeight(800.0);
        this.stage.setResizable(true);
        String title = String.valueOf(SqlWords.getInstance().sql) + " : ";
        title = this.customSql1.getDataId() <= 0 ? String.valueOf(title) + BcWords.getInstance().new_ : String.valueOf(title) + BcStringUtil.toNotNull(this.customSql1.name);
        this.stage.setTitle(title);
        Image image = FxImageHelper.getImage("sql_48x48.png");
        this.stage.getIcons().add((Object)image);
        this.stage.show();
    }

    public static void show2(int profileId, int customSqlId) throws Exception {
        XdtsCustomSqlPane customSqlPane = null;
        if (customSqlId > 0) {
            customSqlPane = (XdtsCustomSqlPane)((Object)BcInstanceManager.getInstance().get(XdtsCustomSqlPane.class, customSqlId));
        }
        if (customSqlPane != null) {
            customSqlPane.stage.toFront();
            return;
        }
        customSqlPane = new XdtsCustomSqlPane();
        XdtsCustomSql customSql = null;
        if (customSqlId <= 0) {
            customSql = new XdtsCustomSql();
            customSql.profileId = profileId;
        } else {
            customSql = XdtsCustomSqlStub.getInstance().getCustomSql(customSqlId);
            if (customSql == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(customSql.getDataId(), (Object)customSqlPane);
        }
        customSqlPane.setCustomQuery(customSql);
        customSqlPane.show(null);
    }

    public static void show3(long profileId, String sql) throws Exception {
        XdtsCustomSqlPane customSqlPane = new XdtsCustomSqlPane();
        XdtsCustomSql customSql = new XdtsCustomSql();
        customSql.profileId = (int)profileId;
        customSql.sql = sql;
        customSqlPane.setCustomQuery(customSql);
        customSqlPane.show(null);
    }
}

