/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx.viewer;

import ext.base.log.BcLogUtil;
import ext.base.util.BcExceptionUtil;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.libx.fx.FxxAbstractDesktopPane;
import ext.libx.fx.viewer.FxxContent;
import ext.libx.fx.viewer.FxxContentGroup;
import ext.libx.fx.viewer.FxxContentNode;
import ext.libx.fx.viewer.FxxMultiTouchViewPane;
import ext.libx.fx.viewer.FxxNavigatePane;
import ext.libx.fx.viewer.FxxUrlEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FxxViwerDesktopPane
extends FxxAbstractDesktopPane {
    protected SplitPane splitPane1 = new SplitPane();
    protected FxTabPane tabPane1 = new FxTabPane();
    protected FxxNavigatePane navigatePane = new FxxNavigatePane();
    protected SplitPane splitPane2 = new SplitPane();
    protected FxBorderPane borderPane1 = new FxBorderPane();
    protected FxxMultiTouchViewPane multiTouchViewPane = new FxxMultiTouchViewPane();
    protected EventHandler<? super FxxUrlEvent> eventHandler;
    protected Stage stage;

    public FxxViwerDesktopPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.splitPane1.setOrientation(Orientation.HORIZONTAL);
        this.splitPane1.getItems().addAll((Object[])new Node[]{this.tabPane1, this.splitPane2});
        this.setCenter((Node)this.splitPane1);
        this.splitPane2.setOrientation(Orientation.VERTICAL);
        this.splitPane2.getItems().addAll((Object[])new Node[]{this.borderPane1});
        this.borderPane1.setCenter((Node)this.multiTouchViewPane);
        Tab tab = new Tab();
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent((Node)this.navigatePane);
        this.tabPane1.getTabs().add((Object)tab);
        this.tabPane1.getSelectionModel().select((Object)tab);
        this.navigatePane.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            try {
                FxxContent fxxContent = (FxxContent)ev.value;
                this.multiTouchViewPane.clear();
                double scale = 1.0;
                FxxContentNode contentNode = fxxContent.getNode(scale);
                this.multiTouchViewPane.addContentNode(contentNode);
            }
            catch (Exception ex) {
                BcExceptionUtil.getExceptionHandler().handleException(ex, (Object)this);
            }
        }));
        FxUtil.defaultInitialize((Node)this);
    }

    public void setContentGroup(FxxContentGroup contentGroup) throws Exception {
        this.navigatePane.setContents(contentGroup);
    }

    public void clear() throws Exception {
        this.multiTouchViewPane.clear();
    }

    public void setEventHandler(EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }

    public boolean show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.init();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    double ratio = 200.0 / FxxViwerDesktopPane.this.stage.getWidth();
                    FxxViwerDesktopPane.this.splitPane1.setDividerPositions(new double[]{ratio});
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
        return false;
    }
}

