/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdField;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.sql.context.SqlContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DtsSessionFactory
extends BcLoggableObject
implements AutoCloseable {
    private DtsConnectionManager connectionManager;
    private List<DtsSession> sessionList;
    private String name;
    public DtsWordManager wordManager = new DtsWordManagerImpl();
    public Map<String, MmdField> mmdFieldMap = new HashMap<String, MmdField>();

    public DtsSessionFactory(String name, DtsConnectionManager connectionManager) {
        this.name = name;
        this.connectionManager = connectionManager;
        this.sessionList = new ArrayList<DtsSession>();
    }

    public String getName() {
        return this.name;
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public List<DtsSession> getSessionList() {
        return this.sessionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtsSession createSession(Object owner) throws Exception {
        DtsSession dtsSession = new DtsSession(this);
        dtsSession.setLogger(this.getLogger());
        dtsSession.owner = owner;
        if (this.connectionManager != null) {
            dtsSession.setConnectionManager(this.connectionManager);
            SqlContext sqlContext = this.connectionManager.getSqlContext(null);
            dtsSession.setSqlContext(sqlContext);
        }
        List<DtsSession> list = this.sessionList;
        synchronized (list) {
            this.sessionList.add(dtsSession);
        }
        return dtsSession;
    }

    @Override
    public void close() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.closeAllConnection();
            this.connectionManager = null;
        }
        if (this.sessionList != null) {
            this.sessionList.clear();
            this.sessionList = null;
        }
    }
}

