/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Address;
import java.util.List;

public class Wbs1AddressDAO
extends OrmAbstractDAO<Wbs1Address> {
    public static final int MODE_default = 1;

    private Wbs1AddressDAO() {
        super(new Wbs1Address[0]);
        this.setTableName("wbs1_address");
    }

    public static Wbs1AddressDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, int mode, String alias, long personId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (personId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + personId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public List<Wbs1Address> getList(DtsSession dtsSession, int mode, long personId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, mode, alias, personId);
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public Wbs1Address getByPersonId(DtsSession dtsSession, long personId) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        List<Wbs1Address> entityList = this.getList(dtsSession, 1, personId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1AddressDAO(Wbs1AddressDAO wbs1AddressDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1AddressDAO instance = new Wbs1AddressDAO(null);

        private SingletonHolder() {
        }
    }
}

