/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationSetup;
import ext.appfw.common.AfbLogUtil;
import ext.appfw.common.AfbShutdownManager;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcArgumentUtil;
import ext.base.xml.BcXmlUtil;
import ext.scf.rmi.server.RmiServerModule;
import ext.scf.server.ScfServerContainer;
import ext.scf.server.ScfServerShutdownTask;
import ext.scf.util.ScfSetupUtil;
import java.io.File;
import org.w3c.dom.Document;

public class ScfServerSetup
extends BcLoggableObject
implements AfbApplicationSetup {
    @Override
    public void setup(AfbApplication application) throws Exception {
        String serverCofigPath;
        File file;
        this.getLogger().info(AfbLogUtil.serverModeLog(application));
        String vFilePath = BcArgumentUtil.getArgumentValue(application.getMainArguments(), "-svcfg");
        if (BcStringUtil.isEmpty(vFilePath)) {
            vFilePath = "${APP}config/server.xml";
        }
        if ((file = new File(serverCofigPath = application.toReal(vFilePath))).exists()) {
            Document dom = BcXmlUtil.createDocument(file);
            ScfServerContainer serverContainer = ScfServerContainer.getInstance();
            serverContainer.setConfig(dom);
        }
        this.setupCommon(application);
    }

    public void setupCommon(AfbApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        RmiServerModule rmiServerModule = serverContainer.rmiServerModule;
        rmiServerModule.setInitNo(1);
        rmiServerModule.setStartNo(1);
        rmiServerModule.setEndNo(Integer.MAX_VALUE);
        serverContainer.addModule(rmiServerModule);
        ScfSetupUtil.loadModule(serverContainer, application.getBootConfig(), "serverModule");
        serverContainer.initModule();
        ScfServerShutdownTask serverShutdownTask = new ScfServerShutdownTask();
        AfbShutdownManager.getInstance().addShutdownTask(serverShutdownTask);
    }

    @Override
    public void start(AfbApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        serverContainer.start();
        this.getLogger().info("All server modules started.");
    }
}

