/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DomainLoadStoreParameter;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import sun.security.provider.PolicyParser;
import sun.security.util.PolicyUtil;

abstract class DomainKeyStore
extends KeyStoreSpi {
    private static final String ENTRY_NAME_SEPARATOR = "entrynameseparator";
    private static final String KEYSTORE_PROVIDER_NAME = "keystoreprovidername";
    private static final String KEYSTORE_TYPE = "keystoretype";
    private static final String KEYSTORE_URI = "keystoreuri";
    private static final String KEYSTORE_PASSWORD_ENV = "keystorepasswordenv";
    private static final String REGEX_META = ".$|()[{^?*+\\";
    private static final String DEFAULT_STREAM_PREFIX = "iostream";
    private int streamCounter = 1;
    private String entryNameSeparator = " ";
    private String entryNameSeparatorRegEx = " ";
    private static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    private final Map<String, KeyStore> keystores = new HashMap<String, KeyStore>();

    DomainKeyStore() {
    }

    abstract String convertAlias(String var1);

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        Key key = null;
        try {
            KeyStore keyStore;
            String string2 = simpleEntry.getKey();
            Iterator<KeyStore> iterator = simpleEntry.getValue().iterator();
            while (iterator.hasNext() && (key = (keyStore = iterator.next()).getKey(string2, cArray)) == null) {
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        Certificate[] certificateArray = null;
        try {
            KeyStore keyStore;
            String string2 = simpleEntry.getKey();
            Iterator<KeyStore> iterator = simpleEntry.getValue().iterator();
            while (iterator.hasNext() && (certificateArray = (keyStore = iterator.next()).getCertificateChain(string2)) == null) {
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return certificateArray;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        Certificate certificate = null;
        try {
            KeyStore keyStore;
            String string2 = simpleEntry.getKey();
            Iterator<KeyStore> iterator = simpleEntry.getValue().iterator();
            while (iterator.hasNext() && (certificate = (keyStore = iterator.next()).getCertificate(string2)) == null) {
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return certificate;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        Date date = null;
        try {
            KeyStore keyStore;
            String string2 = simpleEntry.getKey();
            Iterator<KeyStore> iterator = simpleEntry.getValue().iterator();
            while (iterator.hasNext() && (date = (keyStore = iterator.next()).getCreationDate(string2)) == null) {
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return date;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> simpleEntry = this.getKeystoreForWriting(string);
        if (simpleEntry == null) {
            throw new KeyStoreException("Error setting key entry for '" + string + "'");
        }
        String string2 = simpleEntry.getKey();
        Map.Entry entry = simpleEntry.getValue();
        ((KeyStore)entry.getValue()).setKeyEntry(string2, key, cArray, certificateArray);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> simpleEntry = this.getKeystoreForWriting(string);
        if (simpleEntry == null) {
            throw new KeyStoreException("Error setting protected key entry for '" + string + "'");
        }
        String string2 = simpleEntry.getKey();
        Map.Entry entry = simpleEntry.getValue();
        ((KeyStore)entry.getValue()).setKeyEntry(string2, byArray, certificateArray);
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> simpleEntry = this.getKeystoreForWriting(string);
        if (simpleEntry == null) {
            throw new KeyStoreException("Error setting certificate entry for '" + string + "'");
        }
        String string2 = simpleEntry.getKey();
        Map.Entry entry = simpleEntry.getValue();
        ((KeyStore)entry.getValue()).setCertificateEntry(string2, certificate);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> simpleEntry = this.getKeystoreForWriting(string);
        if (simpleEntry == null) {
            throw new KeyStoreException("Error deleting entry for '" + string + "'");
        }
        String string2 = simpleEntry.getKey();
        Map.Entry entry = simpleEntry.getValue();
        ((KeyStore)entry.getValue()).deleteEntry(string2);
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<Map.Entry<String, KeyStore>> iterator = this.keystores.entrySet().iterator();
        return new Enumeration<String>(){
            private int index = 0;
            private Map.Entry<String, KeyStore> keystoresEntry = null;
            private String prefix = null;
            private Enumeration<String> aliases = null;

            @Override
            public boolean hasMoreElements() {
                try {
                    if (this.aliases == null) {
                        if (iterator.hasNext()) {
                            this.keystoresEntry = (Map.Entry)iterator.next();
                            this.prefix = this.keystoresEntry.getKey() + DomainKeyStore.this.entryNameSeparator;
                            this.aliases = this.keystoresEntry.getValue().aliases();
                        } else {
                            return false;
                        }
                    }
                    if (this.aliases.hasMoreElements()) {
                        return true;
                    }
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    this.keystoresEntry = (Map.Entry)iterator.next();
                    this.prefix = this.keystoresEntry.getKey() + DomainKeyStore.this.entryNameSeparator;
                    this.aliases = this.keystoresEntry.getValue().aliases();
                }
                catch (KeyStoreException keyStoreException) {
                    return false;
                }
                return this.aliases.hasMoreElements();
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    return this.prefix + this.aliases.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        try {
            String string2 = simpleEntry.getKey();
            for (KeyStore keyStore : simpleEntry.getValue()) {
                if (!keyStore.containsAlias(string2)) continue;
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return false;
    }

    @Override
    public int engineSize() {
        int n = 0;
        try {
            for (KeyStore keyStore : this.keystores.values()) {
                n += keyStore.size();
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return n;
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        try {
            String string2 = simpleEntry.getKey();
            for (KeyStore keyStore : simpleEntry.getValue()) {
                if (!keyStore.isKeyEntry(string2)) continue;
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> simpleEntry = this.getKeystoresForReading(string);
        try {
            String string2 = simpleEntry.getKey();
            for (KeyStore keyStore : simpleEntry.getValue()) {
                if (!keyStore.isCertificateEntry(string2)) continue;
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        return false;
    }

    private AbstractMap.SimpleEntry<String, Collection<KeyStore>> getKeystoresForReading(String string) {
        String[] stringArray = string.split(this.entryNameSeparatorRegEx, 2);
        if (stringArray.length == 2) {
            KeyStore keyStore = this.keystores.get(stringArray[0]);
            if (keyStore != null) {
                return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>(stringArray[1], Collections.singleton(keyStore));
            }
        } else if (stringArray.length == 1) {
            return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>(string, this.keystores.values());
        }
        return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>("", Collections.emptyList());
    }

    private AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> getKeystoreForWriting(String string) {
        KeyStore keyStore;
        String[] stringArray = string.split(this.entryNameSeparator, 2);
        if (stringArray.length == 2 && (keyStore = this.keystores.get(stringArray[0])) != null) {
            return new AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>>(stringArray[1], new AbstractMap.SimpleEntry<String, KeyStore>(stringArray[0], keyStore));
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        try {
            KeyStore keyStore;
            String string = null;
            Iterator<KeyStore> iterator = this.keystores.values().iterator();
            while (iterator.hasNext() && (string = (keyStore = iterator.next()).getCertificateAlias(certificate)) == null) {
            }
            return string;
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            if (this.keystores.size() == 1) {
                this.keystores.values().iterator().next().store(outputStream, cArray);
                return;
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException(keyStoreException);
        }
        throw new UnsupportedOperationException("This keystore must be stored using a DomainLoadStoreParameter");
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter instanceof DomainLoadStoreParameter) {
            DomainLoadStoreParameter domainLoadStoreParameter = (DomainLoadStoreParameter)loadStoreParameter;
            List<KeyStoreBuilderComponents> list = this.getBuilders(domainLoadStoreParameter.getConfiguration(), domainLoadStoreParameter.getProtectionParams());
            for (KeyStoreBuilderComponents keyStoreBuilderComponents : list) {
                try {
                    KeyStore.ProtectionParameter protectionParameter = keyStoreBuilderComponents.protection;
                    if (!(protectionParameter instanceof KeyStore.PasswordProtection)) {
                        throw new KeyStoreException(new IllegalArgumentException("ProtectionParameter must be a KeyStore.PasswordProtection"));
                    }
                    char[] cArray = ((KeyStore.PasswordProtection)keyStoreBuilderComponents.protection).getPassword();
                    KeyStore keyStore = this.keystores.get(keyStoreBuilderComponents.name);
                    FileOutputStream fileOutputStream = new FileOutputStream(keyStoreBuilderComponents.file);
                    Throwable throwable = null;
                    try {
                        keyStore.store(fileOutputStream, cArray);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileOutputStream.close();
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    throw new IOException(keyStoreException);
                }
            }
        } else {
            throw new UnsupportedOperationException("This keystore must be stored using a DomainLoadStoreParameter");
        }
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(inputStream, cArray);
            }
            catch (Exception exception) {
                if (!"JKS".equalsIgnoreCase(DEFAULT_KEYSTORE_TYPE)) {
                    keyStore = KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE);
                    keyStore.load(inputStream, cArray);
                }
                throw exception;
            }
            String string = DEFAULT_STREAM_PREFIX + this.streamCounter++;
            this.keystores.put(string, keyStore);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("This keystore must be loaded using a DomainLoadStoreParameter");
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter instanceof DomainLoadStoreParameter) {
            DomainLoadStoreParameter domainLoadStoreParameter = (DomainLoadStoreParameter)loadStoreParameter;
            List<KeyStoreBuilderComponents> list = this.getBuilders(domainLoadStoreParameter.getConfiguration(), domainLoadStoreParameter.getProtectionParams());
            for (KeyStoreBuilderComponents keyStoreBuilderComponents : list) {
                try {
                    if (keyStoreBuilderComponents.file != null) {
                        this.keystores.put(keyStoreBuilderComponents.name, KeyStore.Builder.newInstance(keyStoreBuilderComponents.type, keyStoreBuilderComponents.provider, keyStoreBuilderComponents.file, keyStoreBuilderComponents.protection).getKeyStore());
                        continue;
                    }
                    this.keystores.put(keyStoreBuilderComponents.name, KeyStore.Builder.newInstance(keyStoreBuilderComponents.type, keyStoreBuilderComponents.provider, keyStoreBuilderComponents.protection).getKeyStore());
                }
                catch (KeyStoreException keyStoreException) {
                    throw new IOException(keyStoreException);
                }
            }
        } else {
            throw new UnsupportedOperationException("This keystore must be loaded using a DomainLoadStoreParameter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<KeyStoreBuilderComponents> getBuilders(URI uRI, Map<String, KeyStore.ProtectionParameter> map) throws IOException {
        PolicyParser policyParser = new PolicyParser(true);
        Collection<PolicyParser.DomainEntry> collection = null;
        ArrayList<KeyStoreBuilderComponents> arrayList = new ArrayList<KeyStoreBuilderComponents>();
        String string = uRI.getFragment();
        try {
            Throwable throwable = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(PolicyUtil.getInputStream(uRI.toURL()), "UTF-8");){
                policyParser.read(inputStreamReader);
                collection = policyParser.getDomainEntries();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException);
        }
        catch (PolicyParser.ParsingException parsingException) {
            throw new IOException(parsingException);
        }
        for (PolicyParser.DomainEntry domainEntry : collection) {
            Map<String, String> map2 = domainEntry.getProperties();
            if (string != null && !string.equalsIgnoreCase(domainEntry.getName())) continue;
            if (map2.containsKey(ENTRY_NAME_SEPARATOR)) {
                this.entryNameSeparator = map2.get(ENTRY_NAME_SEPARATOR);
                char c = '\u0000';
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.entryNameSeparator.length(); ++i) {
                    c = this.entryNameSeparator.charAt(i);
                    if (REGEX_META.indexOf(c) != -1) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
                this.entryNameSeparatorRegEx = stringBuilder.toString();
            }
            Collection<PolicyParser.KeyStoreEntry> collection2 = domainEntry.getEntries();
            for (PolicyParser.KeyStoreEntry keyStoreEntry : collection2) {
                Object object;
                Object object2;
                String string2 = keyStoreEntry.getName();
                HashMap<String, String> hashMap = new HashMap<String, String>(map2);
                hashMap.putAll(keyStoreEntry.getProperties());
                String string3 = DEFAULT_KEYSTORE_TYPE;
                if (hashMap.containsKey(KEYSTORE_TYPE)) {
                    string3 = (String)hashMap.get(KEYSTORE_TYPE);
                }
                Provider provider = null;
                if (hashMap.containsKey(KEYSTORE_PROVIDER_NAME) && (provider = Security.getProvider((String)(object2 = (String)hashMap.get(KEYSTORE_PROVIDER_NAME)))) == null) {
                    throw new IOException("Error locating JCE provider: " + (String)object2);
                }
                object2 = null;
                if (hashMap.containsKey(KEYSTORE_URI)) {
                    object = (String)hashMap.get(KEYSTORE_URI);
                    try {
                        object2 = ((String)object).startsWith("file://") ? new File(new URI((String)object)) : new File((String)object);
                    }
                    catch (IllegalArgumentException | URISyntaxException exception) {
                        throw new IOException("Error processing keystore property: keystoreURI=\"" + (String)object + "\"", exception);
                    }
                }
                object = null;
                if (map.containsKey(string2)) {
                    object = map.get(string2);
                } else if (hashMap.containsKey(KEYSTORE_PASSWORD_ENV)) {
                    String string4 = (String)hashMap.get(KEYSTORE_PASSWORD_ENV);
                    String string5 = System.getenv(string4);
                    if (string5 == null) throw new IOException("Error processing keystore property: keystorePasswordEnv=\"" + string4 + "\"");
                    object = new KeyStore.PasswordProtection(string5.toCharArray());
                } else {
                    object = new KeyStore.PasswordProtection(null);
                }
                arrayList.add(new KeyStoreBuilderComponents(string2, string3, provider, (File)object2, (KeyStore.ProtectionParameter)object));
            }
        }
        if (!arrayList.isEmpty()) return arrayList;
        throw new IOException("Error locating domain configuration data for: " + uRI);
    }

    public static final class DKS
    extends DomainKeyStore {
        @Override
        String convertAlias(String string) {
            return string.toLowerCase(Locale.ENGLISH);
        }
    }

    class KeyStoreBuilderComponents {
        String name;
        String type;
        Provider provider;
        File file;
        KeyStore.ProtectionParameter protection;

        KeyStoreBuilderComponents(String string, String string2, Provider provider, File file, KeyStore.ProtectionParameter protectionParameter) {
            this.name = string;
            this.type = string2;
            this.provider = provider;
            this.file = file;
            this.protection = protectionParameter;
        }
    }
}

