/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.util.Arrays;

public class JMSDequeueOptions {
    public static final int DEQUEUE_WAIT_FOREVER = 4;
    private DequeueMode attrDeqMode = DequeueMode.REMOVE;
    private VisibilityOption attrVisibility = VisibilityOption.IMMEDIATE;
    private StreamingMode attrStreamMode;
    private int attrWait = 4;
    private DeliveryFilter attrDeliveryMode = DeliveryFilter.PERSISTENT;
    private String consumerName = null;
    private String correlation = null;
    private boolean retrieveMessageId = false;
    private String condition;
    private byte[] deqMessageId = null;
    private int streamingFlag = 0;
    private int shardNum = -1;

    public JMSDequeueOptions() {
        this.attrStreamMode = StreamingMode.DEQ_STREAMING_FLAG_DISABLED;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public void setShardNum(int shardNum) {
        this.shardNum = shardNum;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(String correlation) {
        this.correlation = correlation;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean isRetrieveMessageId() {
        return this.retrieveMessageId;
    }

    public void setRetrieveMessageId(boolean retrieveMessageId) {
        this.retrieveMessageId = retrieveMessageId;
    }

    public byte[] getDequeueMessageId() {
        return this.deqMessageId;
    }

    public void setDequeueMessageId(byte[] deqMessageId) {
        this.deqMessageId = deqMessageId;
    }

    public DeliveryFilter getDeliveryMode() {
        return this.attrDeliveryMode;
    }

    public void setDeliveryMode(DeliveryFilter attrDeliveryMode) {
        this.attrDeliveryMode = attrDeliveryMode;
    }

    public DequeueMode getDequeueMode() {
        return this.attrDeqMode;
    }

    public void setDequeueMode(DequeueMode attrDeqMode) {
        this.attrDeqMode = attrDeqMode;
    }

    public VisibilityOption getVisibility() {
        return this.attrVisibility;
    }

    public void setVisibility(VisibilityOption attrVisibility) {
        this.attrVisibility = attrVisibility;
    }

    public int getWait() {
        return this.attrWait;
    }

    public void setWait(int attrWait) {
        this.attrWait = attrWait;
    }

    public StreamingMode getStreamingMode() {
        return this.attrStreamMode;
    }

    public void setStreamingMode(StreamingMode _attrStreamingMode) {
        this.attrStreamMode = _attrStreamingMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JMSDequeueOptions {");
        sb.append("attrDeqMode=" + (Object)((Object)this.attrDeqMode) + ", ");
        sb.append("attrVisibility=" + (Object)((Object)this.attrVisibility) + ", ");
        sb.append("attrStreamMode=" + (Object)((Object)this.attrStreamMode) + ", ");
        sb.append("attrWait=" + this.attrWait + ", ");
        sb.append("attrDeliveryMode=" + (Object)((Object)this.attrDeliveryMode) + ", ");
        sb.append("consumerName=" + this.consumerName + ", ");
        sb.append("correlation=" + this.correlation + ", ");
        sb.append("retrieveMessageId=" + this.retrieveMessageId + ", ");
        sb.append("condition=" + this.condition + ", ");
        sb.append("deqMessageId=" + Arrays.toString(this.deqMessageId) + ", ");
        sb.append("streamingFlag=" + this.streamingFlag + "}");
        return sb.toString();
    }

    public static enum DeliveryFilter {
        PERSISTENT(0),
        BUFFERED(128),
        PERSISTENT_OR_BUFFERED(256);

        private final int mode;

        private DeliveryFilter(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum DequeueMode {
        BROWSE(8),
        LOCKED(16),
        REMOVE(32),
        REMOVE_NODATA(64);

        private final int mode;

        private DequeueMode(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum StreamingMode {
        DEQ_STREAMING_FLAG_GET_LOB_LOCATOR(2),
        DEQ_STREAMING_FLAG_DISABLED(0);

        private final int mode;

        private StreamingMode(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum VisibilityOption {
        ON_COMMIT(1),
        IMMEDIATE(2);

        private final int mode;

        private VisibilityOption(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }
}

