/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.panel.CacheSettingsDialog;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.NetworkSettingsDialog;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AboutDialog;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.FancyButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class GeneralPanel
extends JPanel
implements SecurityProperties.JavaEnableListener {
    private JLabel javaEnabledStatus;
    JButton cacheViewBtn;

    public GeneralPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(new Insets(15, 15, 0, 15)));
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        JLabel jLabel = new JLabel(this.getMessage("general.about.border"));
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createVerticalStrut(10));
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("general.about.text"));
        jSmartTextArea.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.setAlignmentX(0.0f);
        JButton jButton = new JButton(this.getMessage("general.about.btn"));
        jButton.setMnemonic(ResourceManager.getMnemonic("general.about.btn"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPanel.this.aboutBtnActionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText(this.getMessage("general.about.btn.tooltip"));
        jPanel.add(jButton);
        box.add(jSmartTextArea);
        box.add(jPanel);
        JLabel jLabel2 = new JLabel(this.getMessage("general.network.border.text"));
        jLabel2.setAlignmentX(0.0f);
        box.add(jLabel2);
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton2 = this.makeButton("general.network.settings.text");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPanel.this.networkSettingsBtnActionPerformed(actionEvent);
            }
        });
        jButton2.setToolTipText(this.getMessage("network.settings.btn.tooltip"));
        jPanel2.add(jButton2);
        JSmartTextArea jSmartTextArea2 = new JSmartTextArea(this.getMessage("general.network.desc.text"));
        jSmartTextArea2.setAlignmentX(0.0f);
        box.add(jSmartTextArea2);
        box.add(jPanel2);
        JLabel jLabel3 = new JLabel(this.getMessage("general.cache.border.text"));
        jLabel3.setAlignmentX(0.0f);
        box.add(jLabel3);
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setLayout(new FlowLayout(2));
        this.cacheViewBtn = this.makeButton("general.cache.view.text");
        this.cacheViewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPanel.this.viewBtnAction();
            }
        });
        JButton jButton3 = this.makeButton("general.cache.settings.text");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPanel.this.tempFilesSettingsBtnActionPerformed(actionEvent);
            }
        });
        jButton3.setToolTipText(this.getMessage("temp.files.settings.btn.tooltip"));
        JButton[] jButtonArray = new JButton[]{this.cacheViewBtn, jButton3};
        DialogTemplate.resizeButtons(jButtonArray);
        JSmartTextArea jSmartTextArea3 = new JSmartTextArea(this.getMessage("general.cache.desc.text"));
        jSmartTextArea3.setAlignmentX(0.0f);
        jPanel3.add(jButton3);
        jPanel3.add(this.cacheViewBtn);
        box.add(jSmartTextArea3);
        box.add(jPanel3);
        if (OSType.isWin()) {
            box.add(this.createJavaEnabledPanel());
        }
        this.add((Component)box, "North");
    }

    private JComponent createJavaEnabledPanel() {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        String string = SecurityProperties.isJavaInBrowserEnabled() ? "deployment.general.java.enabled" : "deployment.general.java.disabled";
        this.javaEnabledStatus = new JLabel(ResourceManager.getMessage(string));
        this.javaEnabledStatus.setAlignmentX(0.0f);
        FancyButton fancyButton = new FancyButton(ResourceManager.getMessage("deployment.general.security.link"), ResourceManager.getMnemonic("deployment.general.security.link"), Color.BLUE);
        fancyButton.setAlignmentX(0.0f);
        fancyButton.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        fancyButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.showPanel("security");
            }
        });
        box.add(this.javaEnabledStatus);
        box.add(fancyButton);
        return box;
    }

    private void aboutBtnActionPerformed(ActionEvent actionEvent) {
        new AboutDialog((JFrame)this.getTopLevelAncestor(), true).setVisible(true);
    }

    void viewBtnAction() {
        String string = Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "javaws.jar";
        URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = new URL("file", null, -1, string);
            Thread thread = Thread.currentThread();
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, thread.getContextClassLoader());
            thread.setContextClassLoader(uRLClassLoader);
            Class<?> clazz = uRLClassLoader.loadClass("com.sun.javaws.ui.CacheViewer");
            JFrame jFrame = (JFrame)this.getTopLevelAncestor();
            Class[] classArray = new Class[]{new JFrame().getClass()};
            Method method = clazz.getMethod("showCacheViewer", classArray);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchMethodException("com.sun.javaws.ui.CacheViewer.showCacheViewer");
            }
            method.setAccessible(true);
            Object[] objectArray = new Object[]{jFrame};
            method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    private void tempFilesSettingsBtnActionPerformed(ActionEvent actionEvent) {
        CacheSettingsDialog cacheSettingsDialog = new CacheSettingsDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        cacheSettingsDialog.pack();
        cacheSettingsDialog.setLocationRelativeTo(this);
        cacheSettingsDialog.setVisible(true);
    }

    private void networkSettingsBtnActionPerformed(ActionEvent actionEvent) {
        NetworkSettingsDialog networkSettingsDialog = new NetworkSettingsDialog((JFrame)this.getTopLevelAncestor(), true);
        networkSettingsDialog.pack();
        networkSettingsDialog.setLocationRelativeTo(this);
        networkSettingsDialog.setVisible(true);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getMnemonic(string));
        return jButton;
    }

    void enableViewButton(boolean bl) {
        if (!bl) {
            this.cacheViewBtn.setToolTipText(this.getMessage("general.cache.view.tooltip.unapplied"));
            this.cacheViewBtn.setEnabled(false);
        } else if (!Config.getBooleanProperty("deployment.cache.enabled")) {
            this.cacheViewBtn.setToolTipText(this.getMessage("general.cache.view.tooltip.disabled"));
            this.cacheViewBtn.setEnabled(false);
        } else {
            this.cacheViewBtn.setToolTipText(this.getMessage("general.cache.view.tooltip"));
            this.cacheViewBtn.setEnabled(true);
        }
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        if (this.javaEnabledStatus != null) {
            String string = javaEnableEvent.isEnabled() ? "deployment.general.java.enabled" : "deployment.general.java.disabled";
            this.javaEnabledStatus.setText(ResourceManager.getMessage(string));
            this.javaEnabledStatus.invalidate();
        }
    }
}

