/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.Key;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.util.ConstraintsParameters;

public class CertPathConstraintsParameters
implements ConstraintsParameters {
    private final Key key;
    private final TrustAnchor anchor;
    private final Date date;
    private final String variant;
    private final X509Certificate cert;

    public CertPathConstraintsParameters(X509Certificate x509Certificate, String string, TrustAnchor trustAnchor, Date date) {
        this(x509Certificate.getPublicKey(), string, trustAnchor, date, x509Certificate);
    }

    public CertPathConstraintsParameters(Key key, String string, TrustAnchor trustAnchor) {
        this(key, string, trustAnchor, null, null);
    }

    private CertPathConstraintsParameters(Key key, String string, TrustAnchor trustAnchor, Date date, X509Certificate x509Certificate) {
        this.key = key;
        this.variant = string == null ? "generic" : string;
        this.anchor = trustAnchor;
        this.date = date;
        this.cert = x509Certificate;
    }

    @Override
    public boolean anchorIsJdkCA() {
        return CertPathHelper.isJdkCA(this.anchor);
    }

    @Override
    public Set<Key> getKeys() {
        return this.key == null ? Collections.singleton(null) : Collections.singleton(this.key);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public String extendedExceptionMsg() {
        return this.cert == null ? "." : " used with certificate: " + this.cert.getSubjectX500Principal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[\n");
        stringBuilder.append("  Variant: ").append(this.variant);
        if (this.anchor != null) {
            stringBuilder.append("\n  Anchor: ").append(this.anchor);
        }
        if (this.cert != null) {
            stringBuilder.append("\n  Cert Issuer: ").append(this.cert.getIssuerX500Principal());
            stringBuilder.append("\n  Cert Subject: ").append(this.cert.getSubjectX500Principal());
        }
        if (this.key != null) {
            stringBuilder.append("\n  Key: ").append(this.key.getAlgorithm());
        }
        if (this.date != null) {
            stringBuilder.append("\n  Date: ").append(this.date);
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }
}

