/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.rmo;

import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.model.SqlSelectQuery;
import ext.module.impt.dao.ImptImportContextDAO;
import ext.module.impt.model.ImptImportContext;
import ext.scf3.rmo.ScfSqlUtil;
import java.util.Calendar;

public class ImptImportContextRMO
extends RmiAbstractRMO {
    public void deleteImportContext(RmiRmoArgument rmoArg) throws Exception {
        int importContextId = rmoArg.getRequest().getDataAsNumber().intValue();
        int cnt = ImptImportContextDAO.getInstance().deleteImportContext(rmoArg.getDtsSession(this), importContextId);
        rmoArg.getRespons().addData(cnt);
    }

    public void getImportContext(RmiRmoArgument rmoArg) throws Exception {
        int importId = rmoArg.getRequest().getDataAsNumber().intValue();
        ImptImportContext importContext = ImptImportContextDAO.getInstance().getImportContext(rmoArg.getDtsSession(this), importId);
        rmoArg.getRespons().addData(importContext);
    }

    public void getImportContextNewest(RmiRmoArgument rmoArg) throws Exception {
        ImptImportContext importContext = ImptImportContextDAO.getInstance().getImportContextNewest(rmoArg.getDtsSession(this));
        rmoArg.getRespons().addData(importContext);
    }

    public void getImportContextByLastModified(RmiRmoArgument rmoArg) throws Exception {
        Calendar lastModified = rmoArg.getRequest().getDataAsCalendar();
        long length = rmoArg.getRequest().getDataAsLong();
        ImptImportContext importContext = ImptImportContextDAO.getInstance().getImportContextByLastModified(rmoArg.getDtsSession(this), lastModified);
        rmoArg.getRespons().addData(importContext);
    }

    public void importContextList(RmiRmoArgument rmoArg) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.addSelectColumn("impt_import_context.id");
        selectQuery.addSelectColumn("impt_import_context.source_url");
        selectQuery.addSelectColumn("impt_import_context.source_preserve_url");
        selectQuery.addSelectColumn("impt_import_context.file_last_modified");
        selectQuery.addSelectColumn("impt_import_context.file_size");
        selectQuery.addSelectColumn("impt_import_context.define_file_name");
        selectQuery.addSelectColumn("impt_import_context.start_time");
        selectQuery.addSelectColumn("impt_import_context.end_time");
        selectQuery.addSelectColumn("impt_import_context.process_mode_id");
        selectQuery.addSelectColumn("impt_import_context.start_data_no");
        selectQuery.addSelectColumn("impt_import_context.end_data_no");
        selectQuery.addSelectColumn("impt_import_context.complete_row");
        selectQuery.addSelectColumn("impt_import_context.user_id");
        selectQuery.addSelectColumn("impt_import_context.name");
        selectQuery.addSelectColumn("impt_import_context.note_");
        selectQuery.setFromClause("impt_import_context");
        selectQuery.getOrderByList().add("id");
        ScfSqlUtil.generalList(rmoArg, selectQuery);
    }
}

