/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.person.nameIidentification;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcResult;
import ext.libx.person.nameIidentification.PersonSimpleName;
import ext.libx.person.nameIidentification.PsnNameBirthday;
import ext.libx.person.nameIidentification.PsnNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevenshteinDistance;

public class PsnNameIdentification {
    protected LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
    protected JaroWinklerDistance jaroWinklerDistance = new JaroWinklerDistance();
    protected List<PersonSimpleName> simpleNameList;

    public void init(Collection<? extends PsnNameBirthday> nameBirthdayCollection) throws Exception {
        this.simpleNameList = new ArrayList<PersonSimpleName>();
        BcLogUtil.debug("\u7c21\u7d20\u540d\u30de\u30c3\u30d7\u3092\u4f5c\u6210\u4e2d...");
        int cnt = 0;
        for (PsnNameBirthday psnNameBirthday : nameBirthdayCollection) {
            if (++cnt % 1000 == 0) {
                BcLogUtil.debug("cnt=" + cnt);
            }
            if (BcStringUtil.isEmpty(psnNameBirthday.getName())) continue;
            PersonSimpleName personSimpleName = new PersonSimpleName();
            personSimpleName.simpleName = PsnNameUtil.toSimple(psnNameBirthday.getName()).toString();
            BcLogUtil.debug(String.valueOf(psnNameBirthday.getName()) + " -> " + personSimpleName.simpleName);
            if (BcStringUtil.isEmpty(personSimpleName.simpleName)) {
                BcLogUtil.debug("\u30b7\u30f3\u30d7\u30ebNULL=" + psnNameBirthday.getName());
                continue;
            }
            personSimpleName.nameBirthday = psnNameBirthday;
            this.simpleNameList.add(personSimpleName);
        }
    }

    public List<PsnNameBirthday> doSerch(String targetName, int birthday, Object personId, float enableSimilarRate) throws Exception {
        ArrayList<PsnNameBirthday> resultList = new ArrayList<PsnNameBirthday>();
        if (BcStringUtil.isEmpty(targetName)) {
            return resultList;
        }
        String targetSimpleName = PsnNameUtil.toSimple(targetName).toString();
        int i = 0;
        while (i < this.simpleNameList.size()) {
            PersonSimpleName personSimpleName = this.simpleNameList.get(i);
            BcResult result = this.compare(targetSimpleName, birthday, personSimpleName, personId, enableSimilarRate);
            if (((Boolean)result.getUserObject()).booleanValue()) {
                resultList.add(personSimpleName.nameBirthday);
            }
            ++i;
        }
        return resultList;
    }

    protected BcResult compare(String targetSimpleName, int birthday, PersonSimpleName personSimpleName, Object personId, float enableSimilarRate) throws Exception {
        BcResult result = new BcResult();
        result.setUserObject(false);
        PsnNameBirthday nameBirthday = personSimpleName.nameBirthday;
        if (personId != null && personId.equals(nameBirthday.getId())) {
            result.addInfo("\u540c\u4e00ID:personId=" + personId);
            return result;
        }
        personSimpleName.value = this.levenshteinDistance.getDistance(targetSimpleName, personSimpleName.simpleName);
        float similarRate = personSimpleName.value * 100.0f;
        if (birthday != nameBirthday.getBirthday()) {
            result.addInfo("\u751f\u5e74\u6708\u65e5\u9055\u3044");
            return result;
        }
        if (similarRate >= enableSimilarRate) {
            result.setUserObject(true);
        }
        return result;
    }

    public Map<Object, PsnNameBirthday> doSerch(Object personId, int birthday, float enableSimilarRate, String ... names) throws Exception {
        ArrayList<PsnNameBirthday> nameBirthdayList = new ArrayList<PsnNameBirthday>();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            List<PsnNameBirthday> nameBirthdayListTmp = this.doSerch(name, birthday, personId, enableSimilarRate);
            nameBirthdayList.addAll(nameBirthdayListTmp);
            ++i;
        }
        Map<Object, PsnNameBirthday> personIdMap = PsnNameUtil.toIdMap(nameBirthdayList);
        return personIdMap;
    }
}

