/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import ext.base.log.BcLogUtil;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Collection;

public class AwtUtil {
    public static final int DIDP_XGA_width = 1024;
    public static final int DIDP_XGA_height = 768;
    public static final int FWXGA_width = 1366;
    public static final int FWXGA_height = 768;
    public static final int FULL_HD_width = 1920;
    public static final int FULL_HD_height = 1080;
    public static final int cascadeX = 10;
    public static final int cascadeY = 24;
    public static final int botomMargin = 30;
    public static int taskBarHeight = 32;
    protected static final int ENABLED = 1;
    protected static final int DISABLED = 2;
    protected static int flag;

    private AwtUtil() {
    }

    public static Dimension maxDimension(Dimension dim1, Dimension dim2) {
        Dimension dim = new Dimension((int)Math.max(dim1.getWidth(), dim2.getWidth()), (int)Math.max(dim1.getHeight(), dim2.getHeight()));
        return dim;
    }

    public static void crearClip(Graphics g) throws Exception {
        g.setClip(0, 0, 100000, 100000);
    }

    public static Rectangle getWindowRectangleMax() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        return rectangle;
    }

    public static Rectangle calcCenterRectangle(Rectangle baseRectangle, int width, int height) {
        int x = (baseRectangle.width - width) / 2;
        int y = (baseRectangle.height - height) / 2;
        Rectangle rectangle = new Rectangle(x, y, width, height);
        return rectangle;
    }

    public static Dimension calcDimensionByRatio(double baseWidth, double baseHeight, double ratio) {
        Dimension dimension = new Dimension();
        dimension.width = (int)(baseWidth * ratio);
        dimension.height = (int)(baseHeight * ratio);
        return dimension;
    }

    public static Dimension calcDimensionByRatio(Dimension baseDimension, double ratio) {
        return AwtUtil.calcDimensionByRatio(baseDimension.width, baseDimension.height, ratio);
    }

    public static Dimension calcDimensionByRatio(Rectangle baseRectangle, double ratio) {
        return AwtUtil.calcDimensionByRatio(baseRectangle.width, baseRectangle.height, ratio);
    }

    public static Dimension calcDimensionByRatio(double ratio) {
        Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
        return AwtUtil.calcDimensionByRatio(windowRectangleMax, ratio);
    }

    public static Rectangle calcCascadeRectangle(int baseX, int baseY, int targetWidth, int targetHeight, int maxWidth, int maxHeight) {
        int x = baseX + 10;
        int y = baseY + 24;
        int width = targetWidth;
        int height = targetHeight;
        if (x + width > maxWidth) {
            width = maxWidth - x;
        }
        if (y + height > maxHeight) {
            height = maxHeight - y;
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        return rectangle;
    }

    public static Rectangle calcCascadeRectangle(int baseX, int baseY, int targetWidth, int targetHeight) {
        Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
        return AwtUtil.calcCascadeRectangle(baseX, baseY, targetWidth, targetHeight, windowRectangleMax.width, windowRectangleMax.height);
    }

    public static void closeResource(Container container) throws Exception {
        if (container == null) {
            return;
        }
        container.removeAll();
    }

    public static Dimension get_DIDP_XGA() {
        Dimension dimension = new Dimension(1024, 768);
        return dimension;
    }

    public static Dimension get_FWXGA() {
        Dimension dimension = new Dimension(1366, 768);
        return dimension;
    }

    public static Dimension get_FULL_HD() {
        Dimension dimension = new Dimension(1920, 1080);
        return dimension;
    }

    public static boolean isSmallerThanXGA() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bool = false;
        if (dimension.width <= 1024) {
            bool = true;
        }
        if (dimension.height <= 768) {
            bool = true;
        }
        return bool;
    }

    public static boolean isGuiEnabled() {
        if (flag == 1) {
            return true;
        }
        if (flag == 2) {
            return false;
        }
        try {
            Frame frame = new Frame();
            frame.dispose();
            flag = 1;
            return true;
        }
        catch (Exception ex) {
            flag = 2;
            return false;
        }
    }

    public static void openFile(File file) throws Exception {
        BcLogUtil.debug("openFile:file=" + file.getPath());
        Desktop.getDesktop().open(file);
    }

    public static void openFile(Collection<File> fileCollection) throws Exception {
        for (File file : fileCollection) {
            AwtUtil.openFile(file);
        }
    }
}

