/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODScrollButton;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class NimRODScrollBarUI
extends MetalScrollBarUI {
    private boolean clicked;
    private boolean rollOver;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODScrollBarUI();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MiML(this);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new NimRODScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new NimRODScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Color colB;
        Color colA;
        Color thumbColor = UIManager.getColor("ScrollBar.thumb");
        Color thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(thumbColor);
        g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 1);
        g.setColor(this.rollOver ? thumbShadow.darker() : thumbShadow);
        g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 1);
        Icon icDecor = null;
        icDecor = this.scrollbar.getOrientation() == 0 ? UIManager.getIcon("ScrollBar.horizontalThumbIconImage") : UIManager.getIcon("ScrollBar.verticalThumbIconImage");
        int w = icDecor.getIconWidth();
        int h = icDecor.getIconHeight();
        int x = (thumbBounds.width - w) / 2;
        int y = (thumbBounds.height - h) / 2;
        if (this.scrollbar.getOrientation() == 0 && thumbBounds.width >= w || this.scrollbar.getOrientation() == 1 && thumbBounds.height >= h) {
            icDecor.paintIcon(c, g, x, y);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
        Graphics2D g2D = (Graphics2D)g;
        GradientPaint grad = null;
        if (this.clicked) {
            colA = NimRODUtils.getSombra();
            colB = NimRODUtils.getBrillo();
        } else {
            colA = NimRODUtils.getBrillo();
            colB = NimRODUtils.getSombra();
        }
        grad = this.scrollbar.getOrientation() == 0 ? new GradientPaint(thumbBounds.x, thumbBounds.y, colA, thumbBounds.x, thumbBounds.height, colB) : new GradientPaint(thumbBounds.x, thumbBounds.y, colA, thumbBounds.width, thumbBounds.y, colB);
        g2D.setPaint(grad);
        g2D.fill(thumbBounds);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2D = (Graphics2D)g;
        GradientPaint grad = null;
        grad = this.scrollbar.getOrientation() == 0 ? new GradientPaint(trackBounds.x, trackBounds.y, NimRODUtils.getSombra(), trackBounds.x, trackBounds.y + trackBounds.height, NimRODUtils.getBrillo()) : new GradientPaint(trackBounds.x, trackBounds.y, NimRODUtils.getSombra(), trackBounds.x + trackBounds.width, trackBounds.y, NimRODUtils.getBrillo());
        g2D.setPaint(grad);
        g2D.fill(trackBounds);
    }

    public class MiML
    extends BasicScrollBarUI.TrackListener {
        NimRODScrollBarUI papi;

        public MiML(NimRODScrollBarUI papi) {
            super(NimRODScrollBarUI.this);
            this.papi = papi;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            this.papi.rollOver = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            this.papi.rollOver = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.papi.clicked = true;
            NimRODScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.papi.clicked = false;
            NimRODScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            if (this.papi.rollOver && !NimRODScrollBarUI.this.thumbRect.contains(e.getX(), e.getY())) {
                NimRODScrollBarUI.this.rollOver = false;
                NimRODScrollBarUI.this.scrollbar.repaint();
            } else if (!this.papi.rollOver && NimRODScrollBarUI.this.thumbRect.contains(e.getX(), e.getY())) {
                this.papi.rollOver = true;
                NimRODScrollBarUI.this.scrollbar.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            if (this.papi.rollOver && !NimRODScrollBarUI.this.thumbRect.contains(e.getX(), e.getY())) {
                NimRODScrollBarUI.this.rollOver = false;
                NimRODScrollBarUI.this.scrollbar.repaint();
            } else if (!this.papi.rollOver && NimRODScrollBarUI.this.thumbRect.contains(e.getX(), e.getY())) {
                this.papi.rollOver = true;
                NimRODScrollBarUI.this.scrollbar.repaint();
            }
        }
    }
}

