/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;

public class FxButton
extends Button {
    protected boolean styleChangeFlag;

    public FxButton() {
        this.init();
    }

    public FxButton(String text) {
        super(text);
        this.init();
    }

    public FxButton(String text, Node graphic) {
        super(text, graphic);
        this.init();
    }

    protected void init() {
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    if (newValue.booleanValue()) {
                        FxButton.this.focusIn();
                    } else {
                        FxButton.this.focusOut();
                    }
                }
                catch (Exception ex) {
                    FxButton.this.handleException(ex);
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxButton.this.styleChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxButton.this.handleException(ex);
                }
            }
        });
    }

    public void focusIn() throws Exception {
    }

    public void focusOut() throws Exception {
    }

    public void styleChanged(String oldValue, String newValue) throws Exception {
        if (this.styleChangeFlag) {
            this.styleChangeFlag = false;
            return;
        }
        if (this.isDisabled()) {
            this.styleChangeFlag = true;
        }
        FxUtil.setPrefSize_ButtonBase((ButtonBase)this);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

