/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] evalues;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.evalues.length) {
            sb.append(this.evalues[i]);
            if (i + 1 < this.evalues.length) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public ArrayElementValue(int type, ElementValue[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.evalues = datums;
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.evalues.length);
        ElementValue[] elementValueArray = this.evalues;
        int n = this.evalues.length;
        int n2 = 0;
        while (n2 < n) {
            ElementValue evalue = elementValueArray[n2];
            evalue.dump(dos);
            ++n2;
        }
    }

    @Override
    public String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.evalues.length) {
            sb.append(this.evalues[i].stringifyValue());
            if (i + 1 < this.evalues.length) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

