/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcStringUtil;
import ext.lib.swg.SwgComboBoxEditor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class SwgComboBox
extends JComboBox {
    private static final long serialVersionUID = -5336516627019603218L;
    protected ComboBoxEditor comboBoxEditor = new SwgComboBoxEditor();
    protected boolean antialias = false;

    public SwgComboBox() throws Exception {
        this.setMaximumRowCount(16);
        this.setEditor(this.comboBoxEditor);
    }

    public SwgComboBox(ComboBoxModel aModel) throws Exception {
        super(aModel);
        this.setMaximumRowCount(16);
        this.setEditor(this.comboBoxEditor);
    }

    public SwgComboBox(Object[] items) throws Exception {
        super(items);
        this.setMaximumRowCount(16);
        this.setEditor(this.comboBoxEditor);
    }

    public SwgComboBox(Vector items) throws Exception {
        super(items);
        this.setMaximumRowCount(16);
        this.setEditor(this.comboBoxEditor);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(preferredSize.width + 12, preferredSize.height);
        return preferredSize;
    }

    @Override
    public void setEditable(boolean aFlag) {
        super.setEditable(aFlag);
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean flag) {
        this.antialias = flag;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialias) {
            HashMap<RenderingHints.Key, Object> newHint = new HashMap<RenderingHints.Key, Object>();
            newHint.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            newHint.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            RenderingHints oldHint = g2.getRenderingHints();
            g2.setRenderingHints(newHint);
            super.paint(g2);
            g2.setRenderingHints(oldHint);
        } else {
            super.paint(g2);
        }
    }

    @Override
    public ComboBoxEditor getEditor() {
        return this.comboBoxEditor;
    }

    @Override
    public void setEditor(ComboBoxEditor comboBoxEditor) {
        this.comboBoxEditor = comboBoxEditor;
    }

    public String getSelectedItemAsString() {
        Object obj = this.getSelectedItem();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String getSelectedItemAsStringNull() {
        String str = this.getSelectedItemAsString();
        if (!BcStringUtil.isEmpty(str)) {
            return str;
        }
        return null;
    }
}

