/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.table.BcTableUtil;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.libx.fx.FxxAbstractDesktopPane;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsDatasourcePane;
import ext.module.xdts.fx.XdtsWordTablePane;
import ext.module.xdts.fx.Z_XdtsWordXmlImportPane;
import ext.module.xdts.model.XdtsProfile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Z_XdtsWordTableMenuPane
extends FxxAbstractDesktopPane {
    FxBorderPane borderPane1 = new FxBorderPane();
    XdtsDatasourcePane datasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.display);
    FxFlowPane controlPane = new FxFlowPane(21);
    FxButton wordExportButton = new FxButton();
    FxButton wordImportButton = new FxButton();
    FxButton intWordButton = new FxButton();
    FxButton addRowtButton;
    MenuItem closeMenuItem;
    XdtsWordTablePane wordTablePane;
    XdtsProfile profile;

    public Z_XdtsWordTableMenuPane() throws Exception {
        this.addRowtButton = new FxButton(BcWords.getInstance().addRow);
        this.closeMenuItem = new MenuItem(BcWords.getInstance().close);
        this.wordTablePane = new XdtsWordTablePane();
    }

    @Override
    protected MenuBar createMenuBar() throws Exception {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = this.createFileMenu();
        if (fileMenu != null) {
            menuBar.getMenus().add((Object)fileMenu);
        }
        menuBar.setMinWidth(400.0);
        return menuBar;
    }

    @Override
    protected Menu createFileMenu() throws Exception {
        Menu menu = new Menu(BcWords.getInstance().file);
        menu.getItems().add((Object)this.closeMenuItem);
        this.closeMenuItem.setOnAction(this.actionEventHandler);
        return menu;
    }

    protected void setContents() throws Exception {
        this.datasourcePane.setPrefSize(840.0, 80.0);
        FxUtil.setEditable((Node)this.datasourcePane, false);
        this.borderPane1.setLeft((Node)this.datasourcePane);
        this.wordExportButton.setOnAction(this.actionEventHandler);
        this.wordExportButton.setGraphic((Node)FxImageHelper.createImageView_icon("export_64x64.png"));
        this.wordExportButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_exportWordXml));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.wordExportButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.wordImportButton.setOnAction(this.actionEventHandler);
        this.wordImportButton.setGraphic((Node)FxImageHelper.createImageView_icon("import_64x64.png"));
        this.wordImportButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_importWordXml));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.wordImportButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.intWordButton.setOnAction(this.actionEventHandler);
        this.intWordButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.intWordButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.addRowtButton.setOnAction(this.actionEventHandler);
        this.addRowtButton.setGraphic((Node)FxImageHelper.createImageView_icon("add_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.addRowtButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.setTop((Node)this.borderPane1);
        this.setCenter((Node)this.wordTablePane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeMenuItem) {
            this.closeAction(ev);
        } else if (ev.getSource() == this.wordExportButton) {
            Z_XdtsWordXmlImportPane wordXmlImportPane = new Z_XdtsWordXmlImportPane(1);
            wordXmlImportPane.show(this.profile, null);
        } else if (ev.getSource() == this.wordImportButton) {
            Z_XdtsWordXmlImportPane wordXmlImportPane = new Z_XdtsWordXmlImportPane(2);
            wordXmlImportPane.show(this.profile, null);
        } else if (ev.getSource() != this.intWordButton && ev.getSource() == this.addRowtButton) {
            BcTableUtil.addRow(this.wordTablePane.swgTableModel, 1);
        }
    }

    protected void closeAction(ActionEvent ev) throws Exception {
        this.close();
    }

    public void close() throws Exception {
        this.stage.close();
        Object o = BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.profile.getDataId());
    }

    protected void show(XdtsProfile profile, Window ownerWindow) throws Exception {
        this.setProfile(profile);
        this.init();
        this.setContents();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    Z_XdtsWordTableMenuPane.this.close();
                }
                catch (Exception ex) {
                    Z_XdtsWordTableMenuPane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        this.stage.setTitle(String.valueOf(XdtsWords.getInstance().logicalNameTable) + ":" + profile.name);
        Image image = FxImageHelper.getImage("dictionary_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowCascade((Window)this.stage, ownerWindow, 0.7f);
        this.stage.show();
    }

    public static void show2(XdtsProfile profile, Window ownerWindow) throws Exception {
        Z_XdtsWordTableMenuPane wordTableMenuPane = (Z_XdtsWordTableMenuPane)((Object)BcInstanceManager.getInstance().get(Z_XdtsWordTableMenuPane.class, profile.getDataId()));
        if (wordTableMenuPane != null) {
            wordTableMenuPane.stage.toFront();
            return;
        }
        wordTableMenuPane = new Z_XdtsWordTableMenuPane();
        BcInstanceManager.getInstance().put(profile.getDataId(), (Object)wordTableMenuPane);
        wordTableMenuPane.show(profile, ownerWindow);
    }
}

