/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import oracle.net.ns.NetException;
import oracle.net.resolver.AddrResolution;
import oracle.net.resolver.NamingAdapterInterface;

public class HostnameNamingAdapter
implements NamingAdapterInterface {
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_PROTOCOL = "TCP";
    String osuser;
    String programName;
    private static final boolean DEBUG = false;
    private boolean allowDefaultPort = true;

    private HostnameNamingAdapter() {
    }

    public HostnameNamingAdapter(String _osuser, String _programName, boolean _allowDefaultPort) {
        this.osuser = _osuser;
        this.programName = _programName;
        this.allowDefaultPort = _allowDefaultPort;
    }

    @Override
    public String resolve(String TNSdesc) throws NetException {
        String connStr;
        int colonOff = 0;
        int sSlashOff = 0;
        int hostOff = 0;
        int rightSqurBrktOff = 0;
        boolean secondFormat = false;
        String trcHdr = "HostnameNamingAdaptor.resolve: ";
        if (TNSdesc.startsWith("//")) {
            TNSdesc = TNSdesc.substring(2);
        } else if (TNSdesc.indexOf("//") != -1) {
            throw new NetException(12261, null, false, TNSdesc);
        }
        if (TNSdesc.charAt(0) == '[') {
            secondFormat = true;
            rightSqurBrktOff = TNSdesc.indexOf(93);
            if (rightSqurBrktOff != -1) {
                colonOff = TNSdesc.indexOf(58, rightSqurBrktOff);
            }
            if (rightSqurBrktOff == -1 || colonOff != -1 && colonOff != rightSqurBrktOff + 1) {
                throw new NetException(12261, null, false, TNSdesc);
            }
            hostOff = 1;
            sSlashOff = TNSdesc.indexOf(47, rightSqurBrktOff);
        } else {
            hostOff = 0;
            colonOff = TNSdesc.indexOf(58);
            sSlashOff = TNSdesc.indexOf(47, hostOff);
        }
        if (sSlashOff != -1 && colonOff > sSlashOff || TNSdesc.endsWith("/") || TNSdesc.endsWith(":")) {
            throw new NetException(12261, null, false, TNSdesc);
        }
        try {
            String service_name;
            int port;
            String host = secondFormat ? TNSdesc.substring(hostOff, rightSqurBrktOff) : (colonOff != -1 ? TNSdesc.substring(hostOff, colonOff) : (sSlashOff != -1 ? TNSdesc.substring(hostOff, sSlashOff) : TNSdesc.substring(hostOff)));
            if (colonOff != -1) {
                port = sSlashOff != -1 ? Integer.parseInt(TNSdesc.substring(colonOff + 1, sSlashOff)) : Integer.parseInt(TNSdesc.substring(colonOff + 1));
            } else {
                if (!this.allowDefaultPort) {
                    throw new NetException(17866);
                }
                port = 1521;
            }
            boolean isServerModePresent = false;
            String serverMode = "";
            if (sSlashOff != -1) {
                int pIndex = TNSdesc.indexOf(58, sSlashOff + 1);
                if (pIndex != -1) {
                    serverMode = TNSdesc.substring(pIndex + 1);
                    isServerModePresent = AddrResolution.SERVER_MODES.contains(serverMode.toUpperCase());
                }
                service_name = isServerModePresent ? TNSdesc.substring(sSlashOff + 1, pIndex) : TNSdesc.substring(sSlashOff + 1);
            } else {
                service_name = "";
            }
            String addressStr = String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", DEFAULT_PROTOCOL, host, port);
            String serverModeStr = isServerModePresent ? String.format("(SERVER=%s)", serverMode) : "";
            String serviceNameStr = String.format("(SERVICE_NAME=%s)", service_name);
            connStr = String.format("(DESCRIPTION=%s%s)", addressStr, String.format("(CONNECT_DATA=%s%s%s)", serviceNameStr, serverModeStr, ""));
        }
        catch (NumberFormatException nfe) {
            throw new NetException(17866);
        }
        return connStr;
    }
}

