/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import ext.base.thread.BcMonitor;
import ext.base.util.BcWords;
import ext.lib.awt.AwtComponentUtil;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;

public class AwtDialog
extends Dialog {
    private static final long serialVersionUID = -8668204858313213277L;
    protected Image offImage;
    protected int eWidth = 800;
    protected int eHeight = 400;
    protected int buttonWidth = 120;
    protected int buttonHeight = 30;
    protected Color backgroundColor;
    protected Panel basePanel = new Panel();
    protected TextArea textArea = new TextArea("", 0, 0, 1);
    protected Button okButton = new Button();
    protected Button noButton = new Button();
    protected Hashtable imageHashtable = new Hashtable();
    protected boolean retBool = false;
    protected BcMonitor paMon;
    public static final int INFORMATION = 1;
    public static final int QUESTION = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    protected int mode = -1;

    public AwtDialog(Frame frame) {
        super(frame);
        super.setLayout(new GridLayout());
        super.add(this.basePanel);
        this.textArea.setEditable(false);
        super.setResizable(false);
        this.okButton.setLabel("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AwtDialog.this.okButtonPressed();
            }
        });
        this.noButton.setLabel("No");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AwtDialog.this.cancelButtonPressed();
            }
        });
    }

    public Image getImage(int mode) {
        Image image = (Image)this.imageHashtable.get(String.valueOf(mode));
        if (image != null) {
            return image;
        }
        String filePath = null;
        switch (mode) {
            case 1: {
                filePath = "icons/inform32.gif";
                break;
            }
            case 2: {
                filePath = "icons/question32.gif";
                break;
            }
            case 3: {
                filePath = "icons/warn32.gif";
                break;
            }
            case 4: {
                filePath = "icons/error32.gif";
            }
        }
        try {
            URL url = super.getClass().getResource(filePath);
            image = super.getToolkit().getImage(url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            this.imageHashtable.put(String.valueOf(mode), image);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return image;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.backgroundColor = this.okButton.getBackground();
        try {
            this.drawOffImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.textArea.setBackground(super.getBackground());
    }

    protected void drawOffImage() throws Exception {
        Graphics g = this.getGraphics();
        g.drawImage(this.getImage(this.mode), 20, 40, null);
    }

    public boolean display(BcMonitor paMon, int mode, String title, Object obj) {
        this.paMon = paMon;
        this.mode = mode;
        super.setModal(true);
        int w = 480;
        int h = 160;
        this.basePanel.removeAll();
        AwtComponentUtil.set(this.basePanel, this.textArea, 60, 20, 400, 60);
        switch (mode) {
            case 1: {
                AwtComponentUtil.set(this.basePanel, this.okButton, (w - this.buttonWidth) / 2, h - this.buttonHeight - 40, this.buttonWidth, this.buttonHeight);
                if (title != null) break;
                title = BcWords.getInstance().confirm;
                break;
            }
            case 2: {
                AwtComponentUtil.set(this.basePanel, this.okButton, w / 2 - this.buttonWidth - 30, h - this.buttonHeight - 40, this.buttonWidth, this.buttonHeight);
                AwtComponentUtil.set(this.basePanel, this.noButton, w / 2 + 30, h - this.buttonHeight - 40, this.buttonWidth, this.buttonHeight);
                if (title != null) break;
                title = "\u9078\u629e";
                break;
            }
            case 3: {
                AwtComponentUtil.set(this.basePanel, this.okButton, (w - this.buttonWidth) / 2, h - this.buttonHeight - 40, this.buttonWidth, this.buttonHeight);
                if (title == null) {
                    title = "\u8b66\u544a";
                }
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            case 4: {
                AwtComponentUtil.set(this.basePanel, this.okButton, (w - this.buttonWidth) / 2, h - this.buttonHeight - 40, this.buttonWidth, this.buttonHeight);
                if (title == null) {
                    title = "error";
                }
                Toolkit.getDefaultToolkit().beep();
                break;
            }
        }
        super.setTitle(title);
        if (obj != null) {
            this.textArea.setText(obj.toString());
        }
        AwtComponentUtil.setCenter(this, w, h);
        super.setVisible(true);
        return this.retBool;
    }

    void setText(String str) {
        this.textArea.setText(str);
    }

    public void addText(String str) {
        this.textArea.append(str);
    }

    protected void close() {
        super.setVisible(false);
    }

    protected void okButtonPressed() {
        this.retBool = true;
        super.setVisible(false);
    }

    protected void cancelButtonPressed() {
        this.retBool = false;
        super.setVisible(false);
    }
}

