/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.Ciphertext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;

final class SSLEngineOutputRecord
extends OutputRecord
implements SSLRecord {
    private HandshakeFragment fragmenter = null;
    private boolean isTalkingToV2 = false;
    private ByteBuffer v2ClientHello = null;
    private volatile boolean isCloseWaiting = false;

    SSLEngineOutputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLWriteCipher.nullTlsWriteCipher());
        this.packetSize = 16709;
        this.protocolVersion = ProtocolVersion.NONE;
    }

    @Override
    public void close() throws IOException {
        this.recordLock.lock();
        try {
            if (!this.isClosed) {
                if (this.fragmenter != null && this.fragmenter.hasAlert()) {
                    this.isCloseWaiting = true;
                } else {
                    super.close();
                }
            }
        }
        finally {
            this.recordLock.unlock();
        }
    }

    @Override
    boolean isClosed() {
        return this.isClosed || this.isCloseWaiting;
    }

    @Override
    void encodeAlert(byte by, byte by2) throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound alert message: " + Alert.nameOf(by2), new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        this.fragmenter.queueUpAlert(by, by2);
    }

    @Override
    void encodeHandshake(byte[] byArray, int n, int n2) throws IOException {
        byte by;
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound handshake message", ByteBuffer.wrap(byArray, n, n2));
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        if (this.firstMessage) {
            this.firstMessage = false;
            if (this.helloVersion == ProtocolVersion.SSL20Hello && byArray[n] == SSLHandshake.CLIENT_HELLO.id && byArray[n + 4 + 2 + 32] == 0) {
                this.v2ClientHello = SSLEngineOutputRecord.encodeV2ClientHello(byArray, n + 4, n2 - 4);
                this.v2ClientHello.position(2);
                this.handshakeHash.deliver(this.v2ClientHello);
                this.v2ClientHello.position(0);
                return;
            }
        }
        if (this.handshakeHash.isHashable(by = byArray[n])) {
            this.handshakeHash.deliver(byArray, n, n2);
        }
        this.fragmenter.queueUpFragment(byArray, n, n2);
    }

    @Override
    void encodeChangeCipherSpec() throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        this.fragmenter.queueUpChangeCipherSpec();
    }

    @Override
    void disposeWriteCipher() {
        if (this.fragmenter == null) {
            this.writeCipher.dispose();
        } else {
            this.fragmenter.queueUpCipherDispose();
        }
    }

    @Override
    void encodeV2NoCipher() throws IOException {
        this.isTalkingToV2 = true;
    }

    @Override
    Ciphertext encode(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        if (this.isClosed) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data or cached messages", new Object[0]);
            }
            return null;
        }
        if (this.isCloseWaiting) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data", new Object[0]);
            }
            byteBufferArray = null;
        }
        return this.encode(byteBufferArray, n, n2, byteBufferArray2[0]);
    }

    private Ciphertext encode(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws IOException {
        int n3;
        if (this.writeCipher.authenticator.seqNumOverflow()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("sequence number extremely close to overflow (2^64-1 packets). Closing connection.", new Object[0]);
            }
            throw new SSLHandshakeException("sequence number overflow");
        }
        Ciphertext ciphertext = this.acquireCiphertext(byteBuffer);
        if (ciphertext != null) {
            return ciphertext;
        }
        if (byteBufferArray == null || byteBufferArray.length == 0) {
            return null;
        }
        int n4 = 0;
        for (n3 = n; n3 < n + n2; ++n3) {
            n4 += byteBufferArray[n3].remaining();
        }
        if (n4 == 0) {
            return null;
        }
        n3 = byteBuffer.limit();
        boolean bl = true;
        int n5 = Math.min(16709, this.packetSize);
        boolean bl2 = true;
        long l = 0L;
        while (bl2) {
            int n6;
            if (bl && this.needToSplitPayload()) {
                bl2 = true;
                n6 = 1;
                bl = false;
            } else {
                bl2 = false;
                if (n5 > 0) {
                    n6 = this.writeCipher.calculateFragmentSize(n5, 5);
                    n6 = Math.min(n6, 16384);
                } else {
                    n6 = 16384;
                }
                n6 = this.calculateFragmentSize(n6);
            }
            int n7 = byteBuffer.position();
            int n8 = n7 + 5 + this.writeCipher.getExplicitNonceSize();
            byteBuffer.position(n8);
            int n9 = Math.min(n6, byteBuffer.remaining());
            n6 = 0;
            int n10 = n + n2;
            for (int i = n; i < n10 && n9 > 0; ++i) {
                int n11 = Math.min(byteBufferArray[i].remaining(), n9);
                int n12 = byteBufferArray[i].limit();
                byteBufferArray[i].limit(byteBufferArray[i].position() + n11);
                byteBuffer.put(byteBufferArray[i]);
                byteBufferArray[i].limit(n12);
                n6 += n11;
                if ((n9 -= n11) <= 0) continue;
                ++n;
                --n2;
            }
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(n8);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.APPLICATION_DATA.name + ", length = " + byteBuffer.remaining(), new Object[0]);
            }
            l = SSLEngineOutputRecord.encrypt(this.writeCipher, ContentType.APPLICATION_DATA.id, byteBuffer, n7, n3, 5, this.protocolVersion);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.limit(byteBuffer2.position());
                byteBuffer2.position(n7);
                SSLLogger.fine("Raw write", byteBuffer2);
            }
            n5 -= byteBuffer.position() - n7;
            byteBuffer.limit(n3);
            if (!this.isFirstAppOutputRecord) continue;
            this.isFirstAppOutputRecord = false;
        }
        return new Ciphertext(ContentType.APPLICATION_DATA.id, SSLHandshake.NOT_APPLICABLE.id, l);
    }

    private Ciphertext acquireCiphertext(ByteBuffer byteBuffer) throws IOException {
        if (this.isTalkingToV2) {
            byteBuffer.put(SSLRecord.v2NoCipher);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new Object[]{SSLRecord.v2NoCipher});
            }
            this.isTalkingToV2 = false;
            return new Ciphertext(ContentType.ALERT.id, SSLHandshake.NOT_APPLICABLE.id, -1L);
        }
        if (this.v2ClientHello != null) {
            if (SSLLogger.isOn) {
                if (SSLLogger.isOn("record")) {
                    SSLLogger.fine(Thread.currentThread().getName() + ", WRITE: SSLv2 ClientHello message, length = " + this.v2ClientHello.remaining(), new Object[0]);
                }
                if (SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw write", this.v2ClientHello);
                }
            }
            byteBuffer.put(this.v2ClientHello);
            this.v2ClientHello = null;
            return new Ciphertext(ContentType.HANDSHAKE.id, SSLHandshake.CLIENT_HELLO.id, -1L);
        }
        if (this.fragmenter != null) {
            return this.fragmenter.acquireCiphertext(byteBuffer);
        }
        return null;
    }

    @Override
    boolean isEmpty() {
        return !this.isTalkingToV2 && this.v2ClientHello == null && (this.fragmenter == null || this.fragmenter.isEmpty());
    }

    boolean needToSplitPayload() {
        return !this.protocolVersion.useTLS11PlusSpec() && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
    }

    final class HandshakeFragment {
        private LinkedList<RecordMemo> handshakeMemos = new LinkedList();

        HandshakeFragment() {
        }

        void queueUpFragment(byte[] byArray, int n, int n2) throws IOException {
            HandshakeMemo handshakeMemo = new HandshakeMemo();
            handshakeMemo.contentType = ContentType.HANDSHAKE.id;
            handshakeMemo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            handshakeMemo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            handshakeMemo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            handshakeMemo.handshakeType = byArray[n];
            handshakeMemo.acquireOffset = 0;
            handshakeMemo.fragment = new byte[n2 - 4];
            System.arraycopy(byArray, n + 4, handshakeMemo.fragment, 0, n2 - 4);
            this.handshakeMemos.add(handshakeMemo);
        }

        void queueUpChangeCipherSpec() {
            RecordMemo recordMemo = new RecordMemo();
            recordMemo.contentType = ContentType.CHANGE_CIPHER_SPEC.id;
            recordMemo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            recordMemo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            recordMemo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            recordMemo.fragment = new byte[1];
            recordMemo.fragment[0] = 1;
            this.handshakeMemos.add(recordMemo);
        }

        void queueUpAlert(byte by, byte by2) {
            RecordMemo recordMemo = new RecordMemo();
            recordMemo.contentType = ContentType.ALERT.id;
            recordMemo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            recordMemo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            recordMemo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            recordMemo.fragment = new byte[2];
            recordMemo.fragment[0] = by;
            recordMemo.fragment[1] = by2;
            this.handshakeMemos.add(recordMemo);
        }

        void queueUpCipherDispose() {
            RecordMemo recordMemo = this.handshakeMemos.peekLast();
            if (recordMemo != null) {
                recordMemo.disposeCipher = true;
            } else {
                SSLEngineOutputRecord.this.writeCipher.dispose();
            }
        }

        Ciphertext acquireCiphertext(ByteBuffer byteBuffer) throws IOException {
            int n;
            if (this.isEmpty()) {
                return null;
            }
            RecordMemo recordMemo = this.handshakeMemos.getFirst();
            HandshakeMemo handshakeMemo = null;
            if (recordMemo.contentType == ContentType.HANDSHAKE.id) {
                handshakeMemo = (HandshakeMemo)recordMemo;
            }
            if (SSLEngineOutputRecord.this.packetSize > 0) {
                n = Math.min(16709, SSLEngineOutputRecord.this.packetSize);
                n = recordMemo.encodeCipher.calculateFragmentSize(n, 5);
            } else {
                n = 16384;
            }
            n = SSLEngineOutputRecord.this.calculateFragmentSize(n);
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            int n4 = n2 + 5 + recordMemo.encodeCipher.getExplicitNonceSize();
            byteBuffer.position(n4);
            if (handshakeMemo != null) {
                int n5;
                for (int i = n; i > 0 && !this.handshakeMemos.isEmpty(); i -= n5) {
                    int n6 = handshakeMemo.fragment.length;
                    if (handshakeMemo.acquireOffset == 0) {
                        if (i <= 4) break;
                        byteBuffer.put(handshakeMemo.handshakeType);
                        byteBuffer.put((byte)(n6 >> 16 & 0xFF));
                        byteBuffer.put((byte)(n6 >> 8 & 0xFF));
                        byteBuffer.put((byte)(n6 & 0xFF));
                        i -= 4;
                    }
                    n5 = Math.min(i, n6 - handshakeMemo.acquireOffset);
                    byteBuffer.put(handshakeMemo.fragment, handshakeMemo.acquireOffset, n5);
                    handshakeMemo.acquireOffset += n5;
                    if (handshakeMemo.acquireOffset != n6) continue;
                    this.handshakeMemos.removeFirst();
                    if (i <= n5 || this.handshakeMemos.isEmpty()) continue;
                    RecordMemo recordMemo2 = this.handshakeMemos.getFirst();
                    if (recordMemo2.contentType == ContentType.HANDSHAKE.id && recordMemo2.encodeCipher == handshakeMemo.encodeCipher) {
                        handshakeMemo = (HandshakeMemo)recordMemo2;
                        continue;
                    }
                    break;
                }
            } else {
                n = Math.min(n, recordMemo.fragment.length);
                byteBuffer.put(recordMemo.fragment, 0, n);
                this.handshakeMemos.removeFirst();
            }
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(n4);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + (Object)((Object)SSLEngineOutputRecord.this.protocolVersion) + " " + ContentType.nameOf(recordMemo.contentType) + ", length = " + byteBuffer.remaining(), new Object[0]);
            }
            long l = OutputRecord.encrypt(recordMemo.encodeCipher, recordMemo.contentType, byteBuffer, n2, n3, 5, ProtocolVersion.valueOf(recordMemo.majorVersion, recordMemo.minorVersion));
            if (recordMemo.disposeCipher) {
                recordMemo.encodeCipher.dispose();
            }
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.limit(byteBuffer2.position());
                byteBuffer2.position(n2);
                SSLLogger.fine("Raw write", byteBuffer2);
            }
            byteBuffer.limit(n3);
            if (handshakeMemo != null) {
                return new Ciphertext(handshakeMemo.contentType, handshakeMemo.handshakeType, l);
            }
            if (SSLEngineOutputRecord.this.isCloseWaiting && recordMemo.contentType == ContentType.ALERT.id) {
                SSLEngineOutputRecord.this.close();
            }
            return new Ciphertext(recordMemo.contentType, SSLHandshake.NOT_APPLICABLE.id, l);
        }

        boolean isEmpty() {
            return this.handshakeMemos.isEmpty();
        }

        boolean hasAlert() {
            for (RecordMemo recordMemo : this.handshakeMemos) {
                if (recordMemo.contentType != ContentType.ALERT.id) continue;
                return true;
            }
            return false;
        }
    }

    private static class HandshakeMemo
    extends RecordMemo {
        byte handshakeType;
        int acquireOffset;

        private HandshakeMemo() {
        }
    }

    private static class RecordMemo {
        byte contentType;
        byte majorVersion;
        byte minorVersion;
        SSLCipher.SSLWriteCipher encodeCipher;
        boolean disposeCipher;
        byte[] fragment;

        private RecordMemo() {
        }
    }
}

