/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public final class ThrowableFormatOptions {
    private static final int DEFAULT_LINES = Integer.MAX_VALUE;
    protected static final ThrowableFormatOptions DEFAULT = new ThrowableFormatOptions();
    private static final String FULL = "full";
    private static final String NONE = "none";
    private static final String SHORT = "short";
    private final TextRenderer textRenderer;
    private final int lines;
    private final String separator;
    private final String suffix;
    private final List<String> ignorePackages;
    public static final String CLASS_NAME = "short.className";
    public static final String METHOD_NAME = "short.methodName";
    public static final String LINE_NUMBER = "short.lineNumber";
    public static final String FILE_NAME = "short.fileName";
    public static final String MESSAGE = "short.message";
    public static final String LOCALIZED_MESSAGE = "short.localizedMessage";

    protected ThrowableFormatOptions(int lines, String separator, List<String> ignorePackages, TextRenderer textRenderer, String suffix) {
        this.lines = lines;
        this.separator = separator == null ? Strings.LINE_SEPARATOR : separator;
        this.ignorePackages = ignorePackages;
        this.textRenderer = textRenderer == null ? PlainTextRenderer.getInstance() : textRenderer;
        this.suffix = suffix;
    }

    protected ThrowableFormatOptions(List<String> packages) {
        this(Integer.MAX_VALUE, null, packages, null, null);
    }

    protected ThrowableFormatOptions() {
        this(Integer.MAX_VALUE, null, null, null, null);
    }

    public int getLines() {
        return this.lines;
    }

    public String getSeparator() {
        return this.separator;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public List<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    public boolean allLines() {
        return this.lines == Integer.MAX_VALUE;
    }

    public boolean anyLines() {
        return this.lines > 0;
    }

    public int minLines(int maxLines) {
        return this.lines > maxLines ? maxLines : this.lines;
    }

    public boolean hasPackages() {
        return this.ignorePackages != null && !this.ignorePackages.isEmpty();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{').append(this.allLines() ? FULL : (this.lines == 2 ? SHORT : (this.anyLines() ? String.valueOf(this.lines) : NONE))).append('}');
        s.append("{separator(").append(this.separator).append(")}");
        if (this.hasPackages()) {
            s.append("{filters(");
            for (String p : this.ignorePackages) {
                s.append(p).append(',');
            }
            s.deleteCharAt(s.length() - 1);
            s.append(")}");
        }
        return s.toString();
    }

    public static ThrowableFormatOptions newInstance(String[] options) {
        if (options == null || options.length == 0) {
            return DEFAULT;
        }
        if (options.length == 1 && Strings.isNotEmpty(options[0])) {
            String[] opts = options[0].split(Patterns.COMMA_SEPARATOR, 2);
            String first = opts[0].trim();
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner scanner = new Scanner(first);){
                if (opts.length > 1 && (first.equalsIgnoreCase(FULL) || first.equalsIgnoreCase(SHORT) || first.equalsIgnoreCase(NONE) || scanner.hasNextInt())) {
                    options = new String[]{first, opts[1].trim()};
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        int lines = ThrowableFormatOptions.DEFAULT.lines;
        String separator = ThrowableFormatOptions.DEFAULT.separator;
        List<String> packages = ThrowableFormatOptions.DEFAULT.ignorePackages;
        TextRenderer ansiRenderer = ThrowableFormatOptions.DEFAULT.textRenderer;
        String suffix = DEFAULT.getSuffix();
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option;
            String rawOption = stringArray[n2];
            if (rawOption != null && !(option = rawOption.trim()).isEmpty()) {
                if (option.startsWith("separator(") && option.endsWith(")")) {
                    separator = option.substring("separator(".length(), option.length() - 1);
                } else if (option.startsWith("filters(") && option.endsWith(")")) {
                    String[] array;
                    String filterStr = option.substring("filters(".length(), option.length() - 1);
                    if (filterStr.length() > 0 && (array = filterStr.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                        packages = new ArrayList<String>(array.length);
                        String[] stringArray2 = array;
                        int n3 = array.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String token = stringArray2[n4];
                            if ((token = token.trim()).length() > 0) {
                                packages.add(token);
                            }
                            ++n4;
                        }
                    }
                } else if (option.equalsIgnoreCase(NONE)) {
                    lines = 0;
                } else if (option.equalsIgnoreCase(SHORT) || option.equalsIgnoreCase(CLASS_NAME) || option.equalsIgnoreCase(METHOD_NAME) || option.equalsIgnoreCase(LINE_NUMBER) || option.equalsIgnoreCase(FILE_NAME) || option.equalsIgnoreCase(MESSAGE) || option.equalsIgnoreCase(LOCALIZED_MESSAGE)) {
                    lines = 2;
                } else if (option.startsWith("ansi(") && option.endsWith(")") || option.equals("ansi")) {
                    if (Loader.isJansiAvailable()) {
                        String styleMapStr = option.equals("ansi") ? "" : option.substring("ansi(".length(), option.length() - 1);
                        String[] stringArray3 = new String[2];
                        stringArray3[1] = styleMapStr;
                        ansiRenderer = new JAnsiTextRenderer(stringArray3, JAnsiTextRenderer.DefaultExceptionStyleMap);
                    } else {
                        StatusLogger.getLogger().warn("You requested ANSI exception rendering but JANSI is not on the classpath. Please see https://logging.apache.org/log4j/2.x/runtime-dependencies.html");
                    }
                } else if (option.startsWith("S(") && option.endsWith(")")) {
                    suffix = option.substring("S(".length(), option.length() - 1);
                } else if (option.startsWith("suffix(") && option.endsWith(")")) {
                    suffix = option.substring("suffix(".length(), option.length() - 1);
                } else if (!option.equalsIgnoreCase(FULL)) {
                    lines = Integers.parseInt(option);
                }
            }
            ++n2;
        }
        return new ThrowableFormatOptions(lines, separator, packages, ansiRenderer, suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }
}

