/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.scheduler;

import ext.base.util.BcISO;
import ext.base.util.BcLocaleUtil;
import ext.scf.scheduler.ScfSchedulerConstants;
import java.io.Serializable;

public class ScfSchedulerWords
implements Serializable {
    private static final long serialVersionUID = 7001384887297359550L;
    private static final ScfSchedulerWords en = new ScfSchedulerWords();
    private static ScfSchedulerWords ja;
    public String timer = "Timer";
    public String trigger = "Trigger";
    public String noSetting = "noSetting";
    public String milliSecond = "milliSecond";
    public String second = "second";
    public String daily = "daily";
    public String weekly = "weekly";
    public String monthly = "monthly";
    public String yearly = "yearly";
    public String onSystemStart = "System Start";
    public String[] triggerNames = new String[]{this.noSetting, this.milliSecond, this.second, this.daily, this.weekly, this.monthly, this.yearly, this.onSystemStart};

    private ScfSchedulerWords() {
    }

    public static ScfSchedulerWords getInstance(String langageCode) {
        ScfSchedulerWords words = en;
        if (BcISO.ISO_639.Japanese.code.equalsIgnoreCase(langageCode)) {
            if (ja == null) {
                ja = new ScfSchedulerWords();
                ja.setJapanese();
            }
            words = ja;
        }
        return words;
    }

    public static ScfSchedulerWords getInstance() {
        return ScfSchedulerWords.getInstance(BcLocaleUtil.getIso639().code);
    }

    public String toTriggerName(int triggerId) {
        int i = 0;
        while (i < ScfSchedulerConstants.triggerIds.length) {
            if (ScfSchedulerConstants.triggerIds[i] == triggerId) {
                return this.triggerNames[i];
            }
            ++i;
        }
        return "error";
    }

    public void setJapanese() {
        this.timer = "\u30bf\u30a4\u30de\u30fc";
        this.trigger = "\u30c8\u30ea\u30ac";
        this.noSetting = "\u672a\u8a2d\u5b9a";
        this.milliSecond = "\u30df\u30ea\u79d2";
        this.second = "\u79d2";
        this.daily = "\u6bce\u65e5";
        this.weekly = "\u6bce\u9031";
        this.monthly = "\u6bce\u6708";
        this.yearly = "\u6bce\u5e74";
        this.onSystemStart = "\u30b7\u30b9\u30c6\u30e0\u8d77\u52d5\u6642";
    }
}

