/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbConstants;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskManager;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import ext.module.xfil.common.FfmpegUtil;
import ext.module.xfil.common.FfprobeUtil;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.dao.XfilCrawlDAO;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilConditionWowk;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVCaptureCondition;
import ext.module.xfil.server.XfilCaptureTask;
import ext.module.xsys.server.XsysBasicTableCreator;
import ext.module.xsys.server.XsysDatasourceUpdater;
import ext.scf5.dao.ScfAbstractIntPropertyDAO;
import ext.scf5.dao.ScfSchemaVersionDAO;
import ext.scf5.dao.ZScfPropertyDAOManager;
import ext.scf5.model.ScfSchemaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class XfilServerUtil
extends BcLoggableObject {
    private DtsSessionFactory dtsSessionFactoryWk;

    private XfilServerUtil() {
    }

    public static XfilServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public void createSummary(DtsSession dtsSession, XfilCrawl crawl) throws Exception {
        XfilUriEntityDAO uriEntitydao = this.getUriEntityDAO();
        List uriEntityList = uriEntitydao.getList(dtsSession, XfilUriEntityDAO.Mode.id, -1L, crawl.id, null, null, null, -1, false);
        crawl.directoryCount = 0L;
        crawl.fileCount = 0L;
        crawl.missingCount = 0L;
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            if (uriEntity.entityType == XfilConstants.FileType.directory.id) {
                ++crawl.directoryCount;
            } else {
                ++crawl.fileCount;
            }
            if (uriEntity.missingDatetime != null) {
                ++crawl.missingCount;
            }
            ++i;
        }
    }

    public BcResult deleteCrawl(DtsSession dtsSessionWk, XfilCrawl crawl) throws Exception {
        BcResult result = new BcResult();
        int cnt = XfilCrawlDAO.getInstance().deleteEntity(dtsSessionWk, crawl);
        if (cnt > 0) {
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            List uriEntityList = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.id, -1L, crawl.id, null, null, null, -1, false);
            this.getLogger().info("URI\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u6570=" + uriEntityList.size());
            int i = 0;
            while (i < uriEntityList.size()) {
                XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
                XfilUtil.deleteTthumbnails(uriEntity);
                ++i;
            }
            long entityId = -1L;
            int deleteCnt = uriEntityDAO.deleteByCrawlId(dtsSessionWk, crawl.id, entityId, false);
            this.getLogger().info("deleteCnt=" + deleteCnt);
        } else {
            result.addError(BcWords.getInstance().Target_object_does_not_exist);
        }
        return result;
    }

    public synchronized DtsSession createDtsSession(Object owner) throws Exception {
        DtsSession dtsSessionWk;
        block12: {
            dtsSessionWk = null;
            if (this.dtsSessionFactoryWk == null) {
                DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
                Throwable throwable = null;
                Object var5_7 = null;
                try (DtsSession dtsSessionMain = dtsSessionFactoryMain.createSession(dtsSessionFactoryMain);){
                    dtsSessionWk = this.createDtsSession_L2(dtsSessionMain, owner);
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            dtsSessionWk = this.dtsSessionFactoryWk.createSession(owner);
        }
        return dtsSessionWk;
    }

    protected synchronized DtsSession createDtsSession_L2(DtsSession dtsSessionMain, Object owner) throws Exception {
        ScfSchemaVersion schemaVersion;
        DtsSessionFactory dtsSessionFactoryMain = dtsSessionMain.getSessionFactory();
        DtsSessionFactory dtsSessionFactoryWk2 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, 1, true);
        dtsSessionFactoryWk2.mmdFieldMap = dtsSessionFactoryMain.mmdFieldMap;
        dtsSessionFactoryWk2.wordManager = dtsSessionFactoryMain.wordManager;
        this.dtsSessionFactoryWk = dtsSessionFactoryWk2;
        DtsSession dtsSessionWk = this.dtsSessionFactoryWk.createSession(owner);
        SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
        if (!sqlContextWk.existTable(dtsSessionWk.getConnection(), OrmSequenceDAO.getInstance().getTableName())) {
            XsysBasicTableCreator basicTableCreator = new XsysBasicTableCreator();
            basicTableCreator.update(dtsSessionWk, 1);
            ScfSchemaVersion schemaVersion2 = new ScfSchemaVersion();
            schemaVersion2.versionId = 3;
            schemaVersion2.updateEndTimestamp = schemaVersion2.updateStartTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion2);
            dtsSessionWk.commit();
        }
        if ((schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSessionWk)) == null) {
            this.getLogger().debug("schemaVersion is null.");
            schemaVersion = new ScfSchemaVersion();
            schemaVersion.versionId = 4;
            schemaVersion.updateEndTimestamp = schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion);
            String sql = "ALTER TABLE frwk_sequence_number ALTER COLUMN sequence_name VARCHAR(255)";
            this.getLogger().debug("sql=" + sql);
            int cnt = SqlUtil.executeUpdate(dtsSessionWk.getConnection(), sql);
            sql = "CREATE TABLE xfil____________________ (dumy VARCHAR(1))";
            cnt = SqlUtil.executeUpdate(dtsSessionWk.getConnection(), sql);
            dtsSessionWk.commit();
        }
        while (schemaVersion.versionId < 5) {
            ++schemaVersion.versionId;
            this.getLogger().debug("schemaVersion.versionId=" + schemaVersion.versionId);
            schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
            XsysDatasourceUpdater datasourceUpdater = new XsysDatasourceUpdater();
            datasourceUpdater.update(dtsSessionWk, schemaVersion.versionId);
            schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion);
            dtsSessionWk.commit();
        }
        return dtsSessionWk;
    }

    public void captureScreen(DtsSession dtsSessionWk, XfilCrawl crawl, XfilAnalysisCondition capturingConditionB, XfilVCaptureCondition captureCondition) throws Exception {
        XfilUriEntityDAO uriEntitydao = this.getUriEntityDAO();
        XfilCaptureTask videoCaptureTask = new XfilCaptureTask();
        videoCaptureTask.setCondition(dtsSessionWk, capturingConditionB, captureCondition, uriEntitydao, crawl.id);
        videoCaptureTask.setName(String.valueOf(XfilWords.getInstance().ScreenCapture.toPlain()) + ":crawlId=" + crawl.id + " " + crawl.name);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(videoCaptureTask);
        executorService.shutdown();
        TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable)videoCaptureTask, future);
        TskTaskManager.getInstance().addCallableUnit(callableUnit);
    }

    public XfilUriEntityDAO getUriEntityDAO() throws Exception {
        XfilUriEntityDAO uriEntitydao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        return uriEntitydao;
    }

    public BcResult validateCapturingCondition(XfilAnalysisCondition crawlConditionB, XfilAnalysisCondition capturingConditionB) throws Exception {
        BcResult result = new BcResult();
        if (!crawlConditionB.execute && capturingConditionB.crawlId <= 0L) {
            result.addError(XfilWords.getInstance().\u30af\u30ed\u30fc\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093);
        }
        return result;
    }

    public BcResult validateCapturingCondition(XfilCaptureParam videoCaptureParam) throws Exception {
        BcResult result = new BcResult();
        if (videoCaptureParam.interval <= 0L) {
            result.addError("\u30ad\u30e3\u30d7\u30c1\u30e3\u9593\u9694\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.top < 0L) {
            result.addError("\u5148\u982d\u30de\u30fc\u30b8\u30f3\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.bottom < 0L) {
            result.addError("\u672b\u5c3e\u30de\u30fc\u30b8\u30f3\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.capturingCountMax <= 0) {
            result.addError("\u6700\u5927\u30ad\u30e3\u30d7\u30c1\u30e3\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        return result;
    }

    public BcResult validateCapturingCondition(DtsSession dtsSessionMain) throws Exception {
        int ret;
        String filePath;
        BcResult result = new BcResult();
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        String value = propertyDAO2.getValue(dtsSessionMain, XdtsConstants.Property.ffprobeFilePath.id);
        if (!BcStringUtil.isEmpty(value)) {
            filePath = AfbApplication.getInstance().toReal(value);
            FfprobeUtil.ffprobePath = filePath = BcFileUtil.toOsPath(filePath);
            ret = FfprobeUtil.checkVersion();
            if (ret != AfbConstants.ExitCode.OK.code) {
                result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        } else {
            result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
        }
        if (!BcStringUtil.isEmpty(value = (propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name())).getValue(dtsSessionMain, XdtsConstants.Property.ffmpegFilePath.id))) {
            filePath = AfbApplication.getInstance().toReal(value);
            FfmpegUtil.ffmpegPath = filePath = BcFileUtil.toOsPath(filePath);
            ret = FfmpegUtil.checkVersion();
            if (ret != AfbConstants.ExitCode.OK.code) {
                result.addError("FFmpeg \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        } else {
            result.addError("FFmpeg \u306e\u30d1\u30b9\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
        }
        return result;
    }

    public BcResult validateCrawlCondition(DtsSession dtsSessionMain, XfilAnalysisCondition crawlConditionB) throws Exception {
        BcResult result = new BcResult();
        XfilConditionWowk crawlCondition = new XfilConditionWowk();
        crawlCondition.dirList = new ArrayList<File>();
        List<String> directoryList = BcCsvUtil.parseCsvRow(crawlConditionB.directory, true);
        for (String directory : directoryList) {
            File file = new File(directory);
            this.getLogger().debug("file=" + file.getPath());
            if (!file.exists()) {
                result.addError(String.format("\u30d1\u30b9 %s \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", file.getPath()));
            }
            if (!file.isDirectory()) {
                result.addError(String.format("\u30d1\u30b9 %s \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093", file.getPath()));
            }
            crawlCondition.dirList.add(file);
        }
        if (BcCollectionUtil.isEmpty(crawlCondition.dirList)) {
            result.addError(String.format("\u5bfe\u8c61\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", new Object[0]));
        }
        crawlCondition.fileExtentionList = BcCsvUtil.parseCsvRow(crawlConditionB.fileExtention, true);
        if (BcCollectionUtil.isEmpty(crawlCondition.fileExtentionList)) {
            result.addError(String.format("\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u62e1\u5f35\u5b50\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", new Object[0]));
        }
        if (BcStringUtil.isEmpty(crawlConditionB.crawlName)) {
            result.addError(String.format(String.valueOf(XfilWords.getInstance().CrawlName.toPlain()) + "\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", new Object[0]));
        }
        result.setUserObject(crawlCondition);
        return result;
    }

    /* synthetic */ XfilServerUtil(XfilServerUtil xfilServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XfilServerUtil instance = new XfilServerUtil(null);

        private SingletonHolder() {
        }
    }
}

