/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1TermsAgreement;
import java.util.List;

public class Wbs1TermsAgreementDAO
extends OrmAbstractDAO<Wbs1TermsAgreement> {
    private Wbs1TermsAgreementDAO() {
        super(new Wbs1TermsAgreement[0]);
        this.setTableName("wbs1_terms_agreement");
    }

    public static Wbs1TermsAgreementDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, Mode mode, String alias, long personId, long termsId) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id = " + personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (termsId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "terms_id = " + termsId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long personId, long termsId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "tmag";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, mode, alias, personId, termsId);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByPersonId(DtsSession dtsSession, long personId, long termsId) throws Exception {
        List<T> entityList = this.getList(dtsSession, Mode.personId_termsId, personId, termsId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1TermsAgreementDAO(Wbs1TermsAgreementDAO wbs1TermsAgreementDAO) {
        this();
    }

    public static enum Mode {
        personId_termsId("person_id, terms_id"),
        personId_agreementDatetime("person_id, agreement_datetime");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1TermsAgreementDAO instance = new Wbs1TermsAgreementDAO(null);

        private SingletonHolder() {
        }
    }
}

