/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.lib.orm.persistence.OrmEntityContext;
import java.util.HashMap;
import java.util.Map;

public class OrmEntityContextManager {
    private Map<String, OrmEntityContext> entityContextMap = new HashMap<String, OrmEntityContext>();

    private OrmEntityContextManager() {
    }

    public static OrmEntityContextManager getInstance() {
        return SingletonHolder.instance;
    }

    public void clear() throws Exception {
        this.entityContextMap.clear();
    }

    public OrmEntityContext getEntityContext(Class entityClass) throws Exception {
        if (entityClass == null) {
            throw new NullPointerException("entityClass is NULL.");
        }
        OrmEntityContext entityContext = this.entityContextMap.get(entityClass.getName());
        if (entityContext != null) {
            return entityContext;
        }
        entityContext = new OrmEntityContext(entityClass);
        this.entityContextMap.put(entityClass.getName(), entityContext);
        return entityContext;
    }

    /* synthetic */ OrmEntityContextManager(OrmEntityContextManager ormEntityContextManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final OrmEntityContextManager instance = new OrmEntityContextManager(null);

        private SingletonHolder() {
        }
    }
}

