/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.tree;

import ext.base.log.BcLogUtil;
import ext.lib.fx.tree.FxTreeCell;
import ext.lib.fx.tree.FxTreeItem;
import ext.lib.fx.tree.FxTreeItemHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;

public class FxTreeView<T>
extends TreeView {
    protected EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent ev) {
            try {
                FxTreeView.this.mouseEventHandle(ev);
            }
            catch (Exception ex) {
                FxTreeView.this.handleException(ex);
            }
        }
    };
    protected EventHandler keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent ev) {
            try {
                FxTreeView.this.keyEventHandle(ev);
            }
            catch (Exception ex) {
                FxTreeView.this.handleException(ex);
            }
        }
    };
    protected ChangeListener<TreeItem> treeItemChangeListener = new ChangeListener<TreeItem>(){

        public void changed(ObservableValue observable, TreeItem oldTreeItem, TreeItem newTreeItem) {
            try {
                FxTreeView.this.selectionChanged(observable, oldTreeItem, newTreeItem);
            }
            catch (Exception ex) {
                FxTreeView.this.handleException(ex);
            }
        }
    };
    protected FileTreeModificationEventHandler treeModificationEventHandler = new FileTreeModificationEventHandler();
    public EventHandler contextMeneEventHandler = new EventHandler(){

        public void handle(Event ev) {
            try {
                FxTreeView.this.contextMenuHandle(ev);
            }
            catch (Exception ex) {
                FxTreeView.this.handleException(ex);
            }
        }
    };

    public void contextMenuHandle(Event ev) throws Exception {
        MenuItem menuItem;
        if (ev.getSource() instanceof MenuItem && (menuItem = (MenuItem)ev.getSource()).getUserData() instanceof FxTreeCell) {
            FxTreeCell treeCell = (FxTreeCell)((Object)menuItem.getUserData());
            FxTreeItem treeItem = (FxTreeItem)treeCell.getTreeItem();
            treeItem.getTreeIF().contextMenuHandle(ev, treeItem);
        }
    }

    public FxTreeView() {
        this.init();
    }

    public FxTreeView(TreeItem<T> rootTreeItem) {
        super(rootTreeItem);
        this.init();
    }

    protected void init() {
        this.getSelectionModel().selectedItemProperty().addListener(this.treeItemChangeListener);
        this.setOnKeyPressed(this.keyEventHandler);
        this.rootProperty().addListener(new ChangeListener<TreeItem<T>>(){

            public void changed(ObservableValue<? extends TreeItem<T>> arg0, TreeItem<T> oldTreeItem, TreeItem<T> newTreeItem) {
                newTreeItem.addEventHandler(TreeItem.childrenModificationEvent(), (EventHandler)FxTreeView.this.treeModificationEventHandler);
                newTreeItem.addEventHandler(TreeItem.branchExpandedEvent(), (EventHandler)FxTreeView.this.treeModificationEventHandler);
                newTreeItem.addEventHandler(TreeItem.branchCollapsedEvent(), (EventHandler)FxTreeView.this.treeModificationEventHandler);
            }
        });
        this.setCellFactory(new Callback<TreeView<T>, TreeCell<T>>(){

            public TreeCell<T> call(TreeView<T> treeView) {
                try {
                    return FxTreeView.this.createTreeCell();
                }
                catch (Exception ex) {
                    FxTreeView.this.handleException(ex);
                    return null;
                }
            }
        });
    }

    protected TreeCell<T> createTreeCell() throws Exception {
        FxTreeCell treeCell = new FxTreeCell();
        treeCell.setOnMousePressed(this.mouseEventHandler);
        treeCell.setOnMouseClicked(this.mouseEventHandler);
        return treeCell;
    }

    protected void treeItemExpanded(TreeItem.TreeModificationEvent<T> ev) throws Exception {
    }

    protected void treeItemCollapsed(TreeItem.TreeModificationEvent<T> ev) throws Exception {
    }

    protected void treeItemChildrenModificated(TreeItem.TreeModificationEvent<T> ev) throws Exception {
    }

    protected void selectionChanged(ObservableValue observable, TreeItem<T> oldTreeItem, TreeItem<T> newTreeItem) throws Exception {
    }

    protected void mouseEventHandle(MouseEvent ev) throws Exception {
        if (ev.getSource() instanceof FxTreeCell) {
            FxTreeCell treeCell = (FxTreeCell)((Object)ev.getSource());
            FxTreeItem treeItem = (FxTreeItem)treeCell.getTreeItem();
            if (ev.getButton() == MouseButton.PRIMARY) {
                if (ev.getEventType() == MouseEvent.MOUSE_CLICKED) {
                    boolean doubleClicked = FxUtil.isDoubleClicked(ev);
                    this.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
                }
            } else if (ev.getButton() == MouseButton.SECONDARY && ev.getEventType() == MouseEvent.MOUSE_PRESSED) {
                ObservableList treeItemList = this.getSelectionModel().getSelectedItems();
                HashMap<Integer, FxTreeItemHelper> treeItemHelperMap = new HashMap<Integer, FxTreeItemHelper>();
                for (FxTreeItem treeItem2 : treeItemList) {
                    if (treeItem2 == null) continue;
                    FxTreeCell treeCell2 = treeItem2.getTreeCell();
                    treeCell2.setContextMenu(null);
                    FxTreeItemHelper treeItemHelper = treeItem2.getTreeIF();
                    treeItemHelperMap.put(treeItemHelper.hashCode(), treeItemHelper);
                }
                if (treeItemHelperMap.size() == 1) {
                    FxTreeItemHelper treeItemHelper = treeItem.getTreeIF();
                    treeItemHelper.setContextMenu(treeItem, treeCell, this.contextMeneEventHandler);
                }
            }
        }
    }

    protected void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        if (treeItem != null) {
            FxTreeItemHelper treeItemHelper = treeItem.getTreeIF();
            treeItemHelper.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        }
    }

    protected void keyEventHandle(KeyEvent ev) throws Exception {
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }

    protected void onDragDetected(MouseEvent ev) {
        BcLogUtil.debug("onDragDetected:ev=" + ev);
        TreeCell treeCell = (TreeCell)ev.getSource();
        Dragboard dragboard = treeCell.startDragAndDrop(TransferMode.ANY);
        dragboard.setDragView((Image)treeCell.snapshot(null, null));
        ClipboardContent content = new ClipboardContent();
        content.putString(treeCell.getItem().toString());
        dragboard.setContent((Map)content);
        ev.consume();
    }

    protected void onDragOver(DragEvent ev) {
        BcLogUtil.debug("onDragOver:ev=" + ev);
        Dragboard dragboard = ev.getDragboard();
        if (dragboard.hasString()) {
            ev.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        }
        ev.consume();
    }

    protected void onDragEntered(DragEvent ev) {
        BcLogUtil.debug("onDragEntered:ev=" + ev);
    }

    protected void onDragExited(DragEvent ev) {
        BcLogUtil.debug("onDragExited:ev=" + ev);
    }

    protected void onDragDropped(DragEvent ev) {
        BcLogUtil.debug("onDragDropped:ev=" + ev);
        Dragboard dragboard = ev.getDragboard();
        boolean success = false;
        if (dragboard.hasString()) {
            System.out.println("Dropped: " + dragboard.getString());
            success = true;
        }
        ev.setDropCompleted(success);
        ev.consume();
    }

    protected void onDragDone(DragEvent ev) {
        BcLogUtil.debug("onDragDone:ev=" + ev);
    }

    protected class FileTreeModificationEventHandler
    implements EventHandler<TreeItem.TreeModificationEvent<T>> {
        protected FileTreeModificationEventHandler() {
        }

        public void handle(TreeItem.TreeModificationEvent<T> ev) {
            if (ev.getEventType() == TreeItem.branchExpandedEvent()) {
                try {
                    FxTreeView.this.treeItemExpanded(ev);
                }
                catch (Exception ex) {
                    FxTreeView.this.handleException(ex);
                }
            } else if (ev.getEventType() == TreeItem.branchCollapsedEvent()) {
                try {
                    FxTreeView.this.treeItemCollapsed(ev);
                }
                catch (Exception ex) {
                    FxTreeView.this.handleException(ex);
                }
            } else if (ev.getEventType() == TreeItem.childrenModificationEvent()) {
                try {
                    FxTreeView.this.treeItemChildrenModificated(ev);
                }
                catch (Exception ex) {
                    FxTreeView.this.handleException(ex);
                }
            } else {
                BcLogUtil.debug(ev);
            }
        }
    }
}

