/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.layout;

import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.skin.FxSkinDefault;
import ext.lib.fx.skin.FxSkinUtil;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxUtil;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class FxTitledPane
extends BorderPane {
    protected BorderPane topBorderPane = new BorderPane();
    protected BorderPane contentBasePane = new BorderPane();
    public HBox toolHBox = new HBox();
    double fontSizeDefault = 12.0;
    double topBorderPadding = 0.0;
    double contentPadding = 3.0;

    public FxTitledPane() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        this.topBorderPane.setRight((Node)this.toolHBox);
        this.setTop((Node)this.topBorderPane);
        FxSkinDefault fxSkin = FxSkinUtil.getSkin();
        Color borderColor = fxSkin.getBaseBrightColor();
        String style = FxCssUtil.css_border(1, 3, borderColor);
        this.contentBasePane.setStyle(style);
        this.contentBasePane.setPadding(new Insets(this.contentPadding));
        this.setCenter((Node)this.contentBasePane);
    }

    public void setTitleNode(Node node) throws Exception {
        if (node != null) {
            this.topBorderPane.setCenter(node);
        } else {
            Node node2 = this.topBorderPane.getLeft();
            if (node2 != null) {
                this.topBorderPane.getChildren().remove((Object)node2);
            }
        }
    }

    public void setTitle(String title, double fontFSize) throws Exception {
        Text text = new Text();
        text.setTextAlignment(TextAlignment.LEFT);
        text.setLineSpacing(2.0);
        text.setText(title);
        FxSkinDefault fxSkin = FxSkinUtil.getSkin();
        text.setFill((Paint)fxSkin.getTextColor());
        Font font = Font.font((String)FxFontUtil.defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)fontFSize);
        text.setFont(font);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 1.0, 0.0, 6.0));
        hBox.getChildren().add((Object)text);
        Dimension2D dim = FxUtil.getTextFieldSize(font, 1);
        dim = new Dimension2D(dim.getWidth(), dim.getHeight() + this.topBorderPadding);
        hBox.setPrefHeight(dim.getHeight());
        this.setTitleNode((Node)hBox);
    }

    public void setTitle(String title) throws Exception {
        this.setTitle(title, this.fontSizeDefault);
    }

    public void setIconNode(Node node) throws Exception {
        if (node != null) {
            this.topBorderPane.setLeft(node);
        } else {
            Node node2 = this.topBorderPane.getLeft();
            if (node2 != null) {
                this.topBorderPane.getChildren().remove((Object)node2);
            }
        }
    }

    public Node getContentNode() throws Exception {
        return this.contentBasePane.getCenter();
    }

    public void setContentNode(Node contentNode) throws Exception {
        this.contentBasePane.setCenter(contentNode);
    }
}

